/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;

public class ClasspathResourceHelper
extends ResourceHelper {
    private static final String BASE_RESOURCE_PATH = "META-INF/resources";
    private boolean cacheTimestamp;

    public ClasspathResourceHelper() {
        WebConfiguration webconfig = WebConfiguration.getInstance();
        this.cacheTimestamp = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CacheResourceModificationTimestamp);
    }

    public String getBaseResourcePath() {
        return BASE_RESOURCE_PATH;
    }

    protected InputStream getNonCompressedInputStream(ResourceInfo resource, FacesContext ctx) throws IOException {
        String path;
        ClassLoader loader = Util.getCurrentLoader(this.getClass());
        InputStream in = loader.getResourceAsStream(path = resource.getPath());
        if (in == null) {
            in = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        return in;
    }

    public URL getURL(ResourceInfo resource, FacesContext ctx) {
        ClassLoader loader = Util.getCurrentLoader(this.getClass());
        URL url = loader.getResource(resource.getPath());
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(resource.getPath());
        }
        return url;
    }

    public LibraryInfo findLibrary(String libraryName, String localePrefix, FacesContext ctx) {
        ClassLoader loader = Util.getCurrentLoader(this);
        String basePath = localePrefix == null ? this.getBaseResourcePath() + '/' + libraryName + '/' : this.getBaseResourcePath() + '/' + localePrefix + '/' + libraryName + '/';
        URL basePathURL = loader.getResource(basePath);
        if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            return null;
        }
        return new LibraryInfo(libraryName, null, localePrefix, this);
    }

    public ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        ClassLoader loader = Util.getCurrentLoader(this);
        String basePath = library != null ? library.getPath() + '/' + resourceName : (localePrefix == null ? this.getBaseResourcePath() + '/' + resourceName : this.getBaseResourcePath() + '/' + localePrefix + '/' + resourceName);
        URL basePathURL = loader.getResource(basePath);
        if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            return null;
        }
        ResourceInfo value = library != null ? new ResourceInfo(library, resourceName, null, compressable, this.resourceSupportsEL(resourceName, ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ResourceInfo(resourceName, null, localePrefix, this, compressable, this.resourceSupportsEL(resourceName, ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        if (value.isCompressable()) {
            value = this.handleCompression(value);
        }
        return value;
    }
}

