/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.editor.FolderBasedController;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class FolderBasedOptionPanel
extends JPanel
implements ActionListener {
    private final FolderBasedController controller;
    private JTextField filter;
    private JLabel filterLabel;
    private JComboBox languageCombo;
    private JLabel languageLabel;
    private JPanel optionsPanel;

    FolderBasedOptionPanel(FolderBasedController controller, Document filterDocument, boolean allowFiltering) {
        this.controller = controller;
        this.initComponents();
        this.filter.setDocument(filterDocument);
        if (!allowFiltering) {
            this.filter.setVisible(false);
            this.filterLabel.setVisible(false);
        }
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof String) {
                    value = EditorSettings.getDefault().getLanguageName((String)value);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        };
        this.languageCombo.setRenderer(renderer);
        this.languageCombo.addActionListener(this);
        this.update();
    }

    void update() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String mimeType : this.controller.getMimeTypes()) {
            model.addElement(mimeType);
        }
        this.languageCombo.setModel(model);
        JTextComponent pane = EditorRegistry.lastFocusedComponent();
        String preSelectMimeType = pane != null ? (String)pane.getDocument().getProperty("mimeType") : "";
        this.languageCombo.setSelectedItem(preSelectMimeType);
        if (!preSelectMimeType.equals(this.languageCombo.getSelectedItem()) && model.getSize() > 0) {
            this.languageCombo.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.languageLabel = new JLabel();
        this.languageCombo = new JComboBox();
        this.optionsPanel = new JPanel();
        this.filter = new JTextField();
        this.filterLabel = new JLabel();
        this.languageLabel.setLabelFor(this.languageCombo);
        Mnemonics.setLocalizedText((JLabel)this.languageLabel, (String)NbBundle.getMessage(FolderBasedOptionPanel.class, (String)"LBL_Language"));
        this.languageCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setLayout(new BorderLayout());
        this.filter.setColumns(10);
        this.filter.setText(NbBundle.getMessage(FolderBasedOptionPanel.class, (String)"FolderBasedOptionPanel.filter.text"));
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(FolderBasedOptionPanel.class, (String)"FolderBasedOptionPanel.filterLabel.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.languageLabel).addPreferredGap(0).add((Component)this.languageCombo, -2, -1, -2).addPreferredGap(0, 30, Short.MAX_VALUE).add((Component)this.filterLabel).addPreferredGap(0).add((Component)this.filter, -2, 114, -2).addContainerGap()).add(2, (Component)this.optionsPanel, -1, 354, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.languageLabel).add((Component)this.languageCombo, -2, -1, -2).add((Component)this.filter, -2, -1, -2).add((Component)this.filterLabel)).addPreferredGap(0).add((Component)this.optionsPanel, -1, 308, Short.MAX_VALUE)));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OptionsPanelController opc;
        this.optionsPanel.setVisible(false);
        this.optionsPanel.removeAll();
        String mimeType = (String)this.languageCombo.getSelectedItem();
        if (mimeType != null && (opc = this.controller.getController(mimeType)) != null) {
            JComponent component = opc.getComponent(this.controller.getLookup());
            this.optionsPanel.add((Component)component, "Center");
            this.optionsPanel.setVisible(true);
        }
        this.searchEnableDisable();
    }

    void setCurrentMimeType(String key) {
        this.languageCombo.setSelectedItem(key);
    }

    void searchEnableDisable() {
        String mimeType = (String)this.languageCombo.getSelectedItem();
        this.filter.setEnabled(mimeType != null ? this.controller.supportsFilter(mimeType) : false);
    }
}

