/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.lucene.search.BooleanQuery;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.customizer.support.DelayedDocumentChangeListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.QueryRequest;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.spi.nodes.MavenNodeFactory;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class AddDependencyPanel
extends JPanel {
    private MavenProject project;
    private final TextValueCompleter groupCompleter;
    private final TextValueCompleter artifactCompleter;
    private final TextValueCompleter versionCompleter;
    private final JButton okButton;
    private final QueryPanel queryPanel;
    private DMListPanel artifactList;
    private Color defaultVersionC;
    private static final RequestProcessor RP = new RequestProcessor(AddDependencyPanel.class.getName(), 5);
    private static final RequestProcessor RPofOpenListPanel = new RequestProcessor(OpenListPanel.class.getName(), 1);
    private static final RequestProcessor RPofDMListPanel = new RequestProcessor(DMListPanel.class.getName(), 1);
    private static final RequestProcessor RPofQueryPanel = new RequestProcessor(QueryPanel.class.getName(), 10);
    private NotificationLineSupport nls;
    private JPanel artifactPanel;
    private JLabel artifactsLabel;
    private JCheckBox chkNbOnly;
    private JComboBox comScope;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JLabel lblArtifactId;
    private JLabel lblGroupId;
    private JLabel lblScope;
    private JLabel lblVersion;
    private JPanel pnlDepMan;
    private JPanel pnlOpen;
    private JPanel pnlOpenProjects;
    private JLabel resultsLabel;
    private JPanel resultsPanel;
    private JTextField searchField;
    private JLabel searchLabel;
    private JPanel searchPanel;
    private JTabbedPane tabPane;
    private JTextField txtArtifactId;
    private JTextField txtGroupId;
    private JTextField txtVersion;
    private static Node noResultsNode;
    private static Node searchingNode;
    private static Node tooGeneralNode;
    private static final Object LOCK;
    private static final Object DM_DEPS_LOCK;

    public AddDependencyPanel(MavenProject mavenProject, boolean showDepMan, Project prj) {
        this.project = mavenProject;
        this.initComponents();
        this.groupCompleter = new TextValueCompleter(Collections.<String>emptyList(), this.txtGroupId);
        this.artifactCompleter = new TextValueCompleter(Collections.<String>emptyList(), this.txtArtifactId);
        this.versionCompleter = new TextValueCompleter(Collections.<String>emptyList(), this.txtVersion);
        this.txtGroupId.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (AddDependencyPanel.this.txtGroupId.getText().trim().length() > 0) {
                    AddDependencyPanel.this.artifactCompleter.setLoading(true);
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            AddDependencyPanel.this.populateArtifact();
                        }
                    });
                }
            }
        });
        this.txtArtifactId.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (AddDependencyPanel.this.txtGroupId.getText().trim().length() > 0 && AddDependencyPanel.this.txtArtifactId.getText().trim().length() > 0) {
                    AddDependencyPanel.this.versionCompleter.setLoading(true);
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            AddDependencyPanel.this.populateVersion();
                        }
                    });
                }
            }
        });
        this.okButton = new JButton(NbBundle.getMessage(AddDependencyPanel.class, (String)"BTN_OK"));
        DocumentListener docList = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddDependencyPanel.this.checkValidState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddDependencyPanel.this.checkValidState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddDependencyPanel.this.checkValidState();
            }
        };
        this.txtGroupId.getDocument().addDocumentListener(docList);
        this.txtVersion.getDocument().addDocumentListener(docList);
        this.txtArtifactId.getDocument().addDocumentListener(docList);
        this.checkValidState();
        this.groupCompleter.setLoading(true);
        RP.post(new Runnable(){

            @Override
            public void run() {
                AddDependencyPanel.this.populateGroupId();
            }
        });
        this.queryPanel = new QueryPanel();
        this.resultsPanel.add((Component)this.queryPanel, "Center");
        this.searchField.getDocument().addDocumentListener(DelayedDocumentChangeListener.create(this.searchField.getDocument(), this.queryPanel, 500));
        this.defaultVersionC = this.txtVersion.getForeground();
        if (showDepMan) {
            this.artifactList = new DMListPanel(this.project);
            this.artifactPanel.add((Component)this.artifactList, "Center");
        } else {
            this.tabPane.setEnabledAt(2, false);
        }
        this.chkNbOnly.setVisible(false);
        String packaging = mavenProject.getPackaging();
        if ("nbm".equals(packaging) || "nbm-application".equals(packaging)) {
            this.chkNbOnly.setVisible(true);
            this.chkNbOnly.setSelected(true);
        }
        this.pnlOpenProjects.add((Component)new OpenListPanel(prj), "Center");
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public String getGroupId() {
        return this.txtGroupId.getText().trim();
    }

    public String getArtifactId() {
        return this.txtArtifactId.getText().trim();
    }

    public String getVersion() {
        return this.txtVersion.getText().trim();
    }

    public String getScope() {
        String scope = this.comScope.getSelectedItem().toString();
        if ("compile".equals(scope)) {
            scope = null;
        }
        return scope;
    }

    public void attachDialogDisplayer(DialogDescriptor dd) {
        this.nls = dd.getNotificationLineSupport();
        if (this.nls == null) {
            this.nls = dd.createNotificationLineSupport();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        assert (this.nls != null) : " The notificationLineSupport was not attached to the panel.";
    }

    void setSelectedScope(String type) {
        this.comScope.setSelectedItem(type);
    }

    private void checkValidState() {
        String version;
        String aId;
        String gId = this.txtGroupId.getText().trim();
        if (gId.length() <= 0) {
            gId = null;
        }
        if ((aId = this.txtArtifactId.getText().trim()).length() <= 0) {
            aId = null;
        }
        if ((version = this.txtVersion.getText().trim()).length() <= 0) {
            version = null;
        }
        boolean dmDefined = this.tabPane.isEnabledAt(2);
        if (this.artifactList != null) {
            Color c = this.defaultVersionC;
            String warn = null;
            if (dmDefined && AddDependencyPanel.findConflict(this.artifactList.getDMDeps(), gId, aId, version, null) == 1) {
                c = Color.RED;
                warn = NbBundle.getMessage(AddDependencyPanel.class, (String)"MSG_VersionConflict");
            }
            this.txtVersion.setForeground(c);
            if (warn != null) {
                this.nls.setWarningMessage(warn);
            } else {
                this.nls.clearMessages();
            }
        }
        if (gId == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (aId == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (version == null && !dmDefined) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(true);
    }

    private static Border getNbScrollPaneBorder() {
        Border b = UIManager.getBorder("Nb.ScrollPane.border");
        if (b == null) {
            Color c = UIManager.getColor("controlShadow");
            b = new LineBorder(c != null ? c : Color.GRAY);
        }
        return b;
    }

    private void initComponents() {
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblArtifactId = new JLabel();
        this.txtArtifactId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblScope = new JLabel();
        this.comScope = new JComboBox();
        this.tabPane = new JTabbedPane();
        this.searchPanel = new JPanel();
        this.searchLabel = new JLabel();
        this.searchField = new JTextField();
        this.jLabel1 = new JLabel();
        this.resultsLabel = new JLabel();
        this.resultsPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.chkNbOnly = new JCheckBox();
        this.pnlOpen = new JPanel();
        this.jLabel3 = new JLabel();
        this.pnlOpenProjects = new JPanel();
        this.pnlDepMan = new JPanel();
        this.artifactsLabel = new JLabel();
        this.artifactPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.lblGroupId.setLabelFor(this.txtGroupId);
        Mnemonics.setLocalizedText((JLabel)this.lblGroupId, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"LBL_GroupId"));
        this.lblArtifactId.setLabelFor(this.txtArtifactId);
        Mnemonics.setLocalizedText((JLabel)this.lblArtifactId, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"LBL_ArtifactId"));
        this.lblVersion.setLabelFor(this.txtVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblVersion, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"LBL_Version"));
        this.lblScope.setLabelFor(this.comScope);
        Mnemonics.setLocalizedText((JLabel)this.lblScope, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"LBL_Scope"));
        this.comScope.setModel(new DefaultComboBoxModel<String>(new String[]{"compile", "runtime", "test", "provided"}));
        this.searchPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                AddDependencyPanel.this.searchPanelComponentShown(evt);
            }
        });
        this.searchLabel.setLabelFor(this.searchField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.searchLabel.text", (Object[])new Object[0]));
        this.searchField.setText(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.searchField.text", (Object[])new Object[0]));
        this.jLabel1.setForeground(UIManager.getDefaults().getColor("textInactiveText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.jLabel1.text", (Object[])new Object[0]));
        Mnemonics.setLocalizedText((JLabel)this.resultsLabel, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.resultsLabel.text", (Object[])new Object[0]));
        this.resultsPanel.setBorder(AddDependencyPanel.getNbScrollPaneBorder());
        this.resultsPanel.setLayout(new BorderLayout());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 76, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 18, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkNbOnly, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.chkNbOnly.text"));
        this.chkNbOnly.setToolTipText(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.chkNbOnly.toolTipText"));
        this.chkNbOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddDependencyPanel.this.chkNbOnlyActionPerformed(evt);
            }
        });
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(searchPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.searchLabel).addGap(4, 4, 4).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, searchPanelLayout.createSequentialGroup().addComponent(this.searchField, -1, 351, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkNbOnly)))).addGroup(GroupLayout.Alignment.LEADING, searchPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultsPanel, -1, 555, Short.MAX_VALUE).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.resultsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 252, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addGap(106, 106, 106))))).addContainerGap()));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchLabel).addComponent(this.searchField, -2, -1, -2).addComponent(this.chkNbOnly)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.resultsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultsPanel, -1, 206, Short.MAX_VALUE).addContainerGap()));
        this.searchField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.searchField.AccessibleContext.accessibleDescription"));
        this.resultsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.resultsLabel.AccessibleContext.accessibleDescription"));
        this.tabPane.addTab(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.searchPanel.TabConstraints.tabTitle", (Object[])new Object[0]), null, this.searchPanel, NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.searchPanel.TabConstraints.tabToolTip"));
        this.jLabel3.setLabelFor(this.pnlOpenProjects);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.jLabel3.text"));
        this.pnlOpenProjects.setLayout(new BorderLayout());
        GroupLayout pnlOpenLayout = new GroupLayout(this.pnlOpen);
        this.pnlOpen.setLayout(pnlOpenLayout);
        pnlOpenLayout.setHorizontalGroup(pnlOpenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlOpenLayout.createSequentialGroup().addContainerGap().addGroup(pnlOpenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlOpenProjects, -1, 555, Short.MAX_VALUE).addComponent(this.jLabel3)).addContainerGap()));
        pnlOpenLayout.setVerticalGroup(pnlOpenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlOpenLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlOpenProjects, -1, 262, Short.MAX_VALUE).addContainerGap()));
        this.tabPane.addTab(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.pnlOpen.TabConstraints.tabTitle"), null, this.pnlOpen, NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.pnlOpen.TabConstraints.tabToolTip"));
        Mnemonics.setLocalizedText((JLabel)this.artifactsLabel, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.artifactsLabel.text", (Object[])new Object[0]));
        this.artifactPanel.setBorder(AddDependencyPanel.getNbScrollPaneBorder());
        this.artifactPanel.setLayout(new BorderLayout());
        this.jLabel2.setForeground(UIManager.getDefaults().getColor("textInactiveText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.jLabel2.text", (Object[])new Object[0]));
        this.artifactPanel.add((Component)this.jLabel2, "Last");
        GroupLayout pnlDepManLayout = new GroupLayout(this.pnlDepMan);
        this.pnlDepMan.setLayout(pnlDepManLayout);
        pnlDepManLayout.setHorizontalGroup(pnlDepManLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDepManLayout.createSequentialGroup().addContainerGap().addGroup(pnlDepManLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.artifactPanel, -1, 555, Short.MAX_VALUE).addComponent(this.artifactsLabel)).addContainerGap()));
        pnlDepManLayout.setVerticalGroup(pnlDepManLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDepManLayout.createSequentialGroup().addContainerGap().addComponent(this.artifactsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.artifactPanel, -1, 262, Short.MAX_VALUE).addContainerGap()));
        this.tabPane.addTab(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.pnlDepMan.TabConstraints.tabTitle", (Object[])new Object[0]), null, this.pnlDepMan, NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.pnlDepMan.TabConstraints.tabToolTip"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGroupId).addComponent(this.lblArtifactId).addComponent(this.lblVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtArtifactId, -1, 463, Short.MAX_VALUE).addComponent(this.txtGroupId, -1, 463, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.txtVersion, -1, 287, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblScope).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comScope, -2, -1, -2))).addContainerGap()).addComponent(this.tabPane, -1, 583, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGroupId).addComponent(this.txtGroupId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblArtifactId).addComponent(this.txtArtifactId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblVersion).addComponent(this.txtVersion, -2, -1, -2).addComponent(this.comScope, -2, -1, -2).addComponent(this.lblScope)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tabPane, -1, 344, Short.MAX_VALUE)));
        this.txtGroupId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.txtGroupId.AccessibleContext.accessibleDescription"));
        this.txtArtifactId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.txtArtifactId.AccessibleContext.accessibleDescription"));
        this.txtVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.txtVersion.AccessibleContext.accessibleDescription"));
        this.comScope.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.comScope.AccessibleContext.accessibleDescription"));
        this.tabPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.tabPane.AccessibleContext.accessibleDescription"));
    }

    private void searchPanelComponentShown(ComponentEvent evt) {
        this.searchField.requestFocus();
    }

    private void chkNbOnlyActionPerformed(ActionEvent evt) {
        this.queryPanel.stateChanged(new ChangeEvent(this.searchField.getDocument()));
    }

    private void populateGroupId() {
        assert (!SwingUtilities.isEventDispatchThread());
        final ArrayList lst = new ArrayList(RepositoryQueries.getGroups((RepositoryInfo[])new RepositoryInfo[0]));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddDependencyPanel.this.groupCompleter.setValueList(lst);
            }
        });
    }

    private void populateArtifact() {
        assert (!SwingUtilities.isEventDispatchThread());
        final ArrayList lst = new ArrayList(RepositoryQueries.getArtifacts((String)this.txtGroupId.getText().trim(), (RepositoryInfo[])new RepositoryInfo[0]));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddDependencyPanel.this.artifactCompleter.setValueList(lst);
            }
        });
    }

    private void populateVersion() {
        assert (!SwingUtilities.isEventDispatchThread());
        List lst = RepositoryQueries.getVersions((String)this.txtGroupId.getText().trim(), (String)this.txtArtifactId.getText().trim(), (RepositoryInfo[])new RepositoryInfo[0]);
        final ArrayList<String> vers = new ArrayList<String>();
        for (NBVersionInfo rec : lst) {
            if (vers.contains(rec.getVersion())) continue;
            vers.add(rec.getVersion());
        }
        ArrayList<String> propList = new ArrayList<String>();
        for (Object propKey : this.project.getProperties().keySet()) {
            String key = (String)propKey;
            if (!key.endsWith(".version")) continue;
            propList.add("${" + key + "}");
        }
        Collections.sort(propList);
        vers.addAll(propList);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddDependencyPanel.this.versionCompleter.setValueList(vers);
            }
        });
    }

    private static List<Dependency> getDepencenciesFromDM(MavenProject project) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        HashSet<String> knownKeys = new HashSet<String>();
        for (MavenProject localProj = project; localProj != null; localProj = localProj.getParent()) {
            DependencyManagement curDM = localProj.getDependencyManagement();
            if (curDM == null) continue;
            List ds = curDM.getDependencies();
            for (Dependency d : ds) {
                if (knownKeys.contains(d.getManagementKey())) continue;
                result.add(d);
                knownKeys.add(d.getManagementKey());
            }
        }
        return result;
    }

    private static int findConflict(List<Dependency> deps, String groupId, String artifactId, String version, String scope) {
        if (deps == null) {
            return 0;
        }
        for (Dependency dep : deps) {
            if (artifactId == null || !artifactId.equals(dep.getArtifactId()) || groupId == null || !groupId.equals(dep.getGroupId())) continue;
            if (version != null && !version.equals(dep.getVersion())) {
                return 1;
            }
            if (!(scope != null ? !scope.equals(dep.getScope()) : dep.getScope() != null)) continue;
            return 2;
        }
        return 0;
    }

    void setFields(String groupId, String artifactId, String version) {
        boolean sameGrId = false;
        if (groupId != null && groupId.equals(this.project.getGroupId())) {
            groupId = "${project.groupId}";
            sameGrId = true;
        }
        this.txtGroupId.setText(groupId);
        this.txtArtifactId.setText(artifactId);
        if (sameGrId && version != null && version.equals(this.project.getVersion())) {
            version = "${project.version}";
        }
        this.txtVersion.setText(version);
    }

    private static Node getNoResultsNode() {
        if (noResultsNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/resources/empty.png");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Empty");
            nd.setDisplayName(NbBundle.getMessage(QueryPanel.class, (String)"LBL_Node_Empty"));
            noResultsNode = nd;
        }
        return new FilterNode(noResultsNode, Children.LEAF);
    }

    private static Node getSearchingNode() {
        if (searchingNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/resources/wait.gif");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Searching");
            nd.setDisplayName(NbBundle.getMessage(QueryPanel.class, (String)"LBL_Node_Searching"));
            searchingNode = nd;
        }
        return new FilterNode(searchingNode, Children.LEAF);
    }

    private static Node getTooGeneralNode() {
        if (tooGeneralNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/resources/empty.png");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Too General");
            nd.setDisplayName(NbBundle.getMessage(QueryPanel.class, (String)"LBL_Node_TooGeneral"));
            tooGeneralNode = nd;
        }
        return new FilterNode(tooGeneralNode, Children.LEAF);
    }

    private void changeSelection(Lookup context) {
        new DefAction(false, context).actionPerformed(null);
    }

    private Node createFilterWithDefaultAction(Node nd, boolean leaf) {
        return new FilterNodeWithDefAction(nd, leaf);
    }

    static {
        LOCK = new Object();
        DM_DEPS_LOCK = new Object();
    }

    class FilterNodeWithDefAction
    extends FilterNode {
        public FilterNodeWithDefAction(Node nd, boolean leaf) {
            super(nd, (Children)(leaf ? FilterNode.Children.LEAF : new FilterNode.Children(nd){

                protected Node[] createNodes(Node key) {
                    return new Node[]{AddDependencyPanel.this.createFilterWithDefaultAction(key, true)};
                }
            }));
        }

        public Action getPreferredAction() {
            return new DefAction(true, this.getOriginal().getLookup());
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public Node getOriginal() {
            return super.getOriginal();
        }
    }

    private class DefAction
    extends AbstractAction
    implements ContextAwareAction,
    Runnable {
        private final boolean close;
        private final Lookup lookup;

        public DefAction(boolean closeNow, Lookup look) {
            this.close = closeNow;
            this.lookup = look;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NBVersionInfo vi;
            Project prj = (Project)this.lookup.lookup(Project.class);
            boolean set = false;
            if (prj != null) {
                NbMavenProject mav = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
                MavenProject m = mav.getMavenProject();
                AddDependencyPanel.this.setFields(m.getGroupId(), m.getArtifactId(), m.getVersion());
                set = true;
            }
            if (!set && (vi = (NBVersionInfo)this.lookup.lookup(NBVersionInfo.class)) != null) {
                String ver = AddDependencyPanel.this.queryPanel.isVisible() ? vi.getVersion() : "";
                AddDependencyPanel.this.setFields(vi.getGroupId(), vi.getArtifactId(), ver);
                set = true;
            }
            if (set) {
                if (this.close) {
                    AddDependencyPanel.this.getOkButton().doClick();
                } else {
                    AddDependencyPanel.this.artifactCompleter.setLoading(true);
                    AddDependencyPanel.this.versionCompleter.setLoading(true);
                    RP.post((Runnable)this);
                }
            } else {
                AddDependencyPanel.this.setFields("", "", "");
                AddDependencyPanel.this.artifactCompleter.setValueList(Collections.<String>emptyList());
                AddDependencyPanel.this.versionCompleter.setValueList(Collections.<String>emptyList());
            }
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new DefAction(this.close, actionContext);
        }

        @Override
        public void run() {
            AddDependencyPanel.this.populateArtifact();
            AddDependencyPanel.this.populateVersion();
        }
    }

    private class OpenListPanel
    extends JPanel
    implements ExplorerManager.Provider,
    PropertyChangeListener,
    Runnable {
        private BeanTreeView btv;
        private ExplorerManager manager;
        private Project project;

        public OpenListPanel(Project project) {
            this.project = project;
            this.btv = new BeanTreeView();
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(true);
            this.btv.setUseSubstringInQuickSearch(true);
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.btv, "Center");
            RPofOpenListPanel.post((Runnable)this);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Node[] selNodes = this.manager.getSelectedNodes();
            AddDependencyPanel.this.changeSelection(selNodes.length == 1 ? selNodes[0].getLookup() : Lookup.EMPTY);
        }

        @Override
        public void run() {
            Project[] prjs = OpenProjects.getDefault().getOpenProjects();
            final ArrayList<Node> toRet = new ArrayList<Node>();
            for (Project p : prjs) {
                NbMavenProject mav;
                if (p == this.project || (mav = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class)) == null) continue;
                LogicalViewProvider lvp = (LogicalViewProvider)p.getLookup().lookup(LogicalViewProvider.class);
                toRet.add(AddDependencyPanel.this.createFilterWithDefaultAction(lvp.createLogicalView(), true));
            }
            Children.Array ch = new Children.Array();
            ch.add(toRet.toArray(new Node[0]));
            AbstractNode root = new AbstractNode((Children)ch);
            this.getExplorerManager().setRootContext((Node)root);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean opEmpty = toRet.isEmpty();
                    AddDependencyPanel.this.tabPane.setEnabledAt(1, !opEmpty);
                }
            });
        }
    }

    private class DMListPanel
    extends JPanel
    implements ExplorerManager.Provider,
    AncestorListener,
    ActionListener,
    PropertyChangeListener,
    Runnable {
        private BeanTreeView btv;
        private ExplorerManager manager;
        private MavenProject project;
        private Node noDMRoot;
        private List<Dependency> dmDeps;

        public DMListPanel(MavenProject project) {
            this.project = project;
            this.btv = new BeanTreeView();
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(true);
            this.btv.setUseSubstringInQuickSearch(true);
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.btv, "Center");
            this.addAncestorListener(this);
            AddDependencyPanel.this.artifactsLabel.setLabelFor((Component)this.btv);
            RPofDMListPanel.post((Runnable)this);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        private NBVersionInfo convert2VInfo(Dependency dep) {
            return new NBVersionInfo(null, dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), null, null, null, dep.getClassifier());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Dependency> getDMDeps() {
            Object object = DM_DEPS_LOCK;
            synchronized (object) {
                return this.dmDeps;
            }
        }

        private void loadArtifacts() {
            List<Dependency> deps = this.getDMDeps();
            if (deps == null || deps.isEmpty()) {
                if (this.noDMRoot == null) {
                    AbstractNode nd = new AbstractNode(Children.LEAF){

                        public Image getIcon(int arg0) {
                            return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/resources/empty.png");
                        }

                        public Image getOpenedIcon(int arg0) {
                            return this.getIcon(arg0);
                        }
                    };
                    nd.setName("Empty");
                    nd.setDisplayName(NbBundle.getMessage(DMListPanel.class, (String)"LBL_DM_Empty"));
                    Children.Array array = new Children.Array();
                    array.add(new Node[]{nd});
                    this.noDMRoot = new AbstractNode((Children)array);
                }
                this.manager.setRootContext(this.noDMRoot);
            } else {
                Children.Array array = new Children.Array();
                AbstractNode root = new AbstractNode((Children)array);
                for (Dependency dep : deps) {
                    array.add(new Node[]{AddDependencyPanel.this.createFilterWithDefaultAction((Node)MavenNodeFactory.createVersionNode(this.convert2VInfo(dep), true), true)});
                }
                this.manager.setRootContext((Node)root);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.loadArtifacts();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Node[] selNodes = this.manager.getSelectedNodes();
            AddDependencyPanel.this.changeSelection(selNodes.length == 1 ? selNodes[0].getLookup() : Lookup.EMPTY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DM_DEPS_LOCK;
            synchronized (object) {
                this.dmDeps = AddDependencyPanel.getDepencenciesFromDM(this.project);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean dmEmpty = DMListPanel.this.dmDeps.isEmpty();
                    AddDependencyPanel.this.tabPane.setEnabledAt(2, !dmEmpty);
                }
            });
        }
    }

    private class QueryPanel
    extends JPanel
    implements ExplorerManager.Provider,
    Comparator<String>,
    PropertyChangeListener,
    ChangeListener,
    Observer {
        private QueryRequest queryRequest;
        private BeanTreeView btv = new BeanTreeView();
        private ExplorerManager manager;
        private ResultsRootNode resultsRootNode;
        private String inProgressText;
        private String lastQueryText;
        private String curTypedText;
        private Color defSearchC;

        private QueryPanel() {
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(true);
            this.btv.setUseSubstringInQuickSearch(true);
            this.manager = new ExplorerManager();
            this.setLayout(new BorderLayout());
            this.add((Component)this.btv, "Center");
            this.defSearchC = AddDependencyPanel.this.searchField.getForeground();
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            AddDependencyPanel.this.resultsLabel.setLabelFor((Component)this.btv);
            this.btv.getAccessibleContext().setAccessibleDescription(AddDependencyPanel.this.resultsLabel.getAccessibleContext().getAccessibleDescription());
            this.queryRequest = null;
            this.resultsRootNode = new ResultsRootNode();
            this.manager.setRootContext((Node)this.resultsRootNode);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Document doc = (Document)e.getSource();
            try {
                this.curTypedText = doc.getText(0, doc.getLength()).trim();
            }
            catch (BadLocationException ex) {
                return;
            }
            AddDependencyPanel.this.searchField.setForeground(this.defSearchC);
            if (this.curTypedText.length() > 0) {
                this.find(this.curTypedText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void find(String queryText) {
            Object object = LOCK;
            synchronized (object) {
                if (this.inProgressText != null) {
                    this.lastQueryText = queryText;
                    if (null != this.queryRequest) {
                        this.queryRequest.deleteObserver((Observer)this);
                    }
                    return;
                }
                this.inProgressText = queryText;
                this.lastQueryText = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryPanel.this.resultsRootNode.setOneChild(AddDependencyPanel.getSearchingNode());
                    AddDependencyPanel.this.searchField.setForeground(QueryPanel.this.defSearchC);
                    AddDependencyPanel.this.nls.clearMessages();
                }
            });
            ArrayList<QueryField> fields = new ArrayList<QueryField>();
            final ArrayList<QueryField> fieldsNonClasses = new ArrayList<QueryField>();
            String q = queryText.trim();
            String[] splits = q.split(" ");
            ArrayList<String> fStrings = new ArrayList<String>();
            fStrings.add("groupId");
            fStrings.add("artifactId");
            fStrings.add("version");
            fStrings.add("name");
            fStrings.add("description");
            fStrings.add("classes");
            for (String curText : splits) {
                for (String fld : fStrings) {
                    QueryField f = new QueryField();
                    f.setField(fld);
                    f.setValue(curText);
                    fields.add(f);
                    if ("classes".equals(fld)) continue;
                    fieldsNonClasses.add(f);
                }
            }
            this.queryRequest = new QueryRequest(fields, null, (Observer)this);
            RequestProcessor.Task t = RPofQueryPanel.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        RepositoryQueries.find((QueryRequest)QueryPanel.this.queryRequest);
                    }
                    catch (BooleanQuery.TooManyClauses exc) {
                        if (QueryPanel.this.queryRequest.countObservers() > 0) {
                            try {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        AddDependencyPanel.this.nls.setInformationMessage(NbBundle.getMessage(AddDependencyPanel.class, (String)"MSG_ClassesExcluded"));
                                    }
                                });
                                QueryPanel.this.queryRequest.changeFields(fieldsNonClasses);
                                RepositoryQueries.find((QueryRequest)QueryPanel.this.queryRequest);
                            }
                            catch (BooleanQuery.TooManyClauses exc2) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        AddDependencyPanel.this.searchField.setForeground(Color.RED);
                                        AddDependencyPanel.this.nls.setWarningMessage(NbBundle.getMessage(AddDependencyPanel.class, (String)"MSG_TooGeneral"));
                                        QueryPanel.this.resultsRootNode.setOneChild(AddDependencyPanel.getTooGeneralNode());
                                    }
                                });
                            }
                        }
                    }
                    catch (OutOfMemoryError oome) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AddDependencyPanel.this.searchField.setForeground(Color.RED);
                                AddDependencyPanel.this.nls.setWarningMessage(NbBundle.getMessage(AddDependencyPanel.class, (String)"MSG_TooGeneral"));
                                QueryPanel.this.resultsRootNode.setOneChild(AddDependencyPanel.getTooGeneralNode());
                            }
                        });
                    }
                }
            });
            t.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(Task task) {
                    Object object = LOCK;
                    synchronized (object) {
                        String localText = QueryPanel.this.inProgressText;
                        QueryPanel.this.inProgressText = null;
                        if (QueryPanel.this.lastQueryText != null && !QueryPanel.this.lastQueryText.equals(localText)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (QueryPanel.this.lastQueryText != null) {
                                        QueryPanel.this.find(QueryPanel.this.lastQueryText);
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        private void updateResultNodes(List<String> keyList, Map<String, List<NBVersionInfo>> map) {
            if (keyList.size() > 0) {
                HashMap<String, Node> currentNodes = new HashMap<String, Node>();
                for (Node nd : this.resultsRootNode.getChildren().getNodes()) {
                    currentNodes.put(nd.getName(), nd);
                }
                ArrayList<Node> newNodes = new ArrayList<Node>(keyList.size());
                if (null != this.queryRequest && !this.queryRequest.isFinished()) {
                    newNodes.add(AddDependencyPanel.getSearchingNode());
                }
                for (String key : keyList) {
                    Node nd;
                    nd = (Node)currentNodes.get(key);
                    if (null != nd) {
                        ((MavenNodeFactory.ArtifactNode)((FilterNodeWithDefAction)nd).getOriginal()).setVersionInfos(map.get(key));
                    } else {
                        nd = AddDependencyPanel.this.createFilterWithDefaultAction((Node)MavenNodeFactory.createArtifactNode(key, map.get(key)), false);
                    }
                    newNodes.add(nd);
                }
                this.resultsRootNode.setNewChildren(newNodes);
            } else if (null != this.queryRequest && !this.queryRequest.isFinished()) {
                this.resultsRootNode.setOneChild(AddDependencyPanel.getSearchingNode());
            } else {
                this.resultsRootNode.setOneChild(AddDependencyPanel.getNoResultsNode());
            }
        }

        @Override
        public int compare(String s1, String s2) {
            int index1 = s1.indexOf(this.inProgressText);
            int index2 = s2.indexOf(this.inProgressText);
            if (index1 >= 0 || index2 >= 0) {
                if (index1 < 0) {
                    return 1;
                }
                if (index2 < 0) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            return s1.compareTo(s2);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] selNodes = this.manager.getSelectedNodes();
                AddDependencyPanel.this.changeSelection(selNodes.length == 1 ? selNodes[0].getLookup() : Lookup.EMPTY);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            if (null == o || !(o instanceof QueryRequest)) {
                return;
            }
            ArrayList<NBVersionInfo> infos = ((QueryRequest)o).getResults();
            final HashMap<String, ArrayList<NBVersionInfo>> map = new HashMap<String, ArrayList<NBVersionInfo>>();
            if (infos != null) {
                if (AddDependencyPanel.this.chkNbOnly.isSelected()) {
                    ArrayList<NBVersionInfo> refined = new ArrayList<NBVersionInfo>();
                    HashSet<String> check = new HashSet<String>();
                    HashSet<String> found = new HashSet<String>();
                    for (NBVersionInfo nbvi : infos) {
                        String key = this.key(nbvi);
                        if ("nbm".equals(nbvi.getPackaging())) {
                            refined.add(nbvi);
                            found.add(key);
                            continue;
                        }
                        check.add(key);
                    }
                    QueryField qf = new QueryField();
                    qf.setField("packaging");
                    qf.setValue("nbm");
                    qf.setMatch(0);
                    qf.setOccur(0);
                    for (NBVersionInfo alt : RepositoryQueries.find(Collections.singletonList(qf), (RepositoryInfo[])new RepositoryInfo[0])) {
                        String key = this.key(alt);
                        if (!check.contains(key) || found.contains(key)) continue;
                        refined.add(alt);
                    }
                    Collections.sort(refined);
                    infos = refined;
                }
                for (NBVersionInfo nbvi : infos) {
                    String key = nbvi.getGroupId() + " : " + nbvi.getArtifactId();
                    ArrayList<NBVersionInfo> get = (ArrayList<NBVersionInfo>)map.get(key);
                    if (get == null) {
                        get = new ArrayList<NBVersionInfo>();
                        map.put(key, get);
                    }
                    get.add(nbvi);
                }
            }
            final ArrayList keyList = new ArrayList(map.keySet());
            Collections.sort(keyList, this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryPanel.this.updateResultNodes(keyList, map);
                }
            });
        }

        private String key(NBVersionInfo nbvi) {
            return nbvi.getGroupId() + ':' + nbvi.getArtifactId() + ':' + nbvi.getVersion();
        }
    }

    private class ResultsRootChildren
    extends Children.Keys<Node> {
        List<Node> myNodes = Collections.EMPTY_LIST;

        private void setNewChildren(List<Node> ch) {
            this.myNodes = ch;
            this.refreshList();
        }

        protected void addNotify() {
            this.refreshList();
        }

        private void refreshList() {
            ArrayList<Node> keys = new ArrayList<Node>();
            for (Node node : this.myNodes) {
                keys.add(node);
            }
            this.setKeys(keys);
        }

        protected Node[] createNodes(Node key) {
            return new Node[]{key};
        }
    }

    private class ResultsRootNode
    extends AbstractNode {
        private ResultsRootChildren resultsChildren;

        public ResultsRootNode() {
            this(new InstanceContent());
        }

        private ResultsRootNode(InstanceContent content) {
            super((Children)new ResultsRootChildren(), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
            content.add((Object)this);
            this.resultsChildren = (ResultsRootChildren)this.getChildren();
        }

        public void setOneChild(Node n) {
            ArrayList<Node> ch = new ArrayList<Node>(1);
            ch.add(n);
            this.setNewChildren(ch);
        }

        public void setNewChildren(List<Node> ch) {
            this.resultsChildren.setNewChildren(ch);
        }
    }
}

