/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.m2g.SVGImage;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorMessageAwareness;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGImageCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormSupport;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGFormImageParser;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGImageComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SVGFormEditorElement
extends PropertyEditorResourceElement
implements Runnable,
PropertyEditorResourceElementListener,
CleanUp {
    private static final String EXTENSION = "svg";
    private long componentID;
    private boolean doNotFireEvent;
    private Project project;
    private String lastDir;
    private SVGImageComponent imageView;
    private DefaultComboBoxModel comboBoxModel;
    private Map<String, FileObject> paths;
    private final AtomicBoolean requiresModelUpdate = new AtomicBoolean(false);
    private PropertyEditorResourceElement.DesignComponentWrapper wrapper;
    private PropertyEditorMessageAwareness messageAwareness;
    private WeakReference<DesignDocument> documentReferences;
    private Map<String, String> pathMap;
    private JPopupMenu menu;
    private WeakReference<DesignComponent> svgFormReferences;
    private boolean needUpdate;
    private boolean orderNeedsUpdate;
    private JButton chooserButton;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JButton jButton1;
    private JPanel jPanelImageFile;
    private JPanel jPanelSVGComponents;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JLabel pathLabel;
    private JComboBox pathTextComboBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JProgressBar progressBar;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public SVGFormEditorElement() {
        this.paths = new HashMap<String, FileObject>();
        this.comboBoxModel = new DefaultComboBoxModel();
        this.initComponents();
        this.progressBar.setVisible(false);
        this.imageView = new SVGImageComponent();
        this.previewPanel.add((Component)this.imageView, "Center");
        this.menu = new JPopupMenu();
        this.menu.add(new MoveAction(ResourceBundle.getBundle("org/netbeans/modules/vmd/midpnb/propertyeditors/Bundle").getString("Move_Up_Action"), 1));
        this.menu.add(new MoveAction(ResourceBundle.getBundle("org/netbeans/modules/vmd/midpnb/propertyeditors/Bundle").getString("Move_Down_Action"), -1));
        this.jTable1.addMouseListener(new PopupListener());
        this.pathMap = new HashMap<String, String>();
        this.jTable1.setSelectionMode(0);
    }

    public void clean(DesignComponent component) {
        this.project = null;
        this.imageView = null;
        this.comboBoxModel = null;
        if (this.paths != null) {
            this.paths.clear();
            this.paths = null;
        }
        this.wrapper = null;
        this.messageAwareness = null;
        this.documentReferences = null;
        if (this.pathMap != null) {
            this.pathMap.clear();
            this.pathMap = null;
        }
        this.menu = null;
        this.svgFormReferences = null;
        this.chooserButton = null;
        this.heightLabel = null;
        this.heightTextField = null;
        this.jButton1 = null;
        this.jPanelImageFile = null;
        this.jPanelSVGComponents = null;
        this.jScrollPane1 = null;
        this.jTabbedPane1 = null;
        this.jTable1 = null;
        this.pathLabel = null;
        this.pathTextComboBox = null;
        this.previewLabel = null;
        this.previewPanel = null;
        this.progressBar = null;
        this.widthLabel = null;
        this.widthTextField = null;
        this.removeAll();
    }

    public void setPropertyEditorMessageAwareness(PropertyEditorMessageAwareness messageAwareness) {
        this.messageAwareness = messageAwareness;
    }

    public JComponent getJComponent() {
        return this;
    }

    public TypeID getTypeID() {
        return SVGImageCD.TYPEID;
    }

    public List<String> getPropertyValueNames() {
        return Arrays.asList("resourcePath");
    }

    public boolean isResetToDefaultAutomatically(final DesignComponent component) {
        if (component == null) {
            return super.isResetToDefaultAutomatically(component);
        }
        final boolean[] isAutomatic = new boolean[]{true};
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DescriptorRegistry registry = component.getDocument().getDescriptorRegistry();
                if (registry.isInHierarchy(SVGFormCD.TYPEID, component.getType())) {
                    isAutomatic[0] = false;
                }
            }
        });
        return isAutomatic[0];
    }

    public void preResetToDefaultValue(DesignComponent component) {
        this.nullValueSet(component);
        super.preResetToDefaultValue(component);
    }

    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper wrapper) {
        this.wrapper = wrapper;
        if (this.documentReferences == null || this.documentReferences.get() == null) {
            return;
        }
        DesignDocument document = (DesignDocument)this.documentReferences.get();
        this.project = ProjectUtils.getProject((DesignDocument)document);
        if (wrapper == null) {
            this.setText(null);
            this.setAllEnabled(false);
            return;
        }
        this.componentID = wrapper.getComponentID();
        final String[] _pathText = new String[1];
        final DesignComponent component = wrapper.getComponent();
        if (component != null) {
            if (!component.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + component.getType());
            }
            this.componentID = component.getComponentID();
            component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue propertyValue = component.readProperty("resourcePath");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType((PropertyValue)propertyValue)) {
                        _pathText[0] = MidpTypes.getString((PropertyValue)propertyValue);
                    }
                }
            });
        }
        if (wrapper.hasChanges()) {
            Map changes = wrapper.getChanges();
            for (String propertyName : changes.keySet()) {
                PropertyValue propertyValue = (PropertyValue)changes.get(propertyName);
                if (!"resourcePath".equals(propertyName)) continue;
                _pathText[0] = MidpTypes.getString((PropertyValue)propertyValue);
            }
        }
        this.setAllEnabled(true);
        this.setText(_pathText[0]);
    }

    public boolean isPostSetValueSupported(final DesignComponent component) {
        final boolean[] retValue = new boolean[1];
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                retValue[0] = component.getDocument().getDescriptorRegistry().isInHierarchy(SVGFormCD.TYPEID, component.getType());
            }
        });
        return retValue[0];
    }

    public void postSetValue(final DesignComponent parentComponent, final DesignComponent childComponent) {
        final FileObject[] svgImageFileObject = new FileObject[1];
        final Boolean[] parseIt = new Boolean[]{Boolean.TRUE};
        parentComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                PropertyValue propertyValue = childComponent.readProperty("resourcePath");
                if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                    Map images = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)parentComponent.getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue));
                    Iterator iterator = images.keySet().iterator();
                    svgImageFileObject[0] = iterator.hasNext() ? (FileObject)iterator.next() : null;
                    parseIt[0] = Boolean.TRUE;
                }
                DesignComponent oldComponent = parentComponent.readProperty("svgImage").getComponent();
                if (!SVGFormEditorElement.this.needUpdate && oldComponent == childComponent && svgImageFileObject[0] != null) {
                    parseIt[0] = Boolean.FALSE;
                }
            }
        });
        if (parseIt[0] != null && parseIt[0].booleanValue()) {
            this.parseSVGImageItems(svgImageFileObject[0], parentComponent);
            this.orderSVGComponentsArray(parentComponent);
        }
        if (this.orderNeedsUpdate) {
            this.orderSVGComponentsArray(parentComponent);
        }
    }

    private void orderSVGComponentsArray(final DesignComponent svgForm) {
        final TableModel model = this.jTable1.getModel();
        final ArrayList orderdList = new ArrayList(model.getRowCount());
        svgForm.getDocument().getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                block0: for (int i = 0; i < model.getRowCount(); ++i) {
                    String id = (String)model.getValueAt(i, 1);
                    for (DesignComponent component : SVGFormSupport.getSVGFormComponents(svgForm)) {
                        if (!component.readProperty("id").getPrimitiveValue().equals(id)) continue;
                        orderdList.add(i, PropertyValue.createComponentReference((DesignComponent)component));
                        continue block0;
                    }
                }
                svgForm.writeProperty("components", PropertyValue.createArray((TypeID)SVGComponentCD.TYPEID, (List)orderdList));
            }
        });
    }

    public void nullValueSet(final DesignComponent svgForm) {
        svgForm.getDocument().getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                SVGFormSupport.removeAllSVGFormComponents(svgForm);
                svgForm.resetToDefault("svgImage");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSVGImageItems(FileObject imageFO, final DesignComponent parentComponent) {
        this.nullValueSet(parentComponent);
        if (imageFO == null) {
            return;
        }
        final SVGComponentImageParser[] svgComponentImageParser = new SVGComponentImageParser[1];
        parentComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                svgComponentImageParser[0] = SVGComponentImageParser.getParserByComponent(parentComponent);
            }
        });
        SVGComponentImageParser parser = svgComponentImageParser[0];
        if (parser == null) {
            return;
        }
        InputStream inputStream = null;
        inputStream = imageFO.getInputStream();
        if (inputStream != null) {
            parser.parse(inputStream, parentComponent);
        }
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException ioe) {
            Debug.warning((Object[])new Object[]{ioe});
        }
        return;
        catch (FileNotFoundException ex) {
            try {
                Debug.warning((Object[])new Object[]{ex});
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    Debug.warning((Object[])new Object[]{ioe});
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return;
            }
            catch (IOException ioe) {
                Debug.warning((Object[])new Object[]{ioe});
            }
            return;
        }
    }

    private void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.addImage(text, true);
    }

    private void addImage(String path, boolean selectImage) {
        this.doNotFireEvent = true;
        if (this.comboBoxModel.getIndexOf(path) == -1) {
            this.comboBoxModel.addElement(path);
            this.sortComboBoxContent();
        }
        if (selectImage) {
            this.pathTextComboBox.setSelectedItem(path);
            this.updatePreview();
        }
        this.doNotFireEvent = false;
    }

    private void sortComboBoxContent() {
        int size = this.pathTextComboBox.getItemCount();
        ArrayList list = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.pathTextComboBox.getItemAt(i));
        }
        Collections.sort(list, PropertyEditorResourceElement.StringComparator.instance);
        this.pathTextComboBox.removeAllItems();
        for (Object object : list) {
            this.pathTextComboBox.addItem(object);
        }
    }

    void setAllEnabled(boolean isEnabled) {
        this.pathLabel.setEnabled(isEnabled);
        this.pathTextComboBox.setEnabled(isEnabled);
        this.previewLabel.setEnabled(isEnabled);
        this.previewPanel.setEnabled(isEnabled);
        this.widthLabel.setEnabled(isEnabled);
        this.widthTextField.setEnabled(isEnabled);
        this.heightLabel.setEnabled(isEnabled);
        this.heightTextField.setEnabled(isEnabled);
        this.chooserButton.setEnabled(isEnabled);
    }

    private void updateModel(DesignDocument document) {
        boolean isEnabled = this.pathTextComboBox.isEnabled();
        this.pathTextComboBox.setEnabled(false);
        this.doNotFireEvent = true;
        this.comboBoxModel.removeAllElements();
        this.doNotFireEvent = false;
        this.paths.clear();
        Map fileMap = MidpProjectSupport.getAllFilesForProjectByExt((DesignDocument)document, Collections.singleton(EXTENSION));
        for (Map.Entry entry : fileMap.entrySet()) {
            this.checkFile((FileObject)entry.getKey(), (String)entry.getValue());
        }
        if (isEnabled) {
            this.pathTextComboBox.setEnabled(true);
        }
    }

    private void checkFile(FileObject fo, String relativePath) {
        String path;
        if (EXTENSION.equals(fo.getExt().toLowerCase()) && (path = this.convertFile(fo, relativePath, false)) != null) {
            this.addImage(path, false);
        }
    }

    private void updatePreview() {
        SVGImage svgImage;
        block6: {
            String relativePath = (String)this.pathTextComboBox.getSelectedItem();
            FileObject fo = this.paths.get(relativePath);
            svgImage = null;
            try {
                if (fo != null) {
                    svgImage = Util.createSVGImage((FileObject)fo, (boolean)true);
                }
                if (this.messageAwareness != null) {
                    this.messageAwareness.clearErrorStatus();
                }
            }
            catch (IOException e) {
                Debug.warning((Object[])new Object[]{e});
                if (this.messageAwareness == null) break block6;
                this.messageAwareness.displayWarning(NbBundle.getMessage(SVGFormEditorElement.class, (String)"MSG_SVG_Image_Not_SVG_Tiny"));
            }
        }
        if (svgImage != null) {
            int width = svgImage.getViewportWidth();
            int height = svgImage.getViewportHeight();
            this.widthTextField.setText(String.valueOf(width));
            this.heightTextField.setText(String.valueOf(height));
        } else {
            this.widthTextField.setText(null);
            this.heightTextField.setText(null);
        }
        this.imageView.setImage(svgImage);
        this.previewPanel.invalidate();
        this.previewPanel.validate();
        this.previewPanel.repaint();
    }

    private FileObject getSourceFolder() {
        if (this.project == null) {
            throw Debug.illegalState((Object[])new Object[]{"Current project is null"});
        }
        String projectID = ProjectUtils.getProjectID((Project)this.project);
        return ((SourceGroup)ProjectUtils.getSourceGroups((String)projectID).iterator().next()).getRootFolder();
    }

    private String convertFile(FileObject fo, String relPath, boolean needCopy) {
        String relativePath;
        FileObject sourceFolder = this.getSourceFolder();
        String sourcePath = FileUtil.toFile((FileObject)sourceFolder).getAbsolutePath();
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            relativePath = !fo.getPath().startsWith("/") ? "/" + fo.getPath() : fo.getPath();
        } else {
            String fullPath = file.getAbsolutePath();
            if (fullPath.contains(sourcePath)) {
                int i;
                fullPath = fo.getPath();
                relativePath = !fullPath.substring(i = fullPath.indexOf(sourcePath) + sourcePath.length() + 1).startsWith("/") ? "/" + fullPath.substring(i) : fullPath.substring(i);
            } else if (needCopy) {
                File possible = new File(sourcePath + File.separator + fo.getNameExt());
                if (possible.exists()) {
                    return null;
                }
                try {
                    fo = fo.copy(sourceFolder, fo.getName(), fo.getExt());
                }
                catch (IOException ex) {
                    Debug.warning((Object[])new Object[]{"SVGImageEditorElement.convertFile()", "can't copy file", fullPath, ex});
                }
                relativePath = "/" + fo.getNameExt();
            } else {
                relativePath = relPath;
            }
        }
        this.paths.put(relativePath, fo);
        return relativePath;
    }

    @Override
    public void run() {
        this.orderNeedsUpdate = false;
        this.needUpdate = false;
        if (this.documentReferences == null || this.documentReferences.get() == null) {
            return;
        }
        DesignDocument document = (DesignDocument)this.documentReferences.get();
        this.project = ProjectUtils.getProject((DesignDocument)document);
        this.updateModel(document);
        this.showProgressBar(false);
        this.setDesignComponentWrapper(this.wrapper);
        this.requiresModelUpdate.set(false);
    }

    public void addNotify() {
        super.addNotify();
        if (this.requiresModelUpdate.getAndSet(true)) {
            return;
        }
        this.showProgressBar(true);
        new Thread(this).start();
    }

    private void showProgressBar(final boolean isShowing) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGFormEditorElement.this.progressBar.setVisible(isShowing);
            }
        });
    }

    public void removeNotify() {
        this.paths.clear();
        this.project = null;
        this.wrapper = null;
        super.removeNotify();
    }

    public void setDesignComponent(DesignComponent component) {
        this.documentReferences = new WeakReference<DesignDocument>(component.getDocument());
        this.svgFormReferences = new WeakReference<DesignComponent>(component);
        super.setDesignComponent(component);
    }

    public void listSelectionHappened() {
        this.updateSVGComponentsList();
    }

    private void updateSVGComponentsList() {
        String relativePath = (String)this.pathTextComboBox.getSelectedItem();
        FileObject fo = this.paths.get(relativePath);
        this.updateSVGModelTable(null);
        try {
            InputStream is = null;
            if (fo != null) {
                is = fo.getInputStream();
                this.updateSVGModelTable(is);
            }
            this.jTable1.repaint();
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void getCustomEdiotrNotification() {
        this.jTable1.setModel(new Model());
        this.jTable1.repaint();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelImageFile = new JPanel();
        this.pathLabel = new JLabel();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.chooserButton = new JButton();
        this.pathTextComboBox = new JComboBox();
        this.progressBar = new JProgressBar();
        this.jPanelSVGComponents = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1.setText(NbBundle.getMessage(SVGFormEditorElement.class, (String)"SVGFormEditorElement.jButton1.text"));
        Mnemonics.setLocalizedText((JLabel)this.pathLabel, (String)NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.pathLabel.text"));
        this.pathLabel.setEnabled(false);
        this.previewLabel.setText(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.previewLabel.text"));
        this.previewLabel.setEnabled(false);
        this.previewPanel.setEnabled(false);
        this.previewPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.widthLabel, (String)NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.widthLabel.text"));
        this.widthLabel.setEnabled(false);
        this.widthTextField.setEditable(false);
        this.widthTextField.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.heightLabel, (String)NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.heightLabel.text"));
        this.heightLabel.setEnabled(false);
        this.heightTextField.setEditable(false);
        this.heightTextField.setEnabled(false);
        this.chooserButton.setText(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.chooserButton.text"));
        this.chooserButton.setEnabled(false);
        this.chooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGFormEditorElement.this.chooserButtonActionPerformed(evt);
            }
        });
        this.pathTextComboBox.setEditable(true);
        this.pathTextComboBox.setModel(this.comboBoxModel);
        this.pathTextComboBox.setEnabled(false);
        this.pathTextComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGFormEditorElement.this.pathTextComboBoxActionPerformed(evt);
            }
        });
        this.progressBar.setIndeterminate(true);
        GroupLayout jPanelImageFileLayout = new GroupLayout((Container)this.jPanelImageFile);
        this.jPanelImageFile.setLayout((LayoutManager)jPanelImageFileLayout);
        jPanelImageFileLayout.setHorizontalGroup((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1).add(0, 408, Short.MAX_VALUE).add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelImageFileLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelImageFileLayout.createSequentialGroup().add((Component)this.pathLabel).addPreferredGap(0, 339, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanelImageFileLayout.createSequentialGroup().add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelImageFileLayout.createSequentialGroup().add((Component)this.previewLabel).addPreferredGap(0).add((Component)this.previewPanel, -1, 164, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelImageFileLayout.createSequentialGroup().add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1).add((Component)this.heightLabel).add((Component)this.widthLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1, false).add((Component)this.widthTextField, -2, 92, -2).add((Component)this.heightTextField, -2, 92, -2))).add((Component)this.progressBar, -2, 146, -2))).add((Component)this.pathTextComboBox, 0, 362, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.chooserButton, -2, 30, -2))).addContainerGap())));
        jPanelImageFileLayout.setVerticalGroup((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1).add(0, 223, Short.MAX_VALUE).add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelImageFileLayout.createSequentialGroup().addContainerGap().add((Component)this.pathLabel).addPreferredGap(0).add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(3).add((Component)this.chooserButton).add((Component)this.pathTextComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelImageFileLayout.createSequentialGroup().add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(3).add((Component)this.widthLabel).add((Component)this.widthTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanelImageFileLayout.createParallelGroup(3).add((Component)this.heightLabel).add((Component)this.heightTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0)).add((Component)this.previewLabel).add((Component)this.previewPanel, -1, 163, Short.MAX_VALUE)).addContainerGap())));
        this.jTabbedPane1.addTab(NbBundle.getMessage(SVGFormEditorElement.class, (String)"SVGFormEditorElement.jPanelImageFile.TabConstraints.tabTitle"), this.jPanelImageFile);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ACSN_RecognizedComponents"));
        this.jTable1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ACSD_RecognizedComponents"));
        GroupLayout jPanelSVGComponentsLayout = new GroupLayout((Container)this.jPanelSVGComponents);
        this.jPanelSVGComponents.setLayout((LayoutManager)jPanelSVGComponentsLayout);
        jPanelSVGComponentsLayout.setHorizontalGroup((GroupLayout.Group)jPanelSVGComponentsLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 408, Short.MAX_VALUE));
        jPanelSVGComponentsLayout.setVerticalGroup((GroupLayout.Group)jPanelSVGComponentsLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 223, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(SVGFormEditorElement.class, (String)"SVGFormEditorElement.jPanelSVGComponents.TabConstraints.tabTitle"), this.jPanelSVGComponents);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 445, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 16, Short.MAX_VALUE).add((Component)this.jTabbedPane1, -2, -1, -2).add(0, 16, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 282, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 17, Short.MAX_VALUE).add((Component)this.jTabbedPane1, -2, -1, -2).add(0, 17, Short.MAX_VALUE))));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ACSN_TabbedPane"));
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ACSD_TabbedPane"));
    }

    private void chooserButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.lastDir != null ? this.lastDir : this.project.getProjectDirectory().getPath());
        chooser.setFileFilter(new ImageFilter());
        int returnVal = chooser.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)chooser.getSelectedFile()));
            this.lastDir = chooser.getSelectedFile().getParentFile().getPath();
            String relativePath = this.convertFile(fo, null, true);
            if (relativePath != null) {
                this.setText(relativePath);
                this.pathMap.put(relativePath, fo.getPath());
                this.pathTextComboBoxActionPerformed(null);
            } else {
                String message = NbBundle.getMessage(SVGFormEditorElement.class, (String)"MSG_FILE_EXIST");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            }
        }
        this.updateSVGComponentsList();
    }

    private void pathTextComboBoxActionPerformed(ActionEvent evt) {
        if (!this.doNotFireEvent) {
            String text = (String)this.pathTextComboBox.getSelectedItem();
            this.fireElementChanged(this.componentID, "resourcePath", MidpTypes.createStringValue((String)(text != null ? text : "")));
            this.updatePreview();
            this.updateSVGComponentsList();
            this.needUpdate = true;
        }
    }

    private void updateSVGModelTable(InputStream inputStrem) {
        this.jTable1.setModel(new Model(inputStrem));
    }

    public void elementChanged(PropertyEditorResourceElementEvent event) {
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int selectedRow = SVGFormEditorElement.this.jTable1.rowAtPoint(e.getPoint());
            SVGFormEditorElement.this.jTable1.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int selectedRow = SVGFormEditorElement.this.jTable1.rowAtPoint(e.getPoint());
            SVGFormEditorElement.this.jTable1.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SVGFormEditorElement.this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class MoveAction
    extends AbstractAction {
        private int step;

        public MoveAction(String name, int step) {
            super(name);
            this.step = step;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.step < 0) {
                if (SVGFormEditorElement.this.jTable1.getSelectedRow() < SVGFormEditorElement.this.jTable1.getRowCount() - 1) {
                    this.moveValue(this.step);
                }
            } else if (SVGFormEditorElement.this.jTable1.getSelectedRow() > 0) {
                this.moveValue(this.step);
            }
        }

        private void moveValue(int step) {
            SVGFormEditorElement.this.orderNeedsUpdate = true;
            TableModel model = SVGFormEditorElement.this.jTable1.getModel();
            int selectedRow = SVGFormEditorElement.this.jTable1.getSelectedRow();
            String typeToMoveUp = (String)model.getValueAt(selectedRow, 0);
            String idToMoveUp = (String)model.getValueAt(selectedRow, 1);
            String typeToMoveDown = (String)model.getValueAt(selectedRow - step, 0);
            String idToMoveDown = (String)model.getValueAt(selectedRow - step, 1);
            model.setValueAt(typeToMoveUp, selectedRow - step, 0);
            model.setValueAt(idToMoveUp, selectedRow - step, 1);
            model.setValueAt(typeToMoveDown, selectedRow, 0);
            model.setValueAt(idToMoveDown, selectedRow, 1);
            SVGFormEditorElement.this.jTable1.getSelectionModel().setSelectionInterval(selectedRow - step, selectedRow - step);
            SVGFormEditorElement.this.jTabbedPane1.repaint();
        }
    }

    private class Model
    implements TableModel {
        private String COLUMN_NAME_I = ResourceBundle.getBundle("org/netbeans/modules/vmd/midpnb/propertyeditors/Bundle").getString("SVG_Component_Type_Column");
        private String COLUMN_NAME_II = ResourceBundle.getBundle("org/netbeans/modules/vmd/midpnb/propertyeditors/Bundle").getString("SVG_Component_ID_Column");
        private Object[][] values;

        public Model() {
            if (SVGFormEditorElement.this.svgFormReferences == null || SVGFormEditorElement.this.svgFormReferences.get() == null) {
                return;
            }
            final DesignComponent svgForm = (DesignComponent)SVGFormEditorElement.this.svgFormReferences.get();
            svgForm.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    List svgComponents = svgForm.readProperty("components").getArray();
                    Model.access$602(Model.this, new Object[svgComponents.size()][2]);
                    int i = 0;
                    for (PropertyValue value : svgComponents) {
                        String id = (String)value.getComponent().readProperty("id").getPrimitiveValue();
                        String type = MidpTypes.getSimpleClassName((TypeID)value.getComponent().getType());
                        ((Model)Model.this).values[i][1] = id;
                        ((Model)Model.this).values[i++][0] = type;
                    }
                }
            });
        }

        public Model(InputStream inputStream) {
            if (inputStream == null) {
                this.values = new Object[0][0];
                return;
            }
            this.values = SVGFormImageParser.getComponentsInformation(inputStream);
        }

        @Override
        public int getRowCount() {
            if (this.values == null) {
                return 0;
            }
            return this.values.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return this.COLUMN_NAME_I;
            }
            return this.COLUMN_NAME_II;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.values != null) {
                return this.values[rowIndex][columnIndex];
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.values[rowIndex][columnIndex] = (String)aValue;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        static /* synthetic */ Object[][] access$602(Model x0, Object[][] x1) {
            x0.values = x1;
            return x1;
        }
    }

    private static class ImageFilter
    extends FileFilter {
        private String description = NbBundle.getMessage(SVGFormEditorElement.class, (String)"DISP_SVG_Image_Files");

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String extension = ImageFilter.getExtension(file);
            return SVGFormEditorElement.EXTENSION.equals(extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        private static String getExtension(File file) {
            String ext = null;
            String s = file.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

