/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.gsf.testrunner.api.OutputLine;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.openide.util.Parameters;

public class Testcase {
    private final String type;
    private String className;
    private final String name;
    private long timeMillis;
    private Trouble trouble;
    private Status status;
    private final List<OutputLine> output = new ArrayList<OutputLine>();
    private String location;
    private TestSession session;

    public Testcase(String name, String type, TestSession session) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"session", (Object)session);
        this.name = name;
        this.session = session;
        this.type = type;
    }

    public TestSession getSession() {
        return this.session;
    }

    public String getType() {
        return this.type;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void addOutputLines(List<String> lines) {
        for (String line : lines) {
            this.output.add(new OutputLine(line, false));
        }
    }

    public List<OutputLine> getOutput() {
        return this.output;
    }

    public String getLocation() {
        return this.location;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        if (this.status != null) {
            return this.status;
        }
        if (this.trouble == null) {
            return Status.PASSED;
        }
        return this.trouble.isError() ? Status.ERROR : Status.FAILED;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public void setTimeMillis(long timeMillis) {
        this.timeMillis = timeMillis;
    }

    public Trouble getTrouble() {
        return this.trouble;
    }

    public void setTrouble(Trouble trouble) {
        this.trouble = trouble;
    }

    public String toString() {
        return Testcase.class.getSimpleName() + "[class: " + this.className + ", name: " + this.name + "]";
    }
}

