/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.actions;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.vmd.api.flow.FlowSupport;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ExportFlowAsImageAction
extends SystemAction
implements DesignDocumentAwareness {
    private DesignDocument document;

    public String getName() {
        return NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"NAME_ExportFlowAsImage");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ExportFlowAsImageAction.class);
    }

    public boolean isEnabled() {
        this.updateDesignDocumentReference();
        FlowScene scene = FlowSupport.getFlowSceneForDocument((DesignDocument)this.document);
        if (scene == null) {
            return false;
        }
        JComponent view = scene.getView();
        if (view == null || !view.isShowing()) {
            return false;
        }
        Rectangle rectangle = scene.getBounds();
        return rectangle.width > 0 && rectangle.height > 0;
    }

    private void updateDesignDocumentReference() {
        DataObjectContext context = ActiveViewSupport.getDefault().getActiveView().getContext();
        context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
        context.removeDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public void actionPerformed(ActionEvent e) {
        this.updateDesignDocumentReference();
        FlowScene scene = FlowSupport.getFlowSceneForDocument((DesignDocument)this.document);
        if (scene == null) {
            return;
        }
        this.saveAsImage((Scene)scene);
    }

    /*
     * Loose catch block
     */
    private void saveAsImage(Scene scene) {
        block19: {
            Rectangle rectangle = scene.getBounds();
            BufferedImage bi = new BufferedImage(rectangle.width, rectangle.height, 6);
            Graphics2D graphics = bi.createGraphics();
            scene.paint(graphics);
            graphics.dispose();
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"TITLE_ExportFlowAsImage"));
            chooser.setDialogType(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"LBL_FileFilterPNG");
                }
            });
            if (chooser.showSaveDialog(scene.getView()) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".png")) {
                file = new File(file.getParentFile(), file.getName() + ".png");
            }
            if (file.exists()) {
                DialogDescriptor descriptor = new DialogDescriptor((Object)NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"LBL_AlreadyExists", (Object)file.getAbsolutePath()), NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"TITLE_AlreadyExists"), true, 0, DialogDescriptor.NO_OPTION, null);
                DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
                if (descriptor.getValue() != DialogDescriptor.YES_OPTION) {
                    return;
                }
            }
            FileImageOutputStream stream = null;
            stream = new FileImageOutputStream(file);
            ImageIO.write((RenderedImage)bi, "png", stream);
            try {
                if (stream != null) {
                    stream.close();
                }
                break block19;
            }
            catch (IOException e) {
                Debug.error((Object[])new Object[]{e});
            }
            break block19;
            catch (FileNotFoundException e) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportFlowAsImageAction.class, (String)"LBL_NoWrite", (Object)file.getAbsolutePath()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    Debug.error((Object[])new Object[]{e2});
                }
                return;
            }
            catch (IOException e2) {
                throw Debug.error((Object[])new Object[]{e2});
                {
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException e3) {
                            Debug.error((Object[])new Object[]{e3});
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public void setDesignDocument(DesignDocument designDocument) {
        this.document = designDocument;
    }
}

