/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeNamePresenter;
import org.netbeans.modules.vmd.api.codegen.CodeReferencePresenter;
import org.netbeans.modules.vmd.api.codegen.InitCodeGenerator;
import org.netbeans.modules.vmd.api.codegen.ModelUpdatePresenter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.codegen.CodeClassInitHeaderFooterPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.ClassSupport;
import org.netbeans.modules.vmd.midp.components.general.RootCode;

public class ClassCode {
    private static final String ARRAY_SUFFIX = "Array";
    private static final String GETTER_PREFIX = "get";

    private static String createGetterNameFromInstanceName(String instanceName) {
        if (instanceName == null || instanceName.length() < 0) {
            return null;
        }
        return GETTER_PREFIX + Character.toUpperCase(instanceName.charAt(0)) + instanceName.substring(1);
    }

    public static String getSuggestedMainName(TypeID type) {
        String instanceName = type.getString();
        int index = instanceName.lastIndexOf(46);
        if (index >= 0) {
            instanceName = instanceName.substring(index + 1);
        }
        if (type.getDimension() > 0) {
            instanceName = instanceName + ARRAY_SUFFIX;
        }
        if (instanceName.length() <= 0) {
            instanceName = "object";
        }
        char[] chars = instanceName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isLetter(chars[i])) continue;
            if (!Character.isUpperCase(chars[i])) break;
            if (i == 0) {
                chars[i] = Character.toLowerCase(chars[i]);
                continue;
            }
            if (i + 1 < chars.length) {
                if (!Character.isUpperCase(chars[i + 1])) break;
                chars[i] = Character.toLowerCase(chars[i]);
                continue;
            }
            chars[i] = Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }

    static class CodeClassNamePresenter
    extends CodeNamePresenter {
        CodeClassNamePresenter() {
        }

        public List<String> getReservedNames() {
            return this.getReservedNamesFor(MidpTypes.getString(this.getComponent().readProperty("instanceName")));
        }

        public List<String> getReservedNamesFor(String suggestedMainName) {
            return Arrays.asList(suggestedMainName, ClassCode.createGetterNameFromInstanceName(suggestedMainName));
        }
    }

    static class CodeClassComponentDependencyPresenter
    extends RootCode.CodeComponentDependencyPresenter {
        CodeClassComponentDependencyPresenter() {
        }

        @Override
        protected void collectRequiredComponents(Collection<DesignComponent> requiredComponents) {
            DesignComponent component = this.getComponent();
            ComponentDescriptor descriptor = component.getComponentDescriptor();
            if (descriptor != null) {
                for (PropertyDescriptor property : descriptor.getPropertyDescriptors()) {
                    Debug.collectAllComponentReferences((PropertyValue)component.readProperty(property.getName()), requiredComponents);
                }
            }
        }
    }

    static final class CodeLazyInitPresenter
    extends CodeClassLevelPresenter {
        CodeLazyInitPresenter() {
        }

        protected void generateFieldSectionCode(MultiGuardedSection section) {
            section.getWriter().write("private " + CodeReferencePresenter.generateTypeCode((DesignComponent)this.getComponent()) + " " + CodeReferencePresenter.generateDirectAccessCode((DesignComponent)this.getComponent()) + ";\n");
        }

        protected void generateMethodSectionCode(MultiGuardedSection section) {
        }

        public void generateInitializeSectionCode(MultiGuardedSection section) {
            if (ClassSupport.isLazyInitialized(this.getComponent())) {
                return;
            }
            InitCodeGenerator.generateInitializationCode((MultiGuardedSection)section, (DesignComponent)this.getComponent());
        }

        protected void generateClassBodyCode(StyledDocument document) {
            if (!ClassSupport.isLazyInitialized(this.getComponent())) {
                return;
            }
            MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(this.getComponent().getComponentID() + "-getter"));
            String directAccess = CodeReferencePresenter.generateDirectAccessCode((DesignComponent)this.getComponent());
            section.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Getter: " + directAccess + " \">\n");
            section.getWriter().write("/**\n * Returns an initiliazed instance of " + directAccess + " component.\n * @return the initialized component instance\n */\n");
            section.getWriter().write("public " + CodeReferencePresenter.generateTypeCode((DesignComponent)this.getComponent()) + " " + CodeReferencePresenter.generateAccessCode((DesignComponent)this.getComponent()) + " {\n");
            section.getWriter().write("if (" + directAccess + " == null) {\n").commit();
            section.switchToEditable(this.getComponent().getComponentID() + "-preInit");
            section.getWriter().write(" // write pre-init user code here\n").commit();
            section.switchToGuarded();
            Collection headersFooters = this.getComponent().getPresenters(CodeClassInitHeaderFooterPresenter.class);
            for (CodeClassInitHeaderFooterPresenter header : headersFooters) {
                header.generateClassInitializationHeader(section);
            }
            InitCodeGenerator.generateInitializationCode((MultiGuardedSection)section, (DesignComponent)this.getComponent());
            for (CodeClassInitHeaderFooterPresenter footer : headersFooters) {
                footer.generateClassInitializationFooter(section);
            }
            section.getWriter().commit();
            section.switchToEditable(this.getComponent().getComponentID() + "-postInit");
            section.getWriter().write(" // write post-init user code here\n").commit();
            section.switchToGuarded();
            section.getWriter().write("}\n");
            section.getWriter().write("return " + directAccess + ";\n");
            section.getWriter().write("}\n");
            section.getWriter().write("//</editor-fold>\n").commit();
            section.close();
        }
    }

    static final class ClassCodeReferencePresenter
    extends CodeReferencePresenter {
        ClassCodeReferencePresenter() {
        }

        protected String generateAccessCode() {
            DesignComponent component = this.getComponent();
            String instanceName = MidpTypes.getString(component.readProperty("instanceName"));
            return this.generateAccessCode(instanceName);
        }

        protected String generateDirectAccessCode() {
            return MidpTypes.getString(this.getComponent().readProperty("instanceName"));
        }

        protected String generateAccessCode(String newName) {
            DesignComponent component = this.getComponent();
            boolean lazyInit = MidpTypes.getBoolean(component.readProperty("lazyInit"));
            return lazyInit ? ClassCode.createGetterNameFromInstanceName(newName) + " ()" : newName;
        }

        protected String generateTypeCode() {
            return MidpTypes.getSimpleClassName(this.getComponent().getType());
        }
    }

    public static class GeneratedCodePresenter
    extends ModelUpdatePresenter {
        public void modelUpdated() {
            this.getComponent().writeProperty("codeGenerated", MidpTypes.createBooleanValue(Boolean.TRUE));
        }

        public boolean isCodeGenerated() {
            return Boolean.TRUE.equals(this.getComponent().readProperty("codeGenerated").getPrimitiveValue());
        }
    }
}

