/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.screen.display.ItemDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.openide.util.NbBundle;

public class DateFieldDisplayPresenter
extends ItemDisplayPresenter {
    private JLabel label = new JLabel();

    public DateFieldDisplayPresenter() {
        this.setContentComponent(this.label);
    }

    @Override
    public void reload(ScreenDeviceInfo deviceInfo) {
        super.reload(deviceInfo);
        PropertyValue inputModeValue = this.getComponent().readProperty("inputMode");
        PropertyValue dateValue = this.getComponent().readProperty("date");
        String text = NbBundle.getMessage(DateFieldDisplayPresenter.class, (String)"DISP_user_input_mode");
        DateFormat format = DateFormat.getDateTimeInstance(2, 2);
        if (inputModeValue.getKind() == PropertyValue.Kind.VALUE) {
            int inputMode = MidpTypes.getInteger(inputModeValue);
            switch (inputMode) {
                case 1: {
                    text = NbBundle.getMessage(DateFieldDisplayPresenter.class, (String)"DISP_user_date");
                    format = DateFormat.getDateInstance(2);
                    break;
                }
                case 3: {
                    text = NbBundle.getMessage(DateFieldDisplayPresenter.class, (String)"DISP_user_date_time");
                    break;
                }
                case 2: {
                    text = NbBundle.getMessage(DateFieldDisplayPresenter.class, (String)"DISP_user_time");
                    format = DateFormat.getTimeInstance(2);
                }
            }
        }
        if (MidpDatabindingSupport.getConnector(this.getComponent(), "date") != null) {
            text = ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/screen/display/Bundle").getString("LBL_Databinding");
        } else if (dateValue.getKind() == PropertyValue.Kind.VALUE) {
            text = format.format(new Date(MidpTypes.getLong(dateValue)));
        }
        if (text == null || text.length() == 0) {
            this.label.setText(" ");
        } else {
            this.label.setText(text);
        }
    }

    @Override
    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ResourcePropertyEditor dateFieldPropertyEditor = new ResourcePropertyEditor("date", this.getComponent());
        ArrayList<ScreenPropertyDescriptor> descriptors = new ArrayList<ScreenPropertyDescriptor>();
        descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.label, (ScreenPropertyEditor)dateFieldPropertyEditor));
        descriptors.addAll(super.getPropertyDescriptors());
        return descriptors;
    }
}

