/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.CharBuffer;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.debugger.ui.models.WatchesTreeModel;
import org.netbeans.spi.viewmodel.DnDNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class WatchesNodeModel
implements ExtendedNodeModel,
DnDNodeModel {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
    private Vector listeners = new Vector();

    private static Watch getWatch(Object o) {
        if (o instanceof Watch) {
            return (Watch)o;
        }
        try {
            if (o.getClass().getMethod("getWatch", new Class[0]) != null) {
                return (Watch)o.getClass().getMethod("getWatch", new Class[0]).invoke(o, new Object[0]);
            }
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(WatchesNodeModel.class).getString("CTL_WatchesModel_Column_Name_Name");
        }
        if (o instanceof WatchesTreeModel.EmptyWatch) {
            return "<_html><font color=\"#808080\">&lt;" + NbBundle.getBundle(WatchesNodeModel.class).getString("CTL_WatchesModel_Empty_Watch_Hint") + "&gt;</font></html>";
        }
        Watch w = WatchesNodeModel.getWatch(o);
        if (w != null) {
            return w.getExpression();
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return "Root";
        }
        if (o instanceof WatchesTreeModel.EmptyWatch) {
            return NbBundle.getMessage(WatchesNodeModel.class, (String)"TTP_NewWatch");
        }
        Watch w = WatchesNodeModel.getWatch(o);
        if (w != null) {
            return w.getExpression() + NbBundle.getBundle(WatchesNodeModel.class).getString("CTL_WatchesModel_Column_NameNoContext_Desc");
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return WATCH;
        }
        if (node instanceof WatchesTreeModel.EmptyWatch) {
            return null;
        }
        if (WatchesNodeModel.getWatch(node) != null) {
            return WATCH;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return node instanceof WatchesTreeModel.EmptyWatch || WatchesNodeModel.getWatch(node) != null;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return WatchesNodeModel.getWatch(node) != null;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return WatchesNodeModel.getWatch(node) != null;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        return new StringSelection(WatchesNodeModel.getWatch(node).getExpression());
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        return new StringSelection(WatchesNodeModel.getWatch(node).getExpression());
    }

    public PasteType[] getPasteTypes(final Object node, final Transferable t) throws UnknownTypeException {
        if (node != "Root" && WatchesNodeModel.getWatch(node) == null) {
            return null;
        }
        DataFlavor[] flavors = t.getTransferDataFlavors();
        final DataFlavor textFlavor = DataFlavor.selectBestTextFlavor(flavors);
        if (textFlavor != null) {
            return new PasteType[]{new PasteType(){

                public Transferable paste() {
                    try {
                        Reader r = textFlavor.getReaderForText(t);
                        CharBuffer cb = CharBuffer.allocate(1000);
                        r.read(cb);
                        cb.flip();
                        Watch w = WatchesNodeModel.getWatch(node);
                        if (w != null) {
                            w.setExpression(cb.toString());
                        } else {
                            DebuggerManager.getDebuggerManager().createWatch(cb.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            }};
        }
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        if (node instanceof Watch) {
            ((Watch)node).setExpression(name);
            return;
        }
        if (node instanceof WatchesTreeModel.EmptyWatch) {
            ((WatchesTreeModel.EmptyWatch)node).setExpression(name);
            return;
        }
        throw new UnknownTypeException(node);
    }

    public int getAllowedDragActions() {
        return 3;
    }

    public int getAllowedDropActions() {
        return 1;
    }

    public int getAllowedDropActions(Transferable t) {
        if (t != null && t.isDataFlavorSupported(new DataFlavor(Watch.class, null))) {
            return 3;
        }
        return 1;
    }

    public Transferable drag(Object node) throws IOException, UnknownTypeException {
        Watch w = WatchesNodeModel.getWatch(node);
        if (w != null) {
            return new WatchSelection(w);
        }
        throw new UnknownTypeException(node);
    }

    public PasteType getDropType(final Object node, final Transferable t, int action, final int index) throws UnknownTypeException {
        DataFlavor[] flavors = t.getTransferDataFlavors();
        final DataFlavor textFlavor = DataFlavor.selectBestTextFlavor(flavors);
        if (textFlavor != null) {
            return new PasteType(){

                public Transferable paste() {
                    String watchExpression;
                    try {
                        Reader r = textFlavor.getReaderForText(t);
                        CharBuffer cb = CharBuffer.allocate(1000);
                        r.read(cb);
                        cb.flip();
                        watchExpression = cb.toString();
                    }
                    catch (Exception ex) {
                        return t;
                    }
                    Watch w = WatchesNodeModel.getWatch(node);
                    if (w != null) {
                        w.setExpression(watchExpression);
                    } else if (index < 0) {
                        DebuggerManager.getDebuggerManager().createWatch(watchExpression);
                    } else {
                        DebuggerManager.getDebuggerManager().createWatch(Math.min(index, DebuggerManager.getDebuggerManager().getWatches().length), watchExpression);
                    }
                    return t;
                }
            };
        }
        return null;
    }

    private static class WatchSelection
    implements Transferable,
    ClipboardOwner {
        private static final int STRING = 0;
        private static final int PLAIN_TEXT = 1;
        private static final int WATCH = 2;
        private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor, new DataFlavor(Watch.class, "Watch")};
        private Watch watch;
        private String str;

        public WatchSelection(Watch watch) {
            this.watch = watch;
            this.str = watch.getExpression();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])flavors.clone();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(flavors[0])) {
                return this.str;
            }
            if (flavor.equals(flavors[1])) {
                return new StringReader(this.str == null ? "" : this.str);
            }
            if (flavor.equals(flavors[2])) {
                return this.watch;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

