/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error.includes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.highlight.error.BadgeProvider;
import org.netbeans.modules.cnd.highlight.error.includes.ErrorIncludeDialog;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class FailedIncludesAction
extends NodeAction {
    public FailedIncludesAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    private String i18n(String id) {
        return NbBundle.getMessage(FailedIncludesAction.class, (String)id);
    }

    protected void performAction(Node[] activatedNodes) {
        Set<CsmUID<CsmFile>> set;
        List<NativeProject> projects = this.getNativeProjects(activatedNodes);
        if (projects == null || projects.size() != 1) {
            List<CsmProject> csmProjects = this.getCsmProjects(activatedNodes);
            if (csmProjects == null || csmProjects.size() != 1) {
                return;
            }
            CsmProject csmProject = csmProjects.get(0);
            set = BadgeProvider.getInstance().getFailedFiles(csmProject);
        } else {
            NativeProject nativeProject = projects.get(0);
            set = BadgeProvider.getInstance().getFailedFiles(nativeProject);
        }
        HashSet<CsmFile> list = new HashSet<CsmFile>();
        if (set != null) {
            for (CsmUID<CsmFile> fileUID : set) {
                CsmFile csmFile = (CsmFile)fileUID.getObject();
                assert (csmFile != null);
                if (csmFile == null) continue;
                list.add(csmFile);
            }
        }
        ErrorIncludeDialog.showErrorIncludeDialog(list);
    }

    protected boolean enable(Node[] activatedNodes) {
        List<NativeProject> projects = this.getNativeProjects(activatedNodes);
        if (projects == null || projects.size() != 1) {
            List<CsmProject> csmProjects = this.getCsmProjects(activatedNodes);
            if (csmProjects == null || csmProjects.size() != 1) {
                return false;
            }
            return BadgeProvider.getInstance().hasFailedFiles(csmProjects.get(0));
        }
        return BadgeProvider.getInstance().hasFailedFiles(projects.get(0));
    }

    private List<NativeProject> getNativeProjects(Node[] nodes) {
        ArrayList<NativeProject> projects = new ArrayList<NativeProject>();
        for (int i = 0; i < nodes.length; ++i) {
            Project project = (Project)nodes[i].getLookup().lookup(Project.class);
            if (project == null) {
                return null;
            }
            NativeProject nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
            if (nativeProject == null) {
                return null;
            }
            projects.add(nativeProject);
        }
        return projects;
    }

    private List<CsmProject> getCsmProjects(Node[] nodes) {
        ArrayList<CsmProject> projects = new ArrayList<CsmProject>();
        for (int i = 0; i < nodes.length; ++i) {
            CsmProject project = (CsmProject)nodes[i].getLookup().lookup(CsmProject.class);
            if (project == null) {
                return null;
            }
            projects.add(project);
        }
        return projects;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return this.i18n("ErrorIncludeMenu_Title");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

