/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class Mimetypes {
    private static Map mimetypes = new HashMap();

    public static String getMimeTypeForExtension(String extension, String defaultType) {
        String mime = (String)mimetypes.get(extension);
        if (mime == null) {
            mime = defaultType;
        }
        return mime;
    }

    public static String getMimeType(File file, String defaultType) {
        String ext = file.getName();
        int dotPos = ext.lastIndexOf(46);
        if (dotPos != -1) {
            return Mimetypes.getMimeTypeForExtension(ext.substring(dotPos + 1), defaultType);
        }
        return defaultType;
    }

    public static String getMimeType(String file, String defaultType) {
        int dotPos = file.lastIndexOf(46);
        if (dotPos != -1) {
            return Mimetypes.getMimeTypeForExtension(file.substring(dotPos + 1), defaultType);
        }
        return defaultType;
    }

    public static String getExtension(String fileName) {
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos != -1) {
            return fileName.substring(dotPos + 1);
        }
        return null;
    }

    static {
        ResourceBundle rb = ResourceBundle.getBundle("org.apache.webdav.ant.mimetypes");
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String ext = e.nextElement();
            mimetypes.put(ext, rb.getString(ext));
        }
    }
}

