/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant.taskdefs;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.webdav.ant.Utils;

public abstract class WebdavTask
extends Task {
    private HttpURL url = null;
    private String userid = "";
    private String password = "";
    private HttpClient httpClient = null;
    private boolean verbose = false;

    protected HttpClient getHttpClient() {
        try {
            if (this.httpClient == null) {
                this.httpClient = new HttpClient();
                if (this.userid.length() > 0) {
                    this.httpClient.getState().setCredentials(null, this.url.getHost(), (Credentials)new UsernamePasswordCredentials(this.userid, this.password));
                }
            }
            return this.httpClient;
        }
        catch (URIException e) {
            throw new BuildException("Can't create HttpClient.", (Throwable)e);
        }
    }

    protected void validate() {
        if (this.url == null) {
            throw new BuildException("Required attribute url missing!");
        }
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    protected String getUserid() {
        return this.userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected String getPassword() {
        return this.password;
    }

    public void setUrl(String url) {
        try {
            this.url = Utils.createHttpURL(url);
            this.url.setPath(WebdavTask.removeDoubleSlashes(this.url.getPath()));
        }
        catch (URIException e) {
            throw new BuildException("Invalid uri!", (Throwable)e);
        }
    }

    protected void setUrl(HttpURL url) {
        this.url = url;
    }

    protected HttpURL getUrl() {
        return this.url;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    protected int ifVerbose() {
        return this.verbose ? 2 : 3;
    }

    public static HttpURL assureCollectionUrl(HttpURL url) throws URIException {
        if (url.getPath().endsWith("/")) {
            return url;
        }
        HttpURL coll = Utils.createHttpURL(url, "");
        coll.setPath(url.getPath() + "/");
        return coll;
    }

    static String removeDoubleSlashes(String path) {
        if (path.indexOf("//") == -1) {
            return path;
        }
        StringBuffer r = new StringBuffer(path.length());
        int l = path.length();
        for (int i = 0; i < l; ++i) {
            if (path.charAt(i) == '/') {
                if (i > 0 && path.charAt(i - 1) == '/') continue;
                r.append('/');
                continue;
            }
            r.append(path.charAt(i));
        }
        return r.toString();
    }
}

