/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.storage.StandardColumns;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.DTraceEventData;
import org.netbeans.modules.dlight.dtrace.collector.DTraceOutputParser;
import org.netbeans.modules.dlight.dtrace.collector.support.DtraceDataCollector;
import org.netbeans.modules.dlight.dtrace.collector.support.OutputProcessor;
import org.netbeans.modules.dlight.dtrace.collector.support.Tracer;
import org.openide.util.Exceptions;

final class DefaultOutputProcessor
implements OutputProcessor {
    private static final Tracer tracer = Boolean.getBoolean("dlight.dns.parser.trace") ? new Tracer() : null;
    private final DataTableMetadata tableMetaData;
    private final int durationColumnIdx;
    private final int timestampColumnIdx;
    private final int stackRefColumnIdx;
    private DtraceDataCollector collector;
    private DTraceOutputParser parser;
    private StackDataStorage stackStorage;

    DefaultOutputProcessor(DataTableMetadata tableMetaData) {
        this.tableMetaData = tableMetaData;
        List columnNames = tableMetaData.getColumnNames();
        this.durationColumnIdx = columnNames.indexOf(StandardColumns.DURATION_COLUMN.getColumnName());
        this.timestampColumnIdx = columnNames.indexOf(StandardColumns.TIMESTAMP_COLUMN.getColumnName());
        this.stackRefColumnIdx = columnNames.indexOf(StandardColumns.STACK_COLUMN.getColumnName());
    }

    @Override
    public void init(DtraceDataCollector collector, StackDataStorage stackStorage) {
        this.collector = collector;
        this.parser = collector.getParser();
        this.stackStorage = stackStorage;
    }

    public void processLine(String line) {
        if (tracer != null) {
            tracer.trace(line);
        }
        try {
            DTraceEventData data = this.parser.parse(line);
            if (data == null) {
                return;
            }
            DataRow dataRow = data.getDataRow();
            List<CharSequence> callStack = data.getEventCallStack();
            if (this.stackStorage != null && callStack != null) {
                Long stackID;
                if (this.timestampColumnIdx == -1 || this.durationColumnIdx == -1) {
                    stackID = this.stackStorage.putStack(data.getContextID(), callStack);
                } else {
                    long time = DataUtil.toLong(dataRow.getData().get(this.timestampColumnIdx));
                    long duration = DataUtil.toLong(dataRow.getData().get(this.durationColumnIdx));
                    stackID = this.stackStorage.putSample(data.getContextID(), callStack, time, duration);
                }
                if (this.stackRefColumnIdx >= 0) {
                    List originalData = dataRow.getData();
                    ArrayList<Long> dataWithStackID = new ArrayList<Long>(originalData.size() + 1);
                    dataWithStackID.addAll(originalData);
                    dataWithStackID.add(this.stackRefColumnIdx, stackID);
                    dataRow = new DataRow(this.tableMetaData.getColumnNames(), dataWithStackID);
                }
            }
            this.collector.addDataRow(dataRow);
        }
        catch (Throwable th) {
            Exceptions.printStackTrace((Throwable)th);
        }
    }

    public void reset() {
    }

    public void close() {
        this.processLine("");
        this.collector.packageVisibleSuggestIndicatorsRepaint();
    }
}

