/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.util.Map;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.support.DtraceDataCollector;
import org.netbeans.modules.dlight.dtrace.collector.support.OutputProcessor;

final class DemultiplexingOutputProcessor
implements OutputProcessor {
    private DtraceDataCollector lastSlaveCollector;
    private final Map<String, DtraceDataCollector> slaveCollectors;
    private DtraceDataCollector collector;

    DemultiplexingOutputProcessor(Map<String, DtraceDataCollector> slaveCollectors) {
        this.slaveCollectors = slaveCollectors;
    }

    @Override
    public void init(DtraceDataCollector collector, StackDataStorage stackStorage) {
        this.collector = collector;
    }

    public void processLine(String line) {
        DtraceDataCollector target = this.lastSlaveCollector;
        String l = line;
        for (Map.Entry<String, DtraceDataCollector> entry : this.slaveCollectors.entrySet()) {
            String prefix = entry.getKey();
            if (!l.startsWith(prefix)) continue;
            l = l.substring(prefix.length());
            target = entry.getValue();
            break;
        }
        if (target != null) {
            target.getOutputProcessor().processLine(l);
        }
        this.lastSlaveCollector = target;
    }

    public void reset() {
        for (Map.Entry<String, DtraceDataCollector> entry : this.slaveCollectors.entrySet()) {
            entry.getValue().getOutputProcessor().reset();
        }
    }

    public void close() {
        for (Map.Entry<String, DtraceDataCollector> entry : this.slaveCollectors.entrySet()) {
            entry.getValue().getOutputProcessor().close();
        }
        this.collector.packageVisibleSuggestIndicatorsRepaint();
    }
}

