/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.api.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.e2e.api.schema.RepeatableSchemaConstruct;
import org.netbeans.modules.e2e.api.schema.SchemaConstruct;

public class Type
extends RepeatableSchemaConstruct {
    public static final short FLAVOR_SEQUENCE = 1;
    public static final short FLAVOR_PRIMITIVE_ENUMERATION = 2;
    public static final short FLAVOR_PRIMITIVE = 3;
    private short flavor;
    private String javaTypeName;
    private List<SchemaConstruct> subconstructs;

    public Type() {
        super(SchemaConstruct.ConstructType.TYPE);
        this.setMinOccurs(1);
        this.setMaxOccurs(1);
        this.subconstructs = new ArrayList<SchemaConstruct>();
    }

    public Type(QName name) {
        super(SchemaConstruct.ConstructType.TYPE, name);
        this.setMinOccurs(1);
        this.setMaxOccurs(1);
        this.subconstructs = new ArrayList<SchemaConstruct>();
    }

    public Type(QName name, short flavor) {
        super(SchemaConstruct.ConstructType.TYPE, name);
        this.setMinOccurs(1);
        this.setMaxOccurs(1);
        this.subconstructs = new ArrayList<SchemaConstruct>();
        this.flavor = flavor;
    }

    public Type(QName name, short flavor, int minOccurs, int maxOccurs) {
        super(SchemaConstruct.ConstructType.TYPE, name);
        this.subconstructs = new ArrayList<SchemaConstruct>();
        this.flavor = flavor;
        this.setMinOccurs(minOccurs);
        this.setMaxOccurs(maxOccurs);
    }

    public void setFlavor(short flavor) {
        this.flavor = flavor;
    }

    public short getFlavor() {
        return this.flavor;
    }

    public void setJavaTypeName(String javaTypeName) {
        this.javaTypeName = javaTypeName;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public void addSubconstruct(SchemaConstruct subconstruct) {
        this.subconstructs.add(subconstruct);
    }

    public List<SchemaConstruct> getSubconstructs() {
        return Collections.unmodifiableList(this.subconstructs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name='" + this.getName() + "' ");
        sb.append("type='");
        if (3 == this.flavor) {
            sb.append("primitive");
        } else if (1 == this.flavor) {
            sb.append("sequence");
        }
        sb.append("' name='" + this.getName());
        sb.append("' minOccurs='" + this.getMinOccurs() + "'");
        if (this.getMaxOccurs() == Integer.MAX_VALUE) {
            sb.append(" maxOccurs='unbounded'");
        } else {
            sb.append(" maxOccurs='" + this.getMaxOccurs() + "'");
        }
        return sb.toString();
    }
}

