/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ThreadsCollector;
import org.netbeans.modules.debugger.jpda.ui.debugging.ClickableIcon;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebugTreeView;
import org.netbeans.modules.debugger.jpda.ui.debugging.InfoPanel;
import org.netbeans.modules.debugger.jpda.ui.debugging.TapPanel;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsListener;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingTreeModel;
import org.netbeans.modules.debugger.jpda.ui.views.ViewModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DebuggingView
extends TopComponent
implements HelpCtx.Provider,
ExplorerManager.Provider,
PropertyChangeListener,
TreeExpansionListener,
TreeModelListener,
AdjustmentListener,
ChangeListener,
MouseWheelListener,
TreeSelectionListener {
    private static final String ID = "debugging";
    public static final int BAR_WIDTH = 8;
    static final Color hitsColor = new Color(255, 255, 178);
    static final Color hitsBarColor = new Color(230, 230, 130);
    static final Color deadlockColor = UIManager.getDefaults().getColor("nb.errorForeground");
    static final Color greenBarColor = new Color(189, 230, 170);
    private transient Color treeBackgroundColor = UIManager.getDefaults().getColor("Tree.textBackground");
    private transient RequestProcessor requestProcessor = new RequestProcessor("DebuggingView Refresh Scheduler", 1);
    private transient boolean refreshScheduled = false;
    private transient ExplorerManager manager = new ExplorerManager();
    private transient ViewModelListener viewModelListener;
    private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
    private PreferenceChangeListener prefListener;
    private SessionsComboBoxListener sessionsComboListener;
    private transient ImageIcon resumeIcon;
    private transient ImageIcon focusedResumeIcon;
    private transient ImageIcon pressedResumeIcon;
    private transient ImageIcon suspendIcon;
    private transient ImageIcon focusedSuspendIcon;
    private transient ImageIcon pressedSuspendIcon;
    private DebugTreeView treeView;
    private TapPanel tapPanel;
    private InfoPanel infoPanel;
    private JPDADebugger debugger;
    private Session session;
    private JPDADebugger previousDebugger;
    private Reference<JPDAThread> threadMadeCurrentRef;
    private Reference<JPDAThread> threadToScrollRef;
    private ViewRefresher viewRefresher = new ViewRefresher();
    private BarsPanel leftPanel;
    private IconsPanel rightPanel;
    private ThreadsListener threadsListener = null;
    private final Object lock = new Object();
    private static Reference<DebuggingView> instance = null;
    private JPanel leftPanel1;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JPanel rightPanel1;
    private JPanel scrollBarPanel;
    private JComboBox sessionComboBox;
    private JScrollBar treeScrollBar;

    public DebuggingView() {
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/debugging.png"));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.treeBackgroundColor = UIManager.getColor("NbExplorerView.background");
        }
        this.initComponents();
        this.resumeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/resume_button_16.png", (boolean)false);
        this.focusedResumeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/resume_button_focused_16.png", (boolean)false);
        this.pressedResumeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/resume_button_pressed_16.png", (boolean)false);
        this.suspendIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/suspend_button_16.png", (boolean)false);
        this.focusedSuspendIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/suspend_button_focused_16.png", (boolean)false);
        this.pressedSuspendIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/suspend_button_pressed_16.png", (boolean)false);
        this.setBackground(this.treeBackgroundColor);
        this.leftPanel = new BarsPanel();
        this.rightPanel = new IconsPanel();
        this.mainPanel.setBackground(this.treeBackgroundColor);
        this.mainPanel.add((Component)this.leftPanel, "West");
        this.mainPanel.add((Component)this.rightPanel, "East");
        this.tapPanel = new TapPanel();
        this.tapPanel.setOrientation(2);
        this.tapPanel.setExpanded(true);
        this.infoPanel = new InfoPanel(this.tapPanel, this);
        this.tapPanel.add(this.infoPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add(this.tapPanel, gridBagConstraints);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.prefListener = new DebuggingPreferenceChangeListener();
        this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)this.preferences));
        this.sessionsComboListener = new SessionsComboBoxListener();
        this.scrollBarPanel.setVisible(false);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.scrollBarPanel.setBackground(this.tapPanel.getBackground());
            this.scrollBarPanel.setOpaque(true);
        }
        this.treeScrollBar.addAdjustmentListener(this);
        this.setSuspendTableVisible(this.preferences.getBoolean("show_suspend_table", true));
    }

    private void initComponents() {
        this.sessionComboBox = new JComboBox();
        this.mainScrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        this.scrollBarPanel = new JPanel();
        this.treeScrollBar = new JScrollBar();
        this.leftPanel1 = new JPanel();
        this.rightPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.sessionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Java Project"}));
        this.sessionComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add(this.sessionComboBox, gridBagConstraints);
        this.sessionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.sessionComboBox.AccessibleContext.accessibleName"));
        this.sessionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.sessionComboBox.AccessibleContext.accessibleDescription"));
        this.mainScrollPane.setBorder(null);
        this.mainScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainScrollPane.setPreferredSize(new Dimension(32, 10));
        this.mainPanel.setLayout(new BorderLayout());
        this.mainScrollPane.setViewportView(this.mainPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.mainScrollPane, gridBagConstraints);
        this.scrollBarPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 17));
        this.scrollBarPanel.setLayout(new BorderLayout());
        this.treeScrollBar.setOrientation(0);
        this.scrollBarPanel.add((Component)this.treeScrollBar, "Center");
        this.leftPanel1.setOpaque(false);
        this.leftPanel1.setPreferredSize(new Dimension(8, 0));
        this.leftPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.scrollBarPanel.add((Component)this.leftPanel1, "West");
        this.rightPanel1.setOpaque(false);
        this.rightPanel1.setPreferredSize(new Dimension(24, 0));
        this.rightPanel1.setLayout(new FlowLayout(1, 0, 0));
        this.scrollBarPanel.add((Component)this.rightPanel1, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add(this.scrollBarPanel, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootContext(Models.CompoundModel model, final DebuggerEngine engine) {
        Object object;
        Object deb;
        Node root = this.manager.getRootContext();
        if (root != null) {
            try {
                root.destroy();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.threadsListener == null) {
            this.threadsListener = ThreadsListener.getDefault();
        }
        if (engine != null) {
            deb = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (deb != null && this.threadsListener != null) {
                this.threadsListener.setDebuggingView(this);
            }
            object = this.lock;
            synchronized (object) {
                if (this.previousDebugger != null) {
                    this.previousDebugger.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.previousDebugger = this.debugger;
                this.debugger = deb;
                if (deb != null) {
                    this.session = (Session)engine.lookupFirst(null, Session.class);
                    deb.addPropertyChangeListener((PropertyChangeListener)this);
                } else {
                    this.session = null;
                }
            }
            RequestProcessor.getDefault().post(new Runnable((JPDADebugger)deb){
                final /* synthetic */ JPDADebugger val$deb;
                {
                    this.val$deb = jPDADebugger;
                }

                @Override
                public void run() {
                    DebuggingView.this.threadsListener.changeDebugger(this.val$deb);
                }
            });
        } else {
            deb = this.lock;
            synchronized (deb) {
                if (this.previousDebugger != null) {
                    this.previousDebugger.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.previousDebugger = null;
                this.debugger = null;
                this.session = null;
            }
            if (this.threadsListener != null) {
                this.threadsListener.changeDebugger(null);
            }
        }
        if (model == null) {
            root = Node.EMPTY;
            this.releaseTreeView();
        } else {
            object = this.lock;
            synchronized (object) {
                if (this.treeView == null) {
                    this.createTreeView();
                }
                root = Models.createNodes((Models.CompoundModel)model, (TreeView)this.treeView);
                this.treeView.setExpansionModel((TreeExpansionModel)model);
            }
        }
        this.manager.setRootContext(root);
        this.refreshView();
        this.updateSessionsComboBox();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingView.this.adjustTreeScrollBar(-1);
                if (engine == null) {
                    DebuggingView.this.setActivatedNodes(new Node[0]);
                    DebugTreeView tView = DebuggingView.this.getTreeView();
                    if (tView != null) {
                        tView.resetSelection();
                    }
                }
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static DebuggingView getInstance() {
        DebuggingView view = (DebuggingView)WindowManager.getDefault().findTopComponent(ID);
        if (view == null) {
            view = DebuggingView.getDefault();
        }
        return view;
    }

    public void setSuspendTableVisible(boolean visible) {
        this.rightPanel.setVisible(visible);
    }

    public static synchronized DebuggingView getDefault() {
        DebuggingView view;
        if (instance == null) {
            view = new DebuggingView();
            instance = new WeakReference<DebuggingView>(view);
        } else {
            view = instance.get();
            if (view == null) {
                view = new DebuggingView();
                instance = new WeakReference<DebuggingView>(view);
            }
        }
        return view;
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.viewModelListener != null) {
            this.viewModelListener.setUp();
            return;
        }
        if (this.viewModelListener != null) {
            throw new InternalError();
        }
        this.viewModelListener = new ViewModelListener("DebuggingView", (JComponent)((Object)this));
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.viewModelListener != null) {
            this.viewModelListener.destroy();
        }
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("DebuggingView");
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        DebugTreeView tView = this.getTreeView();
        if (tView != null) {
            return tView.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public String getName() {
        return NbBundle.getMessage(DebuggingView.class, (String)"CTL_Debugging_view");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(DebuggingView.class, (String)"CTL_Debugging_tooltip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("rootContext".equals(propertyName) || "nodeChange".equals(propertyName)) {
            this.refreshView();
        } else if ("currentThread".equals(propertyName)) {
            JPDAThread currentThread;
            Object object = this.lock;
            synchronized (object) {
                currentThread = this.debugger != null ? this.debugger.getCurrentThread() : null;
            }
            if (currentThread != null) {
                JPDAThread thread;
                JPDAThread jPDAThread = thread = this.threadMadeCurrentRef != null ? this.threadMadeCurrentRef.get() : null;
                if (thread == currentThread) {
                    this.threadToScrollRef = new WeakReference<JPDAThread>(thread);
                }
            }
            this.refreshView();
        } else if (propertyName.equals("selectedNodes")) {
            this.setActivatedNodes((Node[])evt.getNewValue());
        }
    }

    private static boolean isJPDASession(Session s) {
        DebuggerEngine engine = s.getCurrentEngine();
        if (engine == null) {
            return false;
        }
        return engine.lookupFirst(null, JPDADebugger.class) != null;
    }

    void updateSessionsComboBox() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingView.this.sessionComboBox.removeActionListener(DebuggingView.this.sessionsComboListener);
                DebuggingView.this.sessionComboBox.removePopupMenuListener(DebuggingView.this.sessionsComboListener);
                ComboBoxModel model = DebuggingView.this.sessionComboBox.getModel();
                DebuggingView.this.sessionComboBox.removeAllItems();
                DebuggerManager dm = DebuggerManager.getDebuggerManager();
                Session[] sessions = dm.getSessions();
                for (int x = 0; x < sessions.length; ++x) {
                    if (!DebuggingView.isJPDASession(sessions[x])) continue;
                    DebuggingView.this.sessionComboBox.addItem(new SessionItem(sessions[x]));
                }
                if (model.getSize() == 0) {
                    DebuggingView.this.sessionComboBox.addItem(new SessionItem(null));
                }
                DebuggingView.this.sessionComboBox.setSelectedItem(new SessionItem(dm.getCurrentSession()));
                DebuggingView.this.sessionComboBox.setVisible(model.getSize() > 1);
                DebuggingView.this.sessionComboBox.addActionListener(DebuggingView.this.sessionsComboListener);
                DebuggingView.this.sessionComboBox.addPopupMenuListener(DebuggingView.this.sessionsComboListener);
            }
        });
    }

    void makeThreadCurrent(JPDAThread thread) {
        this.threadMadeCurrentRef = new WeakReference<JPDAThread>(thread);
        thread.makeCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTreeView() {
        Object object = this.lock;
        synchronized (object) {
            this.releaseTreeView();
            this.treeView = new DebugTreeView();
            this.treeView.setRootVisible(false);
            this.treeView.setHorizontalScrollBarPolicy(31);
            this.treeView.setVerticalScrollBarPolicy(21);
            this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.treeView.AccessibleContext.accessibleName"));
            this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.treeView.AccessibleContext.accessibleDescription"));
            this.treeView.getTree().addMouseWheelListener(this);
            this.treeView.addTreeExpansionListener(this);
            TreeModel model = this.treeView.getTree().getModel();
            model.addTreeModelListener(this);
            this.treeView.getViewport().addChangeListener(this);
            this.treeView.getTree().addTreeSelectionListener(this);
            this.mainPanel.add((Component)((Object)this.treeView), "Center");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTreeView() {
        Object object = this.lock;
        synchronized (object) {
            if (this.treeView == null) {
                return;
            }
            this.treeView.getTree().removeMouseWheelListener(this);
            this.treeView.removeTreeExpansionListener(this);
            TreeModel model = this.treeView.getTree().getModel();
            model.removeTreeModelListener(this);
            this.treeView.getViewport().removeChangeListener(this);
            this.treeView.getTree().removeTreeSelectionListener(this);
            this.mainPanel.remove((Component)((Object)this.treeView));
            this.treeView = null;
        }
    }

    private DebugTreeView getTreeView() {
        return this.treeView;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.refreshView();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.refreshView();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.refreshView();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.refreshView();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.refreshView();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.refreshView();
    }

    InfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    void refreshView() {
        if (this.refreshScheduled) {
            return;
        }
        this.refreshScheduled = true;
        this.requestProcessor.post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(DebuggingView.this.viewRefresher);
            }
        }, 20);
    }

    private void adjustTreeScrollBar(int treeViewWidth) {
        JScrollBar sbar;
        int unitHeight;
        DebugTreeView tView = this.getTreeView();
        if (tView == null) {
            this.scrollBarPanel.setVisible(false);
            return;
        }
        JViewport viewport = tView.getViewport();
        Point point = viewport.getViewPosition();
        if (point.y < 0) {
            viewport.setViewPosition(new Point(point.x, 0));
        }
        Dimension viewSize = viewport.getExtentSize();
        Dimension treeSize = viewport.getViewSize();
        if (treeViewWidth < 0) {
            treeViewWidth = treeSize.width;
        }
        if ((unitHeight = tView.getUnitHeight()) > 0 && (sbar = this.mainScrollPane.getVerticalScrollBar()).getUnitIncrement() != unitHeight) {
            sbar.setUnitIncrement(unitHeight);
        }
        if (treeViewWidth <= viewSize.width) {
            this.scrollBarPanel.setVisible(false);
        } else {
            this.treeScrollBar.setMaximum(treeViewWidth);
            this.treeScrollBar.setVisibleAmount(viewSize.width);
            if (unitHeight > 0) {
                this.treeScrollBar.setUnitIncrement(unitHeight / 2);
            }
            this.scrollBarPanel.setVisible(true);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        DebugTreeView tView = this.getTreeView();
        if (tView == null) {
            return;
        }
        JViewport viewport = tView.getViewport();
        Point position = viewport.getViewPosition();
        Dimension viewSize = viewport.getExtentSize();
        Rectangle newRect = new Rectangle(e.getValue(), position.y, viewSize.width, viewSize.height);
        ((JComponent)viewport.getView()).scrollRectToVisible(newRect);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingView.this.adjustTreeScrollBar(-1);
            }
        });
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar scrollBar = this.mainScrollPane.getVerticalScrollBar();
        if (e.getScrollType() == 0) {
            int totalScrollAmount = e.getUnitsToScroll() * scrollBar.getUnitIncrement();
            scrollBar.setValue(scrollBar.getValue() + totalScrollAmount);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getNewLeadSelectionPath();
        DebugTreeView tView = this.getTreeView();
        if (path != null && tView != null) {
            int row;
            JTree tree = tView.getTree();
            Rectangle rect = tree.getRowBounds(row = tree.getRowForPath(path));
            if (rect == null) {
                return;
            }
            JViewport viewport = this.mainScrollPane.getViewport();
            ((JComponent)viewport.getView()).scrollRectToVisible(rect);
        }
    }

    private class SessionItem {
        private Session session;

        SessionItem(Session session) {
            this.session = session;
        }

        public Session getSession() {
            return this.session;
        }

        public String toString() {
            if (this.session != null) {
                return this.session.getName();
            }
            return '<' + NbBundle.getMessage(DebuggingView.class, (String)"LBL_No_Session_Running") + '>';
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SessionItem)) {
                return false;
            }
            Session s = ((SessionItem)obj).getSession();
            if (this.session == null) {
                return s == null;
            }
            return this.session.equals(s);
        }

        public int hashCode() {
            return 87 + (this.session != null ? this.session.hashCode() : 0);
        }
    }

    private class SessionsComboBoxListener
    implements ActionListener,
    PopupMenuListener {
        SessionItem selectedItem = null;
        boolean popupVisible = false;

        private SessionsComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SessionItem si = (SessionItem)DebuggingView.this.sessionComboBox.getSelectedItem();
            if (this.popupVisible) {
                this.selectedItem = si;
            } else {
                this.changeSession(si);
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.popupVisible = true;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.changeSession(this.selectedItem);
            this.selectedItem = null;
            this.popupVisible = false;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.selectedItem = null;
            this.popupVisible = false;
        }

        private void changeSession(SessionItem si) {
            if (si != null) {
                Session ses = si.getSession();
                DebuggerManager dm = DebuggerManager.getDebuggerManager();
                if (ses != null && ses != dm.getCurrentSession()) {
                    dm.setCurrentSession(ses);
                }
            }
        }
    }

    private class IconsPanel
    extends JPanel {
        private int endSY;
        private int counter;
        private ArrayList<IconItem> icons = new ArrayList();

        IconsPanel() {
            this.setBackground(DebuggingView.this.treeBackgroundColor);
            this.setPreferredSize(new Dimension(24, 0));
            this.setLayout(new FlowLayout(0, 0, 0));
        }

        public void startReset() {
            this.counter = 0;
            this.endSY = 0;
        }

        public void endReset() {
            int size = this.icons.size();
            for (int x = size - 1; x >= this.counter; --x) {
                this.remove(x);
                this.icons.remove(x);
            }
        }

        public void addIcon(int sx, int sy, int rowHeight, JPDAThread jpdaThread) {
            int height = sy - this.endSY + rowHeight;
            if (this.counter < this.icons.size()) {
                IconItem item = this.icons.get(this.counter);
                item.icon.changeThread(jpdaThread, (Container)((Object)DebuggingView.this), sx, sy, 24, height);
                item.panel.setPreferredSize(new Dimension(24, height));
                item.height = height;
            } else {
                JPanel panel = new JPanel(new GridBagLayout());
                panel.setBackground(DebuggingView.this.treeBackgroundColor);
                panel.setOpaque(false);
                panel.setPreferredSize(new Dimension(24, height));
                ClickableIcon icon = new ClickableIcon(DebuggingView.this.resumeIcon, DebuggingView.this.focusedResumeIcon, DebuggingView.this.pressedResumeIcon, DebuggingView.this.suspendIcon, DebuggingView.this.focusedSuspendIcon, DebuggingView.this.pressedSuspendIcon, jpdaThread, DebuggingView.this.treeView);
                icon.setBackground(DebuggingView.this.treeBackgroundColor);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 15;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                int delta = rowHeight - 16;
                int insetTop = delta / 2;
                int insetBottom = delta - insetTop;
                gridBagConstraints.insets = new Insets(insetTop, 0, insetBottom, 0);
                panel.add((Component)icon, gridBagConstraints);
                icon.initializeState((Container)((Object)DebuggingView.this), sx, sy, 24, height);
                IconItem item = new IconItem(height, icon, panel);
                this.icons.add(item);
                this.add(panel);
            }
            ++this.counter;
            this.endSY += height;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            DebugTreeView tView = DebuggingView.this.getTreeView();
            if (tView != null) {
                tView.paintStripes(g, this);
            }
        }

        private class IconItem {
            private int height;
            private ClickableIcon icon;
            private JPanel panel;

            IconItem(int height, ClickableIcon icon, JPanel panel) {
                this.height = height;
                this.icon = icon;
                this.panel = panel;
            }
        }
    }

    private class BarsPanel
    extends JPanel
    implements MouseMotionListener {
        private ArrayList<Bar> bars = new ArrayList();

        BarsPanel() {
            this.setBackground(DebuggingView.this.treeBackgroundColor);
            this.setPreferredSize(new Dimension(8, 0));
            this.setLayout(new FlowLayout(0, 0, 0));
            this.addMouseMotionListener(this);
        }

        public void clearBars() {
            this.bars.clear();
        }

        public void addBar(boolean isCurrent, boolean atBreakpoint, boolean inDeadlock, int height, int sy) {
            String toolTipText = null;
            Color color = null;
            Color secondaryColor = null;
            if (inDeadlock) {
                color = deadlockColor;
                toolTipText = NbBundle.getMessage(DebuggingView.class, (String)"LBL_DEADLOCKED_THREAD_TIP");
            } else if (isCurrent) {
                color = greenBarColor;
                toolTipText = NbBundle.getMessage(DebuggingView.class, (String)"LBL_CURRENT_BAR_TIP");
            } else if (atBreakpoint) {
                color = hitsBarColor;
                toolTipText = NbBundle.getMessage(DebuggingView.class, (String)"LBL_BREAKPOINT_HIT_TIP");
            }
            if (isCurrent && inDeadlock) {
                secondaryColor = greenBarColor;
                toolTipText = NbBundle.getMessage(DebuggingView.class, (String)"LBL_CURRENT_DEADLOCKED_TIP");
            }
            Bar bar = new Bar(sy, height, color, secondaryColor, toolTipText);
            this.bars.add(bar);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color originalColor = g.getColor();
            Rectangle clipRect = g.getClipBounds();
            double clipYStart = clipRect.getY();
            double clipYEnd = clipYStart + clipRect.getHeight() - 1.0;
            int width = (int)this.getBounds().getWidth();
            for (Bar bar : this.bars) {
                Rectangle rect;
                if ((double)(bar.sy + bar.height - 1) < clipYStart) continue;
                if ((double)bar.sy > clipYEnd) break;
                if (bar.color != null) {
                    rect = new Rectangle(0, bar.sy + 1, width, bar.height - 1);
                    rect = rect.intersection(clipRect);
                    g.setColor(bar.color);
                    g.fillRect(rect.x, rect.y, rect.width, rect.height);
                }
                if (bar.secondaryColor == null) continue;
                rect = new Rectangle(width / 2 - 1, bar.sy + 1, (width + 1) / 2 + 1, bar.height - 1);
                if ((rect = rect.intersection(clipRect)).isEmpty()) continue;
                g.setColor(bar.secondaryColor);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            g.setColor(originalColor);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.computeToolTipText(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.computeToolTipText(e);
        }

        private void computeToolTipText(MouseEvent evt) {
            int sy = evt.getY();
            try {
                for (Bar bar : this.bars) {
                    if (sy < bar.sy || sy >= bar.sy + bar.height) continue;
                    this.setToolTipText(bar.toolTipText);
                    return;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.setToolTipText(null);
        }

        private class Bar {
            private int sy;
            private int height;
            private Color color;
            private Color secondaryColor = null;
            private String toolTipText;

            Bar(int sy, int height, Color color, Color secondary, String toolTipText) {
                this.sy = sy;
                this.height = height;
                this.color = color;
                this.secondaryColor = secondary;
                this.toolTipText = toolTipText;
            }
        }
    }

    private final class ViewRefresher
    implements Runnable {
        private ViewRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JViewport viewport;
            int aRectHeight;
            Rectangle aRect;
            Set deadlocks;
            ThreadsCollector tc;
            JPDAThread currentThread;
            DebugTreeView tView = DebuggingView.this.getTreeView();
            DebuggingView.this.refreshScheduled = false;
            DebuggingView.this.leftPanel.clearBars();
            DebuggingView.this.rightPanel.startReset();
            int sx = (DebuggingView.this.rightPanel.getWidth() - 24) / 2;
            int sy = 0;
            Object object = DebuggingView.this.lock;
            synchronized (object) {
                currentThread = DebuggingView.this.debugger != null ? DebuggingView.this.debugger.getCurrentThread() : null;
                tc = DebuggingView.this.debugger != null ? DebuggingView.this.debugger.getThreadsCollector() : null;
            }
            Set set = deadlocks = tc != null ? tc.getDeadlockDetector().getDeadlocks() : Collections.EMPTY_SET;
            if (deadlocks == null) {
                deadlocks = Collections.EMPTY_SET;
            }
            HashSet deadlockedThreads = new HashSet();
            for (DeadlockDetector.Deadlock deadlock : deadlocks) {
                deadlockedThreads.addAll(deadlock.getThreads());
            }
            JPDAThread threadToScroll = DebuggingView.this.threadToScrollRef != null ? (JPDAThread)DebuggingView.this.threadToScrollRef.get() : null;
            DebuggingView.this.threadToScrollRef = null;
            int scrollStart = -1;
            int scrollEnd = -1;
            boolean pathToScrollSearching = false;
            int mainPanelHeight = 0;
            int treeViewWidth = 0;
            int leftBarHeight = 0;
            boolean isCurrent = false;
            boolean isAtBreakpoint = false;
            boolean isInDeadlock = false;
            JPDAThread currentObject = null;
            int currentSY = 0;
            int height = 0;
            if (tView != null) {
                for (TreePath path : tView.getVisiblePaths()) {
                    Node node = Visualizer.findNode((Object)path.getLastPathComponent());
                    JPDAThread jpdaThread = (JPDAThread)node.getLookup().lookup(JPDAThread.class);
                    JPDAThreadGroup jpdaThreadGroup = (JPDAThreadGroup)node.getLookup().lookup(JPDAThreadGroup.class);
                    JTree tree = tView.getTree();
                    Rectangle rect = tree.getRowBounds(tree.getRowForPath(path));
                    int n = height = rect != null ? (int)Math.round(rect.getHeight()) : 0;
                    if (jpdaThread != null || jpdaThreadGroup != null) {
                        boolean bl = pathToScrollSearching = jpdaThread == threadToScroll;
                        if (pathToScrollSearching) {
                            scrollStart = mainPanelHeight;
                        }
                        if (currentObject != null) {
                            this.addPanels(currentObject, isCurrent, isAtBreakpoint, isInDeadlock, leftBarHeight, sx, currentSY, height);
                        }
                        leftBarHeight = 0;
                        if (jpdaThread != null) {
                            isCurrent = jpdaThread == currentThread && (jpdaThread.isSuspended() || DebuggingTreeModel.isMethodInvoking(jpdaThread));
                            isAtBreakpoint = DebuggingView.this.threadsListener.isBreakpointHit(jpdaThread);
                            isInDeadlock = deadlockedThreads.contains(jpdaThread);
                        } else {
                            isCurrent = false;
                            isAtBreakpoint = false;
                            isInDeadlock = false;
                        }
                        currentObject = jpdaThread != null ? jpdaThread : jpdaThreadGroup;
                        currentSY = sy;
                    }
                    mainPanelHeight += height;
                    treeViewWidth = rect != null ? Math.max(treeViewWidth, (int)Math.round(rect.getX() + rect.getWidth())) : treeViewWidth;
                    leftBarHeight += height;
                    sy += height;
                    if (!pathToScrollSearching) continue;
                    scrollEnd = mainPanelHeight;
                }
            }
            if (currentObject != null) {
                this.addPanels(currentObject, isCurrent, isAtBreakpoint, isInDeadlock, leftBarHeight, sx, currentSY, height);
            }
            DebuggingView.this.rightPanel.endReset();
            DebuggingView.this.leftPanel.repaint();
            DebuggingView.this.rightPanel.revalidate();
            DebuggingView.this.rightPanel.repaint();
            if (tView != null) {
                tView.getTree().setPreferredSize(new Dimension(treeViewWidth, 0));
            }
            DebuggingView.this.mainPanel.setPreferredSize(new Dimension(0, mainPanelHeight));
            DebuggingView.this.mainScrollPane.revalidate();
            DebuggingView.this.mainPanel.revalidate();
            if (tView != null) {
                tView.repaint();
            }
            DebuggingView.this.adjustTreeScrollBar(treeViewWidth);
            if (scrollStart > -1 && !(aRect = new Rectangle(0, scrollStart, 1, aRectHeight = Math.min(scrollEnd - scrollStart + 1, (viewport = DebuggingView.this.mainScrollPane.getViewport()).getHeight()))).isEmpty()) {
                ((JComponent)viewport.getView()).scrollRectToVisible(aRect);
            }
        }

        private void addPanels(Object jpdaObject, boolean current, boolean atBreakpoint, boolean inDeadlock, int height, int sx, int sy, int rowHeight) {
            if (current || atBreakpoint || inDeadlock) {
                DebuggingView.this.leftPanel.addBar(current, atBreakpoint, inDeadlock, height, sy);
            }
            if (jpdaObject instanceof JPDAThread) {
                DebuggingView.this.rightPanel.addIcon(sx, sy, rowHeight, (JPDAThread)jpdaObject);
            }
        }
    }

    private final class DebuggingPreferenceChangeListener
    implements PreferenceChangeListener {
        private DebuggingPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if ("show_suspend_table".equals(key)) {
                DebuggingView.this.setSuspendTableVisible(evt.getNewValue().equals("true"));
            }
        }
    }
}

