/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.Nullable;
import org.netbeans.modules.db.metadata.model.api.Ordering;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.netbeans.modules.db.metadata.model.api.SQLType;

public final class JDBCUtils {
    private static final Logger LOGGER = Logger.getLogger(JDBCUtils.class.getName());
    private static EnumSet<SQLType> charTypes = EnumSet.of(SQLType.CHAR, SQLType.VARCHAR, SQLType.LONGVARCHAR);
    private static EnumSet<SQLType> dateTypes = EnumSet.of(SQLType.DATE, SQLType.TIME, SQLType.TIMESTAMP);
    private static EnumSet<SQLType> numericTypes = EnumSet.of(SQLType.TINYINT, new SQLType[]{SQLType.INTEGER, SQLType.BIGINT, SQLType.SMALLINT, SQLType.FLOAT, SQLType.DOUBLE, SQLType.REAL, SQLType.NUMERIC, SQLType.DECIMAL});

    public static SQLType getSQLType(int type) {
        switch (type) {
            case -7: {
                return SQLType.BIT;
            }
            case -6: {
                return SQLType.TINYINT;
            }
            case 5: {
                return SQLType.SMALLINT;
            }
            case 4: {
                return SQLType.INTEGER;
            }
            case -5: {
                return SQLType.BIGINT;
            }
            case 6: {
                return SQLType.FLOAT;
            }
            case 7: {
                return SQLType.REAL;
            }
            case 8: {
                return SQLType.DOUBLE;
            }
            case 2: {
                return SQLType.NUMERIC;
            }
            case 3: {
                return SQLType.DECIMAL;
            }
            case 1: {
                return SQLType.CHAR;
            }
            case 12: {
                return SQLType.VARCHAR;
            }
            case -1: {
                return SQLType.LONGVARCHAR;
            }
            case 91: {
                return SQLType.DATE;
            }
            case 92: {
                return SQLType.TIME;
            }
            case 93: {
                return SQLType.TIMESTAMP;
            }
            case -2: {
                return SQLType.BINARY;
            }
            case -3: {
                return SQLType.VARBINARY;
            }
            case -4: {
                return SQLType.LONGVARBINARY;
            }
            case 0: {
                return SQLType.NULL;
            }
            case 1111: {
                return SQLType.OTHER;
            }
            case 2000: {
                return SQLType.JAVA_OBJECT;
            }
            case 2001: {
                return SQLType.DISTINCT;
            }
            case 2002: {
                return SQLType.STRUCT;
            }
            case 2003: {
                return SQLType.ARRAY;
            }
            case 2004: {
                return SQLType.BLOB;
            }
            case 2005: {
                return SQLType.CLOB;
            }
            case 2006: {
                return SQLType.REF;
            }
            case 70: {
                return SQLType.DATALINK;
            }
            case 16: {
                return SQLType.BOOLEAN;
            }
            case -16: {
                return SQLType.LONGVARCHAR;
            }
            case -15: {
                return SQLType.CHAR;
            }
            case 2011: {
                return SQLType.CLOB;
            }
            case -9: {
                return SQLType.VARCHAR;
            }
        }
        Logger.getLogger(JDBCUtils.class.getName()).log(Level.WARNING, "Unknown JDBC column type: " + type + ". Returns null.");
        return null;
    }

    public static boolean isCharType(SQLType type) {
        return charTypes.contains((Object)type);
    }

    public static boolean isDateType(SQLType type) {
        return dateTypes.contains((Object)type);
    }

    public static boolean isNumericType(SQLType type) {
        return numericTypes.contains((Object)type);
    }

    public static Nullable getColumnNullable(int dbmdColumnNullable) {
        switch (dbmdColumnNullable) {
            case 0: {
                return Nullable.NOT_NULLABLE;
            }
            case 1: {
                return Nullable.NULLABLE;
            }
        }
        return Nullable.UNKNOWN;
    }

    public static Nullable getProcedureNullable(int dbmdProcedureNullable) {
        switch (dbmdProcedureNullable) {
            case 0: {
                return Nullable.NOT_NULLABLE;
            }
            case 1: {
                return Nullable.NULLABLE;
            }
        }
        return Nullable.UNKNOWN;
    }

    public static Parameter.Direction getDirection(short sqlDirection) {
        switch (sqlDirection) {
            case 4: {
                return Parameter.Direction.OUT;
            }
            case 2: {
                return Parameter.Direction.INOUT;
            }
            case 1: {
                return Parameter.Direction.IN;
            }
        }
        LOGGER.log(Level.INFO, "Unknown direction value from DatabaseMetadat.getProcedureColumns(): " + sqlDirection);
        return Parameter.Direction.IN;
    }

    public static Ordering getOrdering(String ascOrDesc) {
        if (ascOrDesc == null || ascOrDesc.length() == 0) {
            return Ordering.NOT_SUPPORTED;
        }
        if (ascOrDesc.equals("A")) {
            return Ordering.ASCENDING;
        }
        if (ascOrDesc.equals("D")) {
            return Ordering.DESCENDING;
        }
        LOGGER.log(Level.INFO, "Unexpected ordering code from database: " + ascOrDesc);
        return Ordering.NOT_SUPPORTED;
    }

    static Index.IndexType getIndexType(short sqlIndexType) {
        switch (sqlIndexType) {
            case 2: {
                return Index.IndexType.HASHED;
            }
            case 1: {
                return Index.IndexType.CLUSTERED;
            }
            case 3: {
                return Index.IndexType.OTHER;
            }
            case 0: {
                LOGGER.log(Level.INFO, "Got unexpected index type of tableIndexStatistic, marking as 'other'");
                return Index.IndexType.OTHER;
            }
        }
        LOGGER.log(Level.INFO, "Unexpected index type code from database metadata: " + sqlIndexType);
        return Index.IndexType.OTHER;
    }
}

