/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.GrailsSources;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPluginSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class SourceRoots {
    private final FileObject projectRoot;
    private final GrailsProject project;

    public SourceRoots(GrailsProject project, FileObject projectRoot) {
        this.projectRoot = projectRoot;
        this.project = project;
    }

    public FileObject[] getRoots() {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        this.addGrailsSourceRoots(this.projectRoot, result);
        if (this.project != null) {
            GrailsPluginSupport pluginSupport = GrailsPluginSupport.forProject(this.project);
            if (pluginSupport != null) {
                result.addAll(this.addPluginRoots(this.project.getBuildConfig().getProjectPluginsDir(), pluginSupport.getProjectPluginFilter()));
            }
            result.addAll(this.addPluginRoots(this.project.getBuildConfig().getGlobalPluginsDir(), null));
            for (GrailsPlugin plugin : this.project.getBuildConfig().getLocalPlugins()) {
                FileObject fo;
                if (plugin.getPath() == null || (fo = FileUtil.toFileObject((File)plugin.getPath())) == null) continue;
                this.addGrailsSourceRoots(fo, result);
            }
        }
        return result.toArray(new FileObject[result.size()]);
    }

    public List<URL> getRootURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (FileObject fileObject : this.getRoots()) {
                urls.add(FileUtil.toFile((FileObject)fileObject).toURI().toURL());
            }
        }
        catch (MalformedURLException murle) {
            Exceptions.printStackTrace((Throwable)murle);
        }
        return urls;
    }

    private List<FileObject> addPluginRoots(File pluginsDirFile, GrailsPluginSupport.FolderFilter filter) {
        FileObject pluginsDir;
        FileObject fileObject = pluginsDir = pluginsDirFile == null ? null : FileUtil.toFileObject((File)pluginsDirFile);
        if (pluginsDir != null) {
            ArrayList<FileObject> result = new ArrayList<FileObject>();
            Enumeration subfolders = pluginsDir.getFolders(false);
            while (subfolders.hasMoreElements()) {
                FileObject subFolder = (FileObject)subfolders.nextElement();
                if (filter != null && !filter.accept(subFolder.getNameExt())) continue;
                this.addGrailsSourceRoots(subFolder, result);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void addGrailsSourceRoots(FileObject projectRoot, List<FileObject> result) {
        SourceRoots.addRoot(projectRoot, SourceCategory.GRAILSAPP_CONF, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.GRAILSAPP_CONTROLLERS, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.GRAILSAPP_DOMAIN, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.GRAILSAPP_SERVICES, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.GRAILSAPP_TAGLIB, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.GRAILSAPP_UTILS, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.SCRIPTS, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.SRC_GROOVY, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.SRC_JAVA, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.SRC_GWT, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.TEST_INTEGRATION, result);
        SourceRoots.addRoot(projectRoot, SourceCategory.TEST_UNIT, result);
        File pluginsDirFile = this.project == null ? null : this.project.getBuildConfig().getProjectPluginsDir();
        FileObject pluginsDir = pluginsDirFile == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)pluginsDirFile));
        File globalPluginsDirFile = this.project == null ? null : this.project.getBuildConfig().getGlobalPluginsDir();
        FileObject globalPluginsDir = globalPluginsDirFile == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)globalPluginsDirFile));
        for (FileObject child : projectRoot.getChildren()) {
            if (!child.isFolder() || !VisibilityQuery.getDefault().isVisible(child) || GrailsSources.KNOWN_FOLDERS.contains(child.getName()) || child == pluginsDir || child == globalPluginsDir) continue;
            result.add(child);
        }
        SourceRoots.addUnknownRoots(GrailsSources.KNOWN_FOLDERS_IN_GRAILS_APP, projectRoot, result, "grails-app");
        SourceRoots.addUnknownRoots(GrailsSources.KNOWN_OR_IGNORED_FOLDERS_IN_TEST, projectRoot, result, "test");
    }

    private static void addUnknownRoots(Collection<String> alreadyKnown, FileObject projectRoot, List<FileObject> result, String relativePath) {
        FileObject folder = projectRoot.getFileObject(relativePath);
        if (folder != null) {
            for (FileObject child : folder.getChildren()) {
                if (!child.isFolder() || !VisibilityQuery.getDefault().isVisible(child) || alreadyKnown.contains(child.getName())) continue;
                result.add(child);
            }
        }
    }

    private static void addRoot(FileObject projectRoot, SourceCategory category, List<FileObject> roots) {
        FileObject root = projectRoot.getFileObject(category.getRelativePath());
        if (root != null) {
            roots.add(root);
        }
    }
}

