/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp;

import java.awt.Color;
import java.util.EventListener;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public class EmbeddedSectionsHighlighting
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private static final Logger LOG = Logger.getLogger(EmbeddedSectionsHighlighting.class.getName());
    private final Document document;
    private final AttributeSet groovyBackground;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    EmbeddedSectionsHighlighting(Document document) {
        Color jsBC;
        this.document = document;
        AttributeSet attribs = null;
        String mimeType = (String)document.getProperty("mimeType");
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)mimeType).lookup(FontColorSettings.class);
        if (fcs != null && (jsBC = EmbeddedSectionsHighlighting.getColoring(fcs, GspTokenId.GROOVY.primaryCategory())) != null) {
            attribs = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, jsBC, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE});
        }
        this.groovyBackground = attribs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        EmbeddedSectionsHighlighting embeddedSectionsHighlighting = this;
        synchronized (embeddedSectionsHighlighting) {
            if (this.groovyBackground != null) {
                if (this.hierarchy == null) {
                    this.hierarchy = TokenHierarchy.get((Document)this.document);
                    if (this.hierarchy != null) {
                        this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
                    }
                }
                if (this.hierarchy != null) {
                    return new Highlights(this.version, this.hierarchy, startOffset, endOffset);
                }
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
        EmbeddedSectionsHighlighting embeddedSectionsHighlighting = this;
        synchronized (embeddedSectionsHighlighting) {
            ++this.version;
        }
        this.fireHighlightsChange(evt.affectedStartOffset(), evt.affectedEndOffset());
    }

    private static Color getColoring(FontColorSettings fcs, String tokenName) {
        AttributeSet as = fcs.getTokenFontColors(tokenName);
        if (as != null) {
            return (Color)as.getAttribute(StyleConstants.Background);
        }
        return null;
    }

    private static boolean isWhitespace(Document document, int startOffset, int endOffset) throws BadLocationException {
        CharSequence chars = DocumentUtilities.getText((Document)document, (int)startOffset, (int)(endOffset - startOffset));
        for (int i = 0; i < chars.length(); ++i) {
            if (Character.isWhitespace(chars.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final class Factory
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)"gsp-embedded-groovy-scriplets-highlighting-layer", (ZOrder)ZOrder.SYNTAX_RACK.forPosition(110), (boolean)true, (HighlightsContainer)new EmbeddedSectionsHighlighting(context.getDocument()))};
        }
    }

    private class Highlights
    implements HighlightsSequence {
        private final long version;
        private final TokenHierarchy<?> scanner;
        private final int startOffset;
        private final int endOffset;
        private TokenSequence<?> sequence = null;
        private int sectionStart = -1;
        private int sectionEnd = -1;
        private boolean finished = false;

        private Highlights(long version, TokenHierarchy<?> scanner, int startOffset, int endOffset) {
            this.version = version;
            this.scanner = scanner;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            EmbeddedSectionsHighlighting embeddedSectionsHighlighting = EmbeddedSectionsHighlighting.this;
            synchronized (embeddedSectionsHighlighting) {
                if (this.checkVersion()) {
                    if (this.sequence == null) {
                        this.sequence = this.scanner.tokenSequence();
                        this.sequence.move(this.startOffset);
                    }
                    int delimiterSize = 0;
                    while (this.sequence.moveNext() && this.sequence.offset() < this.endOffset) {
                        if (this.sequence.token().id() == GspTokenId.DELIMITER) {
                            delimiterSize = this.sequence.token().length();
                            continue;
                        }
                        if (!GspTokenId.isGroovy(this.sequence.token().id())) continue;
                        this.sectionStart = this.sequence.offset();
                        this.sectionEnd = this.sequence.offset() + this.sequence.token().length();
                        try {
                            int docLen = EmbeddedSectionsHighlighting.this.document.getLength();
                            int startLine = Utilities.getLineOffset((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document), (int)Math.min(this.sectionStart, docLen));
                            int endLine = Utilities.getLineOffset((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document), (int)Math.min(this.sectionEnd, docLen));
                            if (startLine != endLine) {
                                int lines;
                                int lastLineEndOffset;
                                int firstLineStartOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document), (int)startLine);
                                if (firstLineStartOffset < this.sectionStart - delimiterSize && EmbeddedSectionsHighlighting.isWhitespace(EmbeddedSectionsHighlighting.this.document, firstLineStartOffset, this.sectionStart - delimiterSize)) {
                                    this.sectionStart = firstLineStartOffset;
                                }
                                if (this.sectionEnd + 2 >= (lastLineEndOffset = endLine + 1 < (lines = Utilities.getRowCount((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document))) ? Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document), (int)(endLine + 1)) : EmbeddedSectionsHighlighting.this.document.getLength() + 1) || EmbeddedSectionsHighlighting.isWhitespace(EmbeddedSectionsHighlighting.this.document, this.sectionEnd + 2, lastLineEndOffset)) {
                                    this.sectionEnd = lastLineEndOffset;
                                }
                            }
                        }
                        catch (BadLocationException ble) {
                            LOG.log(Level.WARNING, null, ble);
                        }
                        return true;
                    }
                }
                this.sectionStart = -1;
                this.sectionEnd = -1;
                this.finished = true;
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            EmbeddedSectionsHighlighting embeddedSectionsHighlighting = EmbeddedSectionsHighlighting.this;
            synchronized (embeddedSectionsHighlighting) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.sequence != null) : "Sequence not initialized, call moveNext() first.";
                return Math.max(this.sectionStart, this.startOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            EmbeddedSectionsHighlighting embeddedSectionsHighlighting = EmbeddedSectionsHighlighting.this;
            synchronized (embeddedSectionsHighlighting) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.sequence != null) : "Sequence not initialized, call moveNext() first.";
                return Math.min(this.sectionEnd, this.endOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            EmbeddedSectionsHighlighting embeddedSectionsHighlighting = EmbeddedSectionsHighlighting.this;
            synchronized (embeddedSectionsHighlighting) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.sequence != null) : "Sequence not initialized, call moveNext() first.";
                return EmbeddedSectionsHighlighting.this.groovyBackground;
            }
        }

        private boolean checkVersion() {
            return this.version == EmbeddedSectionsHighlighting.this.version;
        }
    }
}

