/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.CLIHandler;
import org.netbeans.core.TimableEventQueue;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class CLIOptions2
extends CLIHandler
implements Runnable {
    private int cnt;
    private static final Logger LOG = Logger.getLogger(CLIOptions2.class.getName());
    private static final int EQ_TIMEOUT = 10000;
    private final RequestProcessor.Task task;
    static CLIOptions2 INSTANCE;

    public CLIOptions2() {
        super(2);
        INSTANCE = this;
        this.task = RequestProcessor.getDefault().create((Runnable)this);
    }

    protected int cli(CLIHandler.Args arguments) {
        return this.cli(arguments.getArguments());
    }

    final int cli(String[] args) {
        if (this.cnt++ == 0) {
            return 0;
        }
        LOG.fine("CLI running");
        SwingUtilities.invokeLater(this);
        this.task.schedule(10000);
        return 0;
    }

    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            this.eqStuck();
            return;
        }
        LOG.fine("running in EQ");
        this.task.cancel();
        Frame f = WindowManager.getDefault().getMainWindow();
        f.setVisible(true);
        if ((f.getExtendedState() & 1) != 0) {
            f.setExtendedState(0xFFFFFFFE & f.getExtendedState());
        }
        f.toFront();
    }

    private void eqStuck() {
        Thread eq = TimableEventQueue.eq;
        if (eq == null) {
            LOG.warning("event queue thread not determined");
            return;
        }
        LOG.log(Level.FINE, "EQ stuck in {0}", eq);
        LOG.log(Level.INFO, null, new EQStuck(eq));
        eq.stop();
    }

    protected void usage(PrintWriter w) {
    }

    private static class EQStuck
    extends Throwable {
        EQStuck(Thread eq) {
            super("GUI is not responsive");
            StackTraceElement[] stack = Thread.getAllStackTraces().get(eq);
            if (stack != null) {
                this.setStackTrace(stack);
            } else {
                LOG.log(Level.WARNING, "no stack trace available for {0}", eq);
            }
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

