/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public class DLightExecutorService {
    private static final Logger log = DLightLogger.getLogger(DLightExecutorService.class);
    private static final String PREFIX = "DLIGHT: ";
    private static final RequestProcessor processor = new RequestProcessor("DLIGHT: ", 50);
    private static final CopyOnWriteArrayList<DLightScheduledTask> scheduledTasks = new CopyOnWriteArrayList();

    private DLightExecutorService() {
    }

    public static <T> Future<T> submit(final Callable<T> task, final String name) {
        FutureTask ftask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Thread.currentThread().setName(DLightExecutorService.PREFIX + name);
                return task.call();
            }
        });
        processor.post(ftask);
        return ftask;
    }

    public static void submit(final Runnable task, final String name) {
        processor.post(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(DLightExecutorService.PREFIX + name);
                task.run();
            }
        });
    }

    public static DLightScheduledTask scheduleAtFixedRate(Runnable task, long period, TimeUnit unit, String descr) {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new TaskThreadFactory(descr));
        service.scheduleAtFixedRate(task, 0L, period, unit);
        DLightScheduledTask result = new DLightScheduledTask(service, descr);
        scheduledTasks.add(result);
        return result;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scheduledTasks.isEmpty()) {
                    log.log(Level.WARNING, "DLightExecutorService: not all registered scheduled tasks cancelled!");
                }
                for (DLightScheduledTask task : scheduledTasks) {
                    task.cancel();
                }
            }
        }));
    }

    public static final class DLightScheduledTask
    implements Cancellable {
        private final ScheduledExecutorService service;
        private final String descr;

        DLightScheduledTask(ScheduledExecutorService service, String descr) {
            this.service = service;
            this.descr = descr;
            log.log(Level.FINEST, "DLightScheduledTask ({0}) started", descr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(long timeoutSeconds) {
            try {
                this.service.shutdown();
                try {
                    if (!this.service.awaitTermination(timeoutSeconds, TimeUnit.SECONDS)) {
                        this.service.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    this.service.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                if (this.service.isShutdown()) {
                    log.log(Level.FINEST, "DLightScheduledTask ({0}) stopped", this.descr);
                    boolean bl = true;
                    return bl;
                }
                log.log(Level.FINEST, "DLightScheduledTask ({0}) FAILED to stop", this.descr);
                boolean bl = false;
                return bl;
            }
            finally {
                scheduledTasks.remove(this);
            }
        }

        public boolean cancel() {
            return this.cancel(0L);
        }
    }

    static class TaskThreadFactory
    implements ThreadFactory {
        static final AtomicInteger threadNumber = new AtomicInteger(1);
        static final String namePrefix = "DLIGHT: DLightScheduledTask No. ";
        final String threadName;
        final ThreadGroup group;

        TaskThreadFactory(String threadName) {
            this.threadName = namePrefix + threadNumber.getAndIncrement() + " [ " + threadName + " ]";
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.threadName, 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

