/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.buildsupport;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildProjectActionHandlerFactory;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildTraceSupport;
import org.netbeans.modules.cnd.discovery.wizard.BuildActionsProviderImpl;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HelperLibraryUtility;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;
import org.openide.windows.InputOutput;

class BuildProjectActionHandler
implements ProjectActionHandler {
    private ProjectActionHandler delegate;
    private ProjectActionEvent pae;
    private ExecutionEnvironment execEnv;
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private Collection<BuildActionsProvider.OutputStreamHandler> outputHandlers;

    BuildProjectActionHandler() {
    }

    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes, Collection<BuildActionsProvider.OutputStreamHandler> outputHandlers) {
        this.pae = pae;
        this.delegate = BuildProjectActionHandlerFactory.createDelegateHandler(pae);
        this.delegate.init(pae, paes, outputHandlers);
        this.execEnv = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
        this.outputHandlers = outputHandlers;
    }

    public void addExecutionListener(ExecutionListener l) {
        this.delegate.addExecutionListener(l);
        this.listeners.add(l);
    }

    public void removeExecutionListener(ExecutionListener l) {
        this.delegate.removeExecutionListener(l);
        this.listeners.remove(l);
    }

    public boolean canCancel() {
        return this.delegate.canCancel();
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public void execute(InputOutput io) {
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
            }

            public void executionFinished(int rc) {
                BuildProjectActionHandler.this.delegate.removeExecutionListener((ExecutionListener)this);
            }
        };
        this.delegate.addExecutionListener(listener);
        File execLog = null;
        String remoteExecLog = null;
        try {
            execLog = File.createTempFile("exec", ".log");
            execLog.deleteOnExit();
            if (this.outputHandlers != null) {
                for (BuildActionsProvider.OutputStreamHandler handler : this.outputHandlers) {
                    if (!(handler instanceof BuildActionsProviderImpl.ConfigureAction)) continue;
                    BuildActionsProviderImpl.ConfigureAction myHandler = (BuildActionsProviderImpl.ConfigureAction)handler;
                    myHandler.setExecLog(execLog);
                }
            }
            if (this.execEnv.isRemote()) {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
                remoteExecLog = hostInfo.getTempDir() + "/" + execLog.getName();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (execLog != null) {
            Env env = this.pae.getProfile().getEnvironment();
            env.putenv("__CND_TOOLS__", BuildTraceSupport.CND_TOOLS_VALUE);
            if (this.execEnv.isRemote()) {
                env.putenv("__CND_BUILD_LOG__", remoteExecLog);
            } else {
                env.putenv("__CND_BUILD_LOG__", execLog.getAbsolutePath());
            }
            try {
                String merge = env.getenv("LD_PRELOAD");
                merge = merge != null && !merge.isEmpty() ? BuildTraceHelper.INSTANCE.getLibraryName(this.execEnv) + ":" + merge : BuildTraceHelper.INSTANCE.getLibraryName(this.execEnv);
                env.putenv("LD_PRELOAD", merge);
                merge = env.getenv("LD_LIBRARY_PATH");
                merge = merge != null && !merge.isEmpty() ? BuildTraceHelper.INSTANCE.getLDPaths(this.execEnv) + ":" + merge : BuildTraceHelper.INSTANCE.getLDPaths(this.execEnv);
                env.putenv("LD_LIBRARY_PATH", merge);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.delegate.execute(io);
    }

    private static final class BuildTraceHelper
    extends HelperLibraryUtility {
        private static final BuildTraceHelper INSTANCE = new BuildTraceHelper();

        private BuildTraceHelper() {
            super("org.netbeans.modules.cnd.actions", "bin/${osname}-${platform}${_isa}/libBuildTrace.so");
        }
    }
}

