/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.projectimport.CreateDependencies;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ImportExecutable
implements PropertyChangeListener {
    private static final boolean DLL_FILE_SEARCH = true;
    private static final RequestProcessor RP = new RequestProcessor(ImportExecutable.class.getName(), 2);
    private final Map<String, Object> map;
    private Project lastSelectedProject;
    private final IteratorExtension.ProjectKind projectKind;
    private CreateDependencies cd;
    private final boolean createProjectMode;
    private String sourcesPath;
    private boolean addSourceRoot;
    private List<String> dependencies;
    private static final List<CsmProgressListener> listeners = new ArrayList<CsmProgressListener>(1);

    public ImportExecutable(Map<String, Object> map, Project project, IteratorExtension.ProjectKind projectKind) {
        this.map = map;
        this.lastSelectedProject = project;
        this.projectKind = projectKind;
        if (project == null) {
            this.createProjectMode = true;
            this.postCreateProject();
        } else {
            this.addSourceRoot = true;
            this.createProjectMode = false;
        }
    }

    private void postCreateProject() {
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportExecutable.class, (String)"ImportExecutable.Progress.ProjectCreating"));
                progressHandle.start();
                try {
                    ImportExecutable.this.createProject();
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
                finally {
                    progressHandle.finish();
                }
            }
        });
    }

    private void createProject() {
        String string;
        String string2;
        String string3 = (String)this.map.get("outputTextField");
        this.sourcesPath = (String)this.map.get("sourceFolderPath");
        File file = (File)this.map.get("projdir");
        String string4 = (String)this.map.get("name");
        this.dependencies = (List)this.map.get("dependencies");
        if (file != null) {
            file = CndFileUtils.normalizeFile((File)file);
            string2 = file.getAbsolutePath();
            if (string4 == null) {
                string4 = file.getName();
            }
        } else {
            string = ProjectGenerator.getDefaultProjectFolder();
            if (string4 == null) {
                string4 = ProjectGenerator.getValidProjectName((String)string, (String)new File(string3).getName());
            }
            string2 = string + File.separator + string4;
            file = CndFileUtils.createLocalFile((String)string2);
        }
        string = (String)this.map.get("hostUID");
        CompilerSet compilerSet = (CompilerSet)this.map.get("toolchain");
        boolean bl = Boolean.TRUE.equals(this.map.get("toolchainDefault"));
        MakeConfiguration makeConfiguration = new MakeConfiguration(file.getPath(), "Default", 0, string, compilerSet, bl);
        String string5 = ProjectSupport.toProperPath((String)CndPathUtilitities.naturalizeSlashes((String)string2), (String)this.sourcesPath, (MakeProjectOptions.PathMode)MakeProjectOptions.getPathMode());
        makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(string5);
        String string6 = string3;
        string6 = CndPathUtilitities.toRelativePath((String)CndPathUtilitities.naturalizeSlashes((String)string2), (String)string6);
        string6 = CndPathUtilitities.normalizeSlashes((String)string6);
        makeConfiguration.getMakefileConfiguration().getOutput().setValue(string6);
        String string7 = new File(string3).getParentFile().getAbsolutePath();
        string7 = CndPathUtilitities.toRelativePath((String)CndPathUtilitities.naturalizeSlashes((String)string2), (String)string7);
        string7 = CndPathUtilitities.normalizeSlashes((String)string7);
        makeConfiguration.getProfile().setRunDirectory(string7);
        makeConfiguration.getProfile().setBuildFirst(false);
        ProjectGenerator.ProjectParameters projectParameters = new ProjectGenerator.ProjectParameters(string4, file);
        projectParameters.setOpenFlag(false).setConfiguration(makeConfiguration).setImportantFiles(Collections.singletonList(string3).iterator()).setMakefileName("");
        Boolean bl2 = (Boolean)this.map.get("trueSourceRoot");
        if (bl2 != null && bl2.booleanValue()) {
            ArrayList<2> arrayList = new ArrayList<2>();
            arrayList.add(new SourceFolderInfo(){

                public FileObject getFileObject() {
                    return CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)ImportExecutable.this.sourcesPath));
                }

                public String getFolderName() {
                    return this.getFileObject().getNameExt();
                }

                public boolean isAddSubfoldersSelected() {
                    return true;
                }
            });
            projectParameters.setSourceFolders(arrayList.iterator());
        } else {
            this.addSourceRoot = true;
        }
        projectParameters.setSourceFoldersFilter("^(nbproject)$");
        try {
            this.lastSelectedProject = ProjectGenerator.createProject((ProjectGenerator.ProjectParameters)projectParameters);
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            this.map.put("DW:buildResult", string3);
            this.map.put("DW:consolidationLevel", "file");
            this.map.put("DW:rootFolder", this.lastSelectedProject.getProjectDirectory().getPath());
            OpenProjects.getDefault().open(new Project[]{this.lastSelectedProject}, false);
            OpenProjects.getDefault().setMainProject(this.lastSelectedProject);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("openProjects") && propertyChangeEvent.getNewValue() instanceof Project[]) {
            Project[] projectArray = (Project[])propertyChangeEvent.getNewValue();
            if (projectArray.length == 0) {
                return;
            }
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            if (this.lastSelectedProject == null) {
                return;
            }
            IteratorExtension iteratorExtension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            if (iteratorExtension != null) {
                this.process((DiscoveryExtension)iteratorExtension);
            }
        }
    }

    public void process(final DiscoveryExtension discoveryExtension) {
        ImportExecutable.switchModel(false, this.lastSelectedProject);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object;
                    Object object2;
                    DiscoveryExtensionInterface.Applicable applicable;
                    block13: {
                        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getBundle(ImportExecutable.class).getString("ImportExecutable.Progress"));
                        progressHandle.start();
                        applicable = null;
                        try {
                            object2 = (ConfigurationDescriptorProvider)ImportExecutable.this.lastSelectedProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
                            MakeConfigurationDescriptor makeConfigurationDescriptor = object2.getConfigurationDescriptor(true);
                            applicable = discoveryExtension.isApplicable(ImportExecutable.this.map, ImportExecutable.this.lastSelectedProject);
                            if (!applicable.isApplicable()) break block13;
                            if (ImportExecutable.this.sourcesPath == null) {
                                ImportExecutable.this.sourcesPath = applicable.getSourceRoot();
                            }
                            if (ImportExecutable.this.addSourceRoot && ImportExecutable.this.sourcesPath != null && ImportExecutable.this.sourcesPath.length() > 1) {
                                makeConfigurationDescriptor.addSourceRoot(ImportExecutable.this.sourcesPath);
                            }
                            if (!ImportExecutable.this.createProjectMode) {
                                ImportExecutable.resetCompilerSet(makeConfigurationDescriptor.getActiveConfiguration(), applicable);
                            }
                            object = null;
                            if (ImportExecutable.this.projectKind == IteratorExtension.ProjectKind.IncludeDependencies && (object = ImportExecutable.this.additionalDependencies(applicable, makeConfigurationDescriptor.getActiveConfiguration(), DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getBuildResult())) != null && !((String)object).isEmpty()) {
                                ImportExecutable.this.map.put("DW:libraries", object);
                            }
                            if (!discoveryExtension.canApply(ImportExecutable.this.map, ImportExecutable.this.lastSelectedProject)) break block13;
                            try {
                                discoveryExtension.apply(ImportExecutable.this.map, ImportExecutable.this.lastSelectedProject);
                                ImportExecutable.discoverScripts(ImportExecutable.this.lastSelectedProject);
                                ImportExecutable.saveMakeConfigurationDescriptor(ImportExecutable.this.lastSelectedProject);
                                if (ImportExecutable.this.projectKind == IteratorExtension.ProjectKind.CreateDependencies && (object == null || ((String)object).isEmpty())) {
                                    ImportExecutable.this.cd = new CreateDependencies(ImportExecutable.this.lastSelectedProject, DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getDependencies(), ImportExecutable.this.dependencies, DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getSearchPaths(), DiscoveryWizardDescriptor.adaptee(ImportExecutable.this.map).getBuildResult());
                                }
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace(System.err);
                            }
                        }
                        finally {
                            progressHandle.finish();
                        }
                    }
                    object2 = applicable.getMainFunction();
                    boolean bl = true;
                    if (object2 != null && (object = CndFileUtils.toFileObject((CharSequence)object2.getFilePath())) != null && object.isValid() && CsmUtilities.openSource((FileObject)object, (int)object2.getLine(), (int)0)) {
                        bl = false;
                    }
                    ImportExecutable.switchModel(true, ImportExecutable.this.lastSelectedProject);
                    object = bl ? "main" : null;
                    ImportExecutable.this.onProjectParsingFinished((String)object, ImportExecutable.this.lastSelectedProject);
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
            }
        };
        RP.post(runnable);
    }

    private static void discoverScripts(Project project) {
        Item[] itemArray;
        Item[] itemArray2;
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (configurationDescriptorProvider == null) {
            return;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor(true);
        if (makeConfigurationDescriptor == null) {
            return;
        }
        MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
        if (makeConfiguration == null) {
            return;
        }
        String string = ImportExecutable.findFolderPath(makeConfigurationDescriptor, ImportExecutable.getRoot(makeConfigurationDescriptor));
        if (string == null) {
            return;
        }
        File file = new File(string);
        Object object = ImportExecutable.scanFolder(file);
        if ((((DiscoveredConfigure)object).script == null || ((DiscoveredConfigure)object).makefile == null) && ((DiscoveredConfigure)(itemArray2 = ImportExecutable.scanFolder((File)(itemArray = file.getParentFile())))).script != null && ((DiscoveredConfigure)itemArray2).makefile != null && ((DiscoveredConfigure)object).scriptWeight < ((DiscoveredConfigure)itemArray2).scriptWeight) {
            object = itemArray2;
        }
        if ((((DiscoveredConfigure)object).script == null || ((DiscoveredConfigure)object).makefile == null) && (itemArray = file.listFiles()) != null) {
            for (File file2 : itemArray) {
                DiscoveredConfigure discoveredConfigure;
                if (!file2.isDirectory() || (discoveredConfigure = ImportExecutable.scanFolder(file2)).script == null || discoveredConfigure.makefile == null || ((DiscoveredConfigure)object).scriptWeight >= discoveredConfigure.scriptWeight) continue;
                object = discoveredConfigure;
            }
        }
        if (((DiscoveredConfigure)object).makefile != null) {
            makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(((DiscoveredConfigure)object).makefile.getParentFile().getAbsolutePath());
            makeConfiguration.getMakefileConfiguration().getBuildCommand().setValue("${MAKE} -f " + ((DiscoveredConfigure)object).makefile.getName());
            makeConfiguration.getMakefileConfiguration().getCleanCommand().setValue("${MAKE} -f " + ((DiscoveredConfigure)object).makefile.getName() + " clean");
            itemArray = makeConfigurationDescriptor.getExternalItemFolder();
            for (Item item : itemArray.getAllItemsAsArray()) {
                if (!"text/x-make".equals(item.getMIMEType())) continue;
                itemArray.removeItem(item);
                break;
            }
            itemArray.addItem(new Item(((DiscoveredConfigure)object).makefile.getAbsolutePath()));
            if (((DiscoveredConfigure)object).script != null) {
                itemArray.addItem(new Item(((DiscoveredConfigure)object).script.getAbsolutePath()));
            }
        }
    }

    private static DiscoveredConfigure scanFolder(File file) {
        DiscoveredConfigure discoveredConfigure = new DiscoveredConfigure();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.isFile()) continue;
                String string = file2.getName();
                if ("CMakeLists.txt".equals(string)) {
                    discoveredConfigure.setScript(file2, 3);
                    continue;
                }
                if (string.endsWith(".pro")) {
                    discoveredConfigure.setScript(file2, 4);
                    continue;
                }
                if ("configure".equals(string) || "configure.exe".equals(string)) {
                    discoveredConfigure.setScript(file2, 5);
                    continue;
                }
                if ("Makefile".equals(string)) {
                    discoveredConfigure.setMakefile(file2, 5);
                    continue;
                }
                if ("makefile".equals(string)) {
                    discoveredConfigure.setMakefile(file2, 4);
                    continue;
                }
                if ("GNUmakefile".equals(string)) {
                    discoveredConfigure.setMakefile(file2, 3);
                    continue;
                }
                if (!string.endsWith(".mk")) continue;
                discoveredConfigure.setMakefile(file2, 2);
            }
        }
        return discoveredConfigure;
    }

    private String additionalDependencies(DiscoveryExtensionInterface.Applicable applicable, MakeConfiguration makeConfiguration, String string) {
        if (this.dependencies == null) {
            String string222;
            String string3 = this.sourcesPath;
            if (string3 == null || string3.length() == 0) {
                string3 = applicable.getSourceRoot();
            }
            if (string3 == null || string3.length() == 0) {
                return null;
            }
            if (applicable.getDependencies() == null || applicable.getDependencies().isEmpty()) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string4 = CommonUtilities.getLdLibraryPath((MakeConfiguration)makeConfiguration);
            string4 = CommonUtilities.addSearchPaths((String)string4, applicable.getSearchPaths(), (String)string);
            boolean bl = false;
            for (String string222 : applicable.getDependencies()) {
                String string5 = ImportExecutable.findLocation(string222, string4);
                if (string5 != null) {
                    hashMap.put(string222, string5);
                    continue;
                }
                bl = true;
                hashMap.put(string222, null);
            }
            if (bl && string3.length() > 1) {
                ImportExecutable.gatherSubFolders(new File(string3), new HashSet<String>(), hashMap);
            }
            StringBuilder stringBuilder = new StringBuilder();
            string222 = CndPathUtilitities.getDirName((String)string);
            for (Map.Entry entry : hashMap.entrySet()) {
                if (entry.getValue() == null || !ImportExecutable.isMyDll((String)entry.getValue(), string3) && !ImportExecutable.isMyDll((String)entry.getValue(), string222)) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(';');
                }
                stringBuilder.append((String)entry.getValue());
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string6 : this.dependencies) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(string6);
        }
        return stringBuilder.toString();
    }

    private void onProjectParsingFinished(final String string, final Project project) {
        if (project != null) {
            final NativeProject nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
            CsmProgressAdapter csmProgressAdapter = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject csmProject) {
                    if (csmProject.getPlatformProject().equals(nativeProject)) {
                        String string2;
                        Collection collection;
                        Iterator iterator;
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        listeners.remove((Object)this);
                        if (csmProject instanceof ProjectBase && string != null && (iterator = (collection = ((ProjectBase)csmProject).findDeclarationsByPrefix(string2 = Utils.getCsmDeclarationKindkey((CsmDeclaration.Kind)CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + string + '(')).iterator()).hasNext()) {
                            CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)iterator.next();
                            CsmUtilities.openSource((CsmObject)csmOffsetableDeclaration);
                        }
                        ImportExecutable.fixExcludedHeaderFiles(project, null);
                        if (ImportExecutable.this.cd != null) {
                            ImportExecutable.this.cd.create();
                        }
                    }
                }
            };
            listeners.add((CsmProgressListener)csmProgressAdapter);
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)csmProgressAdapter);
        }
    }

    static void switchModel(boolean bl, Project project) {
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel instanceof ModelImpl && project != null) {
            NativeProject nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
            if (bl) {
                ((ModelImpl)csmModel).enableProject(nativeProject);
            } else {
                ((ModelImpl)csmModel).disableProject(nativeProject);
            }
        }
    }

    static void fixExcludedHeaderFiles(Project project, Logger logger) {
        NativeProject nativeProject;
        CsmProject csmProject;
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel instanceof ModelImpl && project != null && (csmProject = csmModel.getProject((Object)(nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class)))) != null && nativeProject != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<ProjectBase> hashSet2 = new HashSet<ProjectBase>();
            HashMap<String, Item> hashMap = ImportProject.initNormalizedNames(project);
            Object object5 = csmProject.getAllFiles().iterator();
            while (object5.hasNext()) {
                Object object6;
                object4 = (CsmFile)object5.next();
                if (!(object4 instanceof FileImpl)) continue;
                object3 = (FileImpl)object4;
                object2 = object3.getNativeFileItem();
                if (object2 == null) {
                    String string = ((Object)object3.getAbsolutePath()).toString();
                    object2 = (NativeFileItem)hashMap.get(string);
                }
                boolean bl = false;
                if (object2 != null && object2.getLanguage() == NativeFileItem.Language.C_HEADER && csmProject instanceof ProjectBase && (object = (object6 = (ProjectBase)csmProject).getGraph().getParentFiles((CsmFile)object4)).isEmpty()) {
                    bl = true;
                }
                if (object2 != null && nativeProject.equals(object2.getNativeProject()) && object2.isExcluded()) {
                    if (!(object2 instanceof Item)) continue;
                    if (logger != null) {
                        logger.log(Level.FINE, "#fix excluded header for file {0}", object3.getAbsolutePath());
                    }
                    ProjectBridge.setExclude((Item)object2, false);
                    ProjectBridge.setHeaderTool((Item)object2);
                    if (!object4.isHeaderFile()) continue;
                    hashSet.add(object2.getAbsolutePath());
                    continue;
                }
                if (bl && object2 != null && nativeProject.equals(object2.getNativeProject()) && !object2.isExcluded()) {
                    if (!(object2 instanceof Item)) continue;
                    if (logger != null) {
                        logger.log(Level.FINE, "#fix included for file {0}", object3.getAbsolutePath());
                    }
                    ProjectBridge.setExclude((Item)object2, true);
                    continue;
                }
                if (object2 != null || !object4.isHeaderFile()) continue;
                object6 = ((Object)object3.getAbsolutePath()).toString();
                hashSet2.add((ProjectBase)object6);
            }
            if ((hashSet.size() > 0 || hashSet2.size() > 0) && ((ProjectBridge)(object5 = new ProjectBridge(project))).isValid()) {
                if (hashSet2.size() > 0) {
                    object4 = ((ProjectBridge)object5).prefferedFolders();
                    object3 = hashSet2.iterator();
                    while (object3.hasNext()) {
                        Object object7;
                        Object object8;
                        int n;
                        Object object9 = object2 = (String)object3.next();
                        if (Utilities.isWindows()) {
                            object2 = ((String)object2).replace('\\', '/');
                        }
                        if ((n = ((String)object2).lastIndexOf(47)) < 0) continue;
                        object = ((String)object2).substring(0, n);
                        Folder folder = (Folder)object4.get(object);
                        if (folder == null) {
                            object8 = new LinkedList();
                            while ((n = ((String)object).lastIndexOf(47)) > 0) {
                                ((LinkedList)object8).addLast(((String)object).substring(n + 1));
                                folder = (Folder)object4.get(object = ((String)object).substring(0, n));
                                if (folder == null) continue;
                            }
                            if (folder != null) {
                                while (!((AbstractCollection)object8).isEmpty()) {
                                    object7 = (String)((LinkedList)object8).pollLast();
                                    folder = folder.addNewFolder((String)object7, (String)object7, true, (Folder.Kind)null);
                                    object = (String)object + "/" + (String)object7;
                                    object4.put(object, folder);
                                }
                            }
                        }
                        if (folder == null) continue;
                        object8 = ((ProjectBridge)object5).getRelativepath((String)object9);
                        object7 = ((ProjectBridge)object5).getProjectItem((String)object8);
                        if (object7 == null) {
                            object7 = ((ProjectBridge)object5).createItem((String)object9);
                            object7 = folder.addItem(object7);
                        }
                        if (object7 == null) continue;
                        ProjectBridge.setHeaderTool(object7);
                        if (MIMENames.isCppOrCOrFortran((String)object7.getMIMEType())) continue;
                        hashSet.add((String)object2);
                    }
                }
                if (hashSet.size() > 0) {
                    ((ProjectBridge)object5).checkForNewExtensions(hashSet);
                }
            }
            ImportExecutable.saveMakeConfigurationDescriptor(project);
        }
    }

    static void resetCompilerSet(MakeConfiguration makeConfiguration, DiscoveryExtensionInterface.Applicable applicable) {
        if (makeConfiguration != null) {
            CompilerSetManager compilerSetManager = CompilerSetManager.get((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment());
            if (applicable.isSunStudio()) {
                CompilerSet compilerSet = compilerSetManager.getDefaultCompilerSet();
                if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
                    return;
                }
                List list = CompilerSetManager.get((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).getCompilerSets();
                compilerSet = null;
                for (CompilerSet compilerSet2 : list) {
                    if (!compilerSet2.getCompilerFlavor().isSunStudioCompiler()) continue;
                    if ("OracleSolarisStudio".equals(compilerSet2.getName())) {
                        compilerSet = compilerSet2;
                    }
                    if (compilerSet != null) continue;
                    compilerSet = compilerSet2;
                }
                if (compilerSet != null) {
                    makeConfiguration.getCompilerSet().setValue(compilerSet.getName());
                }
            } else {
                CompilerSet compilerSet = compilerSetManager.getDefaultCompilerSet();
                if (compilerSet != null && !compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
                    return;
                }
                List list = CompilerSetManager.get((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).getCompilerSets();
                compilerSet = null;
                for (CompilerSet compilerSet3 : list) {
                    if (compilerSet3.getCompilerFlavor().isSunStudioCompiler() || compilerSet != null) continue;
                    compilerSet = compilerSet3;
                }
                if (compilerSet != null) {
                    makeConfiguration.getCompilerSet().setValue(compilerSet.getName());
                }
            }
        }
    }

    static void saveMakeConfigurationDescriptor(Project project) {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            makeConfigurationDescriptor.setModified();
            makeConfigurationDescriptor.save();
            makeConfigurationDescriptor.checkForChangedItems(project, null, null);
        }
    }

    static boolean isMyDll(String string, String string2) {
        if (string.startsWith(string2)) {
            return true;
        }
        String[] stringArray = string.split("/");
        String[] stringArray2 = string2.split("/");
        for (int i = 0; i < Math.min(stringArray.length - 1, stringArray2.length); ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            return i > 2;
        }
        return false;
    }

    static String findLocation(String string, String string2) {
        if (string2 != null) {
            String string3 = ":";
            if (string2.indexOf(59) > 0) {
                string3 = ";";
            }
            for (String string4 : string2.split(string3)) {
                File file = new File(string4, string);
                if (!file.isFile() || !file.exists()) continue;
                String string5 = file.getAbsolutePath();
                return string5.replace('\\', '/');
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void gatherSubFolders(File file, HashSet<String> hashSet, Map<String, String> map) {
        if (!file.exists() || !file.isDirectory() || !file.canRead()) return;
        String string = file.getAbsolutePath();
        if (hashSet.contains(string = string.replace('\\', '/'))) return;
        hashSet.add(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) return;
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            try {
                string2 = fileArray[i].getCanonicalPath();
                String string3 = fileArray[i].getAbsolutePath();
                if (!string3.equals(string2) && string3.startsWith(string2)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (map.containsKey(string2 = fileArray[i].getName())) {
                map.put(string2, fileArray[i].getAbsolutePath());
            }
            ImportExecutable.gatherSubFolders(fileArray[i], hashSet, map);
        }
    }

    static Folder getRoot(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        Folder folder = makeConfigurationDescriptor.getLogicalFolders();
        List list = folder.getFolders();
        for (Folder folder2 : list) {
            if (!folder2.isProjectFiles()) continue;
            if ("SourceFiles".equals(folder2.getName())) {
                return folder2;
            }
            if ("HeaderFiles".equals(folder2.getName()) || "ResourceFiles".equals(folder2.getName())) continue;
            return folder2;
        }
        return folder;
    }

    static String findFolderPath(MakeConfigurationDescriptor makeConfigurationDescriptor, Folder folder) {
        if (folder == null) {
            return null;
        }
        if (folder.isDiskFolder()) {
            String string = CndPathUtilitities.toAbsolutePath((String)makeConfigurationDescriptor.getBaseDir(), (String)folder.getRoot());
            return RemoteFileUtil.normalizeAbsolutePath((String)string, (Project)makeConfigurationDescriptor.getProject());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : folder.getElements()) {
            Folder object2;
            String string;
            if (!(object instanceof Folder) || (string = ImportExecutable.findFolderPath(object2 = (Folder)object, "/" + object2.getName())) == null) continue;
            arrayList.add(string + "/" + object2.getName());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (String)arrayList.get(0);
        }
        Object object = null;
        for (String string : arrayList) {
            if (object == null) {
                object = string;
                continue;
            }
            if (((String)object).startsWith(string)) {
                object = string;
                continue;
            }
            if (((String)object).length() <= string.length()) continue;
            object = string;
        }
        return object;
    }

    static String findFolderPath(Folder folder, String string) {
        String string2;
        Item item;
        for (Object e : folder.getElements()) {
            int n;
            if (!(e instanceof Item)) continue;
            item = (Item)e;
            string2 = item.getAbsPath();
            if (string.isEmpty() || (n = (string2 = string2.replace('\\', '/')).indexOf(string + "/")) < 0) continue;
            return string2.substring(0, n);
        }
        for (Object e : folder.getElements()) {
            if (!(e instanceof Folder) || (string2 = ImportExecutable.findFolderPath((Folder)(item = (Folder)e), string + "/" + item.getName())) == null) continue;
            if (string.isEmpty()) {
                return string2 + "/" + item.getName();
            }
            return string2;
        }
        return null;
    }

    private static final class DiscoveredConfigure {
        private File script;
        private int scriptWeight;
        private File makefile;
        private int makefileWeight;

        private DiscoveredConfigure() {
        }

        private void setScript(File file, int n) {
            if (this.script == null || this.scriptWeight < n) {
                this.script = file;
                this.scriptWeight = n;
            }
        }

        private void setMakefile(File file, int n) {
            if (this.makefile == null || this.makefileWeight < n) {
                this.makefile = file;
                this.makefileWeight = n;
            }
        }
    }
}

