/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchParams;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchSupport;
import org.netbeans.modules.nativeexecution.support.hostinfo.FetchHostInfoTask;
import org.openide.util.Exceptions;

public final class HostInfoUtils {
    public static final String LOCALHOST = "localhost";
    private static final List<String> myIPAdresses = new ArrayList<String>();
    private static final ConcurrentHashMap<ExecutionEnvironment, HostInfo> cache = new ConcurrentHashMap();

    private HostInfoUtils() {
    }

    public static void dumpInfo(HostInfo hostinfo, PrintStream stream) {
        stream.println("------------");
        if (hostinfo == null) {
            stream.println("HostInfo is NULL");
        } else {
            stream.println("Hostname      : " + hostinfo.getHostname());
            stream.println("OS Family     : " + (Object)((Object)hostinfo.getOSFamily()));
            stream.println("OS            : " + hostinfo.getOS().getName());
            stream.println("OS Version    : " + hostinfo.getOS().getVersion());
            stream.println("OS Bitness    : " + (Object)((Object)hostinfo.getOS().getBitness()));
            stream.println("CPU Family    : " + (Object)((Object)hostinfo.getCpuFamily()));
            stream.println("CPU #         : " + hostinfo.getCpuNum());
            stream.println("login shell   : " + hostinfo.getLoginShell());
            stream.println("shell         : " + hostinfo.getShell());
            stream.println("tmpdir to use : " + hostinfo.getTempDir());
            stream.println("tmpdir (file) to use : " + hostinfo.getTempDirFile().toString());
        }
        stream.println("------------");
    }

    public static boolean fileExists(ExecutionEnvironment execEnv, String fname) throws ConnectException, IOException, InterruptedException {
        boolean fileExists = false;
        if (execEnv.isLocal()) {
            fileExists = new File(fname).exists();
        } else {
            if (!ConnectionManager.getInstance().isConnectedTo(execEnv)) {
                throw new ConnectException();
            }
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(execEnv);
            npb.setExecutable("test").setArguments("-e", fname);
            fileExists = npb.call().waitFor() == 0;
        }
        return fileExists;
    }

    public static String searchFile(ExecutionEnvironment execEnv, List<String> searchPaths, String file, boolean searchInUserPaths) {
        String result = null;
        try {
            result = new FileSearchSupport().searchFile(new FileSearchParams(execEnv, searchPaths, file, searchInUserPaths));
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return result;
    }

    public static boolean isLocalhost(String host) {
        boolean result = false;
        try {
            result = myIPAdresses.contains(InetAddress.getByName(host).getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isHostInfoAvailable(ExecutionEnvironment execEnv) {
        return cache.containsKey(execEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostInfo getHostInfo(ExecutionEnvironment execEnv) throws IOException, CancellationException {
        if (execEnv == null) {
            throw new IllegalArgumentException("ExecutionEnvironment should not be null");
        }
        if (!HostInfoUtils.isHostInfoAvailable(execEnv)) {
            Logger.assertNonUiThread("Don't call getHostInfo() from the UI thread while info is not known. Use quick isHostInfoAvailable() to detect whether info is available or not and go out of EDT if not");
        }
        Class<HostInfoUtils> clazz = HostInfoUtils.class;
        synchronized (HostInfoUtils.class) {
            HostInfo result = cache.get(execEnv);
            if (result == null) {
                try {
                    if (!ConnectionManager.getInstance().isConnectedTo(execEnv)) {
                        ConnectionManager.getInstance().connectTo(execEnv);
                        result = cache.get(execEnv);
                        if (result != null) {
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return result;
                        }
                    }
                    if ((result = new FetchHostInfoTask().compute(execEnv)) == null) {
                        throw new IOException("Error getting host info for " + execEnv);
                    }
                    cache.put(execEnv, result);
                }
                catch (InterruptedException ex) {
                    throw new CancellationException("getHostInfo(" + execEnv.getDisplayName() + ") cancelled.");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void updateHostInfo(ExecutionEnvironment execEnv) throws IOException, InterruptedException {
        HostInfo result = new FetchHostInfoTask().compute(execEnv);
        if (result != null) {
            cache.put(execEnv, result);
        }
    }

    protected static void resetHostsData() {
        cache.clear();
    }

    static {
        NetworkInterface iface = null;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                iface = ifaces.nextElement();
                Enumeration<InetAddress> ips = iface.getInetAddresses();
                while (ips.hasMoreElements()) {
                    myIPAdresses.add(ips.nextElement().getHostAddress());
                }
            }
        }
        catch (SocketException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

