/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.EnvUtils;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.support.EnvWriter;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.Utilities;

public final class MacroMap
implements Cloneable {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private final ExecutionEnvironment execEnv;
    private final MacroExpanderFactory.MacroExpander macroExpander;
    private final TreeMap<String, String> map;
    private final Set<String> varsForExport = new HashSet<String>();
    private final boolean isWindows;

    private MacroMap(ExecutionEnvironment execEnv, MacroExpanderFactory.MacroExpander macroExpander, boolean init) {
        this.execEnv = execEnv;
        this.macroExpander = macroExpander;
        this.isWindows = execEnv.isLocal() && Utilities.isWindows();
        this.map = this.isWindows ? new TreeMap(new CaseInsensitiveComparator()) : new TreeMap();
        if (init && HostInfoUtils.isHostInfoAvailable(execEnv)) {
            try {
                this.map.putAll(HostInfoUtils.getHostInfo(execEnv).getEnvironment());
            }
            catch (IOException ex) {
            }
            catch (CancellationException ex) {
                // empty catch block
            }
        }
        this.varsForExport.addAll(Arrays.asList(EnvWriter.wellKnownVars));
    }

    public static MacroMap forExecEnv(ExecutionEnvironment execEnv) {
        return new MacroMap(execEnv, MacroExpanderFactory.getExpander(execEnv), true);
    }

    public static MacroMap createEmpty(ExecutionEnvironment execEnv) {
        return new MacroMap(execEnv, MacroExpanderFactory.getExpander(execEnv), false);
    }

    public final void putAll(MacroMap envVariables) {
        if (envVariables == null) {
            return;
        }
        this.putAll(envVariables.map);
    }

    public final void putAll(Map<String, String> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public final void putAll(String[] env) {
        if (env == null) {
            return;
        }
        for (String envString : env) {
            this.put(EnvUtils.getKey(envString), EnvUtils.getValue(envString));
        }
    }

    public String put(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            log.log(Level.INFO, "Attempt to set env variable '%s' with null value", key);
        }
        String result = value;
        TreeMap<String, String> oneElementMap = this.isWindows ? new TreeMap<String, String>(new CaseInsensitiveComparator()) : new TreeMap();
        String val = this.map.get(key);
        if (val != null) {
            oneElementMap.put(key, val);
        }
        try {
            result = this.macroExpander.expandMacros(value, oneElementMap);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        this.varsForExport.add(key);
        return this.map.put(key, result);
    }

    public String get(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.map.get(key);
    }

    public Set<String> getExportVariablesSet() {
        return Collections.unmodifiableSet(this.varsForExport);
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            buf.append(entry.getKey());
            buf.append(" = ");
            buf.append(entry.getValue());
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final Set<Map.Entry<String, String>> entrySet() {
        return this.map.entrySet();
    }

    public MacroMap clone() {
        MacroMap clone = new MacroMap(this.execEnv, this.macroExpander, false);
        clone.map.putAll(this.map);
        clone.varsForExport.addAll(this.varsForExport);
        return clone;
    }

    public void prependPathVariable(String name, String path) {
        if (path == null) {
            return;
        }
        String oldpath = this.get(name);
        String newPath = path + (oldpath == null ? "" : (this.isWindows ? (char)';' : ':') + oldpath);
        newPath = newPath.replaceAll("::", ":");
        newPath = newPath.replaceAll("^:", "");
        newPath = newPath.replaceAll(":$", "");
        this.put(name, newPath);
    }

    public void appendPathVariable(String name, String path) {
        if (path == null) {
            return;
        }
        String oldpath = this.get(name);
        String newPath = (oldpath == null ? "" : oldpath + (this.isWindows ? (char)';' : ':')) + path;
        this.put(name, newPath);
    }

    public void dump(PrintStream out) {
        for (Map.Entry<String, String> entry : this.entrySet()) {
            out.printf("Environment: %s=%s\n", entry.getKey(), entry.getValue());
        }
    }

    public String remove(String name) {
        return this.map.remove(name);
    }

    public Map<String, String> toMap() {
        return new TreeMap<String, String>((SortedMap<String, String>)this.map);
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        @Override
        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.toUpperCase().compareTo(s2.toUpperCase());
        }
    }
}

