/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import java.util.HashSet;
import java.util.Set;
import javax.swing.text.Position;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.api.parser.SourceUtils;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoring;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringElement;
import org.netbeans.modules.groovy.refactoring.Utils;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class GroovyWhereUsed
extends ProgressProviderAdapter
implements GroovyRefactoring {
    private final WhereUsedQuery whereUsedQuery;
    private final FileObject fileObject;
    private final String fqn;

    public GroovyWhereUsed(FileObject fileObject, String fqn, WhereUsedQuery whereUsedQuery) {
        this.fqn = fqn;
        this.fileObject = fileObject;
        this.whereUsedQuery = whereUsedQuery;
    }

    @Override
    public Problem prepare(final RefactoringElementsBag refactoringElements) {
        Set<FileObject> relevantFiles = this.getRelevantFiles();
        for (final FileObject fo : relevantFiles) {
            try {
                SourceUtils.runUserActionTask((FileObject)fo, (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        GroovyParserResult result = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
                        ModuleNode moduleNode = result.getRootElement().getModuleNode();
                        Set<ASTNode> usages = new UsagesVisitor(moduleNode, GroovyWhereUsed.this.fqn).findUsages();
                        BaseDocument doc = Utils.getDocument((ParserResult)result, fo);
                        for (ASTNode node : usages) {
                            refactoringElements.add((AbstractRefactoring)GroovyWhereUsed.this.whereUsedQuery, (RefactoringElementImplementation)new WhereUsedElement(new GroovyRefactoringElement(result, moduleNode, node, fo), doc));
                        }
                    }
                });
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public Problem preCheck() {
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        HashSet<FileObject> set = new HashSet<FileObject>();
        set.addAll(Utils.getGroovyFilesInProject(this.fileObject));
        return set;
    }

    private static class UsagesVisitor
    extends ClassCodeVisitorSupport {
        private final ModuleNode moduleNode;
        private final String fqn;
        private final Set<ASTNode> usages = new HashSet<ASTNode>();

        public UsagesVisitor(ModuleNode moduleNode, String fqn) {
            this.moduleNode = moduleNode;
            this.fqn = fqn;
        }

        public Set<ASTNode> findUsages() {
            for (Object object : this.moduleNode.getClasses()) {
                this.visitClass((ClassNode)object);
            }
            return this.usages;
        }

        protected SourceUnit getSourceUnit() {
            return this.moduleNode.getContext();
        }

        public void visitDeclarationExpression(DeclarationExpression expression) {
            VariableExpression variable = expression.getVariableExpression();
            ClassNode classNode = variable.getType();
            if (this.fqn.equals(classNode.getName())) {
                this.usages.add((ASTNode)variable);
            }
            super.visitDeclarationExpression(expression);
        }

        public void visitField(FieldNode node) {
            if (this.fqn.equals(node.getType().getName())) {
                this.usages.add((ASTNode)node);
            }
            super.visitField(node);
        }
    }

    private static class WhereUsedElement
    extends SimpleRefactoringElementImplementation {
        private final GroovyRefactoringElement element;
        private final BaseDocument doc;

        public WhereUsedElement(GroovyRefactoringElement element, BaseDocument doc) {
            this.element = element;
            this.doc = doc;
        }

        public String getText() {
            return this.element.getName() + " -";
        }

        public String getDisplayText() {
            Line line = Utils.getLine(this.element.getFileObject(), this.element.getNode().getLineNumber() - 1);
            return line.getText().trim();
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.element.getFileObject();
        }

        public PositionBounds getPosition() {
            OffsetRange range = AstUtilities.getRange((ASTNode)this.element.getNode(), (BaseDocument)this.doc);
            if (range == OffsetRange.NONE) {
                return null;
            }
            CloneableEditorSupport ces = Utils.findCloneableEditorSupport(this.element.getFileObject());
            PositionRef ref1 = ces.createPositionRef(range.getStart(), Position.Bias.Forward);
            PositionRef ref2 = ces.createPositionRef(range.getEnd(), Position.Bias.Forward);
            return new PositionBounds(ref1, ref2);
        }
    }
}

