/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerFlavorImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainManagerImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

public final class CompilerSetFactory {
    private CompilerSetFactory() {
    }

    public static CompilerSet getCompilerSet(ExecutionEnvironment env, CompilerFlavor flavor, String name) {
        CompilerSetManagerImpl csm = (CompilerSetManagerImpl)CompilerSetManagerImpl.get(env);
        CompilerSet cs = CompilerSetFactory.getCompilerSet(csm, flavor, name);
        if (cs == null) {
            cs = new CompilerSetImpl(flavor, "", name);
            ((CompilerSetImpl)cs).setAutoGenerated(false);
            csm.add(cs);
        }
        return cs;
    }

    public static List<CompilerFlavor> getCompilerSetFlavor(String directory, int platform) {
        ArrayList<CompilerFlavor> list = new ArrayList<CompilerFlavor>();
        for (ToolchainManager.ToolchainDescriptor d : ToolchainManagerImpl.getImpl().getToolchains(platform)) {
            CompilerFlavor f;
            if (d.isAbstract() || !ToolUtils.isMyFolder(directory, d, platform, false) || (f = CompilerFlavorImpl.toFlavor(d.getName(), platform)) == null) continue;
            list.add(f);
        }
        return list;
    }

    public static CompilerSet getCustomCompilerSet(String directory, CompilerFlavor flavor, String name) {
        CompilerSetImpl cs = new CompilerSetImpl(flavor, directory, name);
        cs.setAutoGenerated(false);
        return cs;
    }

    private static CompilerSet getCompilerSet(CompilerSetManager csm, CompilerFlavor flavor, String name) {
        CompilerSet flavorCandidate = null;
        CompilerSet nameCandidate = null;
        for (CompilerSet cs : csm.getCompilerSets()) {
            if (cs.getCompilerFlavor().equals(flavor)) {
                if (cs.getName().equals(name)) {
                    return cs;
                }
                if (flavorCandidate != null) continue;
                flavorCandidate = cs;
                continue;
            }
            if (!cs.getName().equals(name) || nameCandidate != null) continue;
            nameCandidate = cs;
        }
        if (flavorCandidate != null) {
            return flavorCandidate;
        }
        if (nameCandidate != null) {
            return nameCandidate;
        }
        return null;
    }
}

