/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.CreateStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.DeleteStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.DropStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.InsertStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.analyzer.SelectStatement;
import org.netbeans.modules.db.sql.analyzer.SelectStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.TablesClause;
import org.netbeans.modules.db.sql.analyzer.UpdateStatementAnalyzer;
import org.netbeans.modules.db.sql.editor.StringUtils;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

public class SQLStatementAnalyzer {
    protected TokenSequence<SQLTokenId> seq;
    protected SQLIdentifiers.Quoter quoter;
    protected int startOffset;
    protected SQLStatement.Context context = SQLStatement.Context.START;
    protected final SortedMap<Integer, SQLStatement.Context> offset2Context = new TreeMap<Integer, SQLStatement.Context>();
    protected final List<SelectStatement> subqueries = new ArrayList<SelectStatement>();

    protected SQLStatementAnalyzer(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        this.seq = seq;
        this.quoter = quoter;
    }

    public static SQLStatement analyze(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        SQLStatementKind kind = SQLStatementAnalyzer.analyzeKind(seq);
        if (kind == null) {
            return null;
        }
        switch (kind) {
            case SELECT: {
                return SelectStatementAnalyzer.analyze(seq, quoter);
            }
            case INSERT: {
                return InsertStatementAnalyzer.analyze(seq, quoter);
            }
            case DROP: {
                return DropStatementAnalyzer.analyze(seq, quoter);
            }
            case UPDATE: {
                return UpdateStatementAnalyzer.analyze(seq, quoter);
            }
            case DELETE: {
                return DeleteStatementAnalyzer.analyze(seq, quoter);
            }
            case CREATE: {
                return CreateStatementAnalyzer.analyze(seq, quoter);
            }
        }
        return null;
    }

    public static SQLStatementKind analyzeKind(TokenSequence<SQLTokenId> seq) {
        seq.moveStart();
        if (!SQLStatementAnalyzer.nextToken(seq, new SQLTokenId[0])) {
            return null;
        }
        if (SQLStatementAnalyzer.isKeyword("DECLARE", seq) || SQLStatementAnalyzer.isKeyword("SET", seq)) {
            while (SQLStatementAnalyzer.isKeyword("DECLARE", seq) || SQLStatementAnalyzer.isKeyword("SET", seq)) {
                if (SQLStatementAnalyzer.nextToken(seq, SQLTokenId.COMMA, SQLTokenId.OPERATOR, SQLTokenId.IDENTIFIER, SQLTokenId.STRING, SQLTokenId.LPAREN, SQLTokenId.RPAREN)) continue;
                return null;
            }
            if (SQLStatementAnalyzer.isKeyword("SELECT", seq)) {
                return SQLStatementKind.SELECT;
            }
        } else {
            if (SQLStatementAnalyzer.isKeyword("SELECT", seq)) {
                return SQLStatementKind.SELECT;
            }
            if (SQLStatementAnalyzer.isKeyword("INSERT", seq)) {
                return SQLStatementKind.INSERT;
            }
            if (SQLStatementAnalyzer.isKeyword("DROP", seq)) {
                return SQLStatementKind.DROP;
            }
            if (SQLStatementAnalyzer.isKeyword("UPDATE", seq)) {
                return SQLStatementKind.UPDATE;
            }
            if (SQLStatementAnalyzer.isKeyword("DELETE", seq)) {
                return SQLStatementKind.DELETE;
            }
            if (SQLStatementAnalyzer.isKeyword("CREATE", seq)) {
                return SQLStatementKind.CREATE;
            }
        }
        return null;
    }

    public static boolean isKeyword(CharSequence keyword, TokenSequence<SQLTokenId> seq) {
        return seq.token().id() == SQLTokenId.KEYWORD && StringUtils.textEqualsIgnoreCase(seq.token().text(), keyword);
    }

    private static boolean nextToken(TokenSequence<SQLTokenId> seq, SQLTokenId ... toSkip) {
        boolean move;
        block3: while (move = seq.moveNext()) {
            SQLTokenId id = (SQLTokenId)seq.token().id();
            if (toSkip != null && Arrays.asList(toSkip).contains((Object)SQLTokenId.LPAREN) && SQLTokenId.LPAREN.equals((Object)id)) {
                while ((move = seq.moveNext()) && !SQLTokenId.RPAREN.equals((Object)(id = (SQLTokenId)seq.token().id()))) {
                }
                continue;
            }
            if (toSkip != null && Arrays.asList(toSkip).contains((Object)id)) continue;
            switch (id) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block3;
                }
            }
            break;
        }
        return move;
    }

    protected boolean nextToken() {
        boolean move = SQLStatementAnalyzer.nextToken(this.seq, new SQLTokenId[0]);
        if (move && (!(this instanceof SelectStatementAnalyzer) || this.context.isAfter(SQLStatement.Context.SELECT)) && this.context != SQLStatement.Context.BEGIN) {
            return this.parseSubquery();
        }
        return move;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseSubquery() {
        boolean move = true;
        if (SQLStatementAnalyzer.isKeyword("SELECT", this.seq)) {
            int subStartOffset = this.seq.offset();
            int parLevel = 1;
            block4: while (move = this.seq.moveNext()) {
                switch ((SQLTokenId)this.seq.token().id()) {
                    case LPAREN: {
                        ++parLevel;
                        break;
                    }
                    case RPAREN: {
                        if (--parLevel == 0) break block4;
                    }
                }
            }
            if (parLevel == 0 || !move && parLevel > 0) {
                TokenSequence subSeq;
                SelectStatement subquery;
                int subEndOffset = this.seq.offset();
                if (!move && parLevel > 0) {
                    subEndOffset += this.seq.token().length();
                }
                if ((subquery = SelectStatementAnalyzer.analyze((TokenSequence<SQLTokenId>)(subSeq = this.seq.subSequence(subStartOffset, subEndOffset)), this.quoter)) != null) {
                    this.subqueries.add(subquery);
                }
            }
        }
        return move;
    }

    protected QualIdent parseIdentifier() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getUnquotedIdentifier());
        boolean afterDot = false;
        block4: while (this.nextToken()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case DOT: {
                    afterDot = true;
                    continue block4;
                }
                case IDENTIFIER: {
                    if (afterDot) {
                        afterDot = false;
                        parts.add(this.getUnquotedIdentifier());
                        continue block4;
                    }
                    this.seq.movePrevious();
                    break block4;
                }
                default: {
                    this.seq.movePrevious();
                    break block4;
                }
            }
        }
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            if (((String)i.next()).length() != 0) continue;
            i.remove();
        }
        if (!parts.isEmpty()) {
            return new QualIdent(parts);
        }
        return null;
    }

    protected String getUnquotedIdentifier() {
        return this.quoter.unquote(((Object)this.seq.token().text()).toString());
    }

    protected void moveToContext(SQLStatement.Context context) {
        this.context = context;
        this.offset2Context.put(this.seq.offset() + this.seq.token().length(), context);
    }

    TableIdent parseTableIdent() {
        QualIdent tableName = this.parseIdentifier();
        if (tableName == null) {
            return null;
        }
        String alias = this.parseAlias();
        return new TableIdent(tableName, alias);
    }

    private String parseAlias() {
        String alias = null;
        block4: while (this.nextToken()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case IDENTIFIER: {
                    alias = this.getUnquotedIdentifier();
                    continue block4;
                }
                case KEYWORD: {
                    if (SQLStatementAnalyzer.isKeyword("AS", this.seq)) continue block4;
                    this.seq.movePrevious();
                    break block4;
                }
                default: {
                    this.seq.movePrevious();
                    break block4;
                }
            }
        }
        if (alias != null && alias.length() == 0) {
            alias = null;
        }
        return alias;
    }

    protected TablesClause createTablesClause(List<TableIdent> tables) {
        HashSet<QualIdent> unaliasedTableNames = new HashSet<QualIdent>();
        HashMap<String, QualIdent> aliasedTableNames = new HashMap<String, QualIdent>();
        for (TableIdent table : tables) {
            if (table.getAlias() == null) {
                unaliasedTableNames.add(table.getTableName());
                continue;
            }
            if (aliasedTableNames.containsKey(table.getAlias())) continue;
            aliasedTableNames.put(table.getAlias(), table.getTableName());
        }
        return new TablesClause(Collections.unmodifiableSet(unaliasedTableNames), Collections.unmodifiableMap(aliasedTableNames));
    }

    public static class TableIdent
    implements Comparable<TableIdent> {
        private final QualIdent tableName;
        private final String alias;

        public TableIdent(QualIdent tableName, String alias) {
            this.tableName = tableName;
            this.alias = alias;
        }

        public QualIdent getTableName() {
            return this.tableName;
        }

        public String getAlias() {
            return this.alias;
        }

        @Override
        public int compareTo(TableIdent that) {
            if (this.getAlias() != null && that.getAlias() != null) {
                return this.getAlias().compareToIgnoreCase(that.getAlias());
            }
            return this.getTableName().compareTo(that.getTableName());
        }

        public String toString() {
            String aliasText = this.getAlias() == null ? "" : this.getAlias() + " alias to ";
            return aliasText + this.getTableName().toString();
        }
    }
}

