/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.awt.Dialog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerImpl;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.BreakpointModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisProgressPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Disassembly;
import org.netbeans.modules.cnd.debugger.gdb2.GdbFrame;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GdbDisassembly
extends Disassembly {
    private String functionName = "";
    private String intFileName = "";
    private String resolvedFileName = "";
    private String address = "";
    private boolean withSource = true;
    private final Map<Integer, String> regNames = new HashMap<Integer, String>();
    private final Map<Integer, String> regValues = new HashMap<Integer, String>();
    private final Set<Integer> regModified = new HashSet<Integer>();
    private static final String ADDRESS_HEADER = "address";
    private static final String FUNCTION_HEADER = "func-name";
    private static final String OFFSET_HEADER = "offset";
    private static final String INSTR_HEADER = "inst";
    private static final String LINE_HEADER = "line";
    private static final String FILE_HEADER = "file";
    private static final String NUMBER_HEADER = "number";
    private static final String VALUE_HEADER = "value";
    public static final String REGISTER_NAMES_HEADER = "^done,register-names=";
    public static final String REGISTER_VALUES_HEADER = "^done,register-values=";
    public static final String REGISTER_MODIFIED_HEADER = "^done,changed-registers=";
    public static final String RESPONSE_HEADER = "^done,asm_insns=";
    private static final String COMBINED_HEADER = "src_and_asm_line={";
    private static final String COMMENT_PREFIX = "!";
    private boolean cancelled = false;

    public GdbDisassembly(NativeDebuggerImpl debugger, BreakpointModel breakpointModel) {
        super(debugger, breakpointModel);
    }

    protected void cancel() {
        this.cancelled = true;
    }

    public void update(String msg) {
        assert (msg.contains(RESPONSE_HEADER)) : "Invalid asm response message";
        this.cancelled = false;
        Dialog dialog = null;
        Frame frame = this.getDebugger().getCurrentFrame();
        if (frame == null) {
            return;
        }
        String currentAddr = this.getDebugger().getCurrentFrame().getCurrentPC();
        this.attachUpdateListener();
        Disassembly.DisText text = new Disassembly.DisText((Disassembly)this);
        int pos = RESPONSE_HEADER.length();
        boolean nameSet = false;
        long start = System.currentTimeMillis();
        boolean dialogOpened = false;
        DisProgressPanel panel = null;
        while (!this.cancelled) {
            int combinedPos = msg.indexOf(COMBINED_HEADER, pos);
            int addressPos = msg.indexOf(ADDRESS_HEADER, pos);
            try {
                if (panel != null) {
                    panel.setProgress(pos * 100 / msg.length());
                }
                if (!this.cancelled && !dialogOpened && System.currentTimeMillis() - start > 2000L) {
                    dialogOpened = true;
                    panel = new DisProgressPanel();
                    final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(GdbDisassembly.class, (String)"DIS_PROGRESS_TITLE"));
                    dd.setOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
                    final Dialog dlg = dialog = DialogDisplayer.getDefault().createDialog(dd);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dlg.setVisible(true);
                            if (dd.getValue() == DialogDescriptor.CANCEL_OPTION) {
                                GdbDisassembly.this.cancel();
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            if (addressPos == -1) break;
            if (combinedPos != -1 && combinedPos < addressPos) {
                int lineIdx = Integer.valueOf(GdbDisassembly.readValue(LINE_HEADER, msg, combinedPos));
                if (lineIdx > 0) {
                    String fileStr = GdbDisassembly.readValue(FILE_HEADER, msg, combinedPos);
                    if (this.resolvedFileName != null && CndPathUtilitities.getBaseName((String)this.resolvedFileName).equals(fileStr)) {
                        FileObject src_fo = EditorBridge.findFileObject((String)this.resolvedFileName, (NativeDebugger)this.getDebugger());
                        if (src_fo != null && src_fo.isValid()) {
                            try {
                                String lineText = ((LineCookie)DataObject.find((FileObject)src_fo).getCookie(LineCookie.class)).getLineSet().getCurrent(lineIdx - 1).getText();
                                if (lineText != null && lineText.length() > 0) {
                                    text.addLine((Disassembly.DisLine)new Disassembly.CommentLine(COMMENT_PREFIX + lineText));
                                }
                            }
                            catch (Exception ex) {}
                        } else {
                            text.addLine((Disassembly.DisLine)new Disassembly.CommentLine(COMMENT_PREFIX + NbBundle.getMessage(GdbDisassembly.class, (String)"MSG_Source_Not_Found", (Object)fileStr, (Object)lineIdx)));
                        }
                    }
                }
                pos = combinedPos + 1;
                continue;
            }
            GdbDisLine line = new GdbDisLine(msg, addressPos);
            if (!nameSet && currentAddr.equals(line.getAddress())) {
                this.functionName = line.getFunction();
                GdbDisassembly.getDataObject().getNodeDelegate().setDisplayName(this.getHeader());
                text.addLine((Disassembly.DisLine)new Disassembly.CommentLine(this.functionName + "()\n"));
                nameSet = true;
            }
            if (!nameSet || this.functionName.equals(line.getFunction())) {
                text.addLine((Disassembly.DisLine)line);
            }
            pos = addressPos + 1;
        }
        if (!this.cancelled) {
            text.save();
        }
        if (dialog != null) {
            final Dialog dlg = dialog;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dlg.setVisible(false);
                    dlg.dispose();
                }
            });
        }
        if (this.cancelled) {
            GdbDisassembly.close();
            return;
        }
        if (text.isEmpty() && this.withSource) {
            this.reloadDis(false, true);
            return;
        }
        this.setText(text);
    }

    public void updateRegNames(String msg) {
        int end;
        assert (msg.startsWith(REGISTER_NAMES_HEADER)) : "Invalid asm response message";
        this.regNames.clear();
        int idx = 0;
        int pos = msg.indexOf("\"", REGISTER_NAMES_HEADER.length());
        while (pos != -1 && (end = msg.indexOf("\"", pos + 1)) != -1) {
            String value = msg.substring(pos + 1, end);
            this.regNames.put(idx++, value);
            pos = msg.indexOf("\"", end + 1);
        }
    }

    public void updateRegModified(String msg) {
        int end;
        assert (msg.startsWith(REGISTER_MODIFIED_HEADER)) : "Invalid asm response message";
        this.regModified.clear();
        int pos = msg.indexOf("\"", REGISTER_MODIFIED_HEADER.length());
        while (pos != -1 && (end = msg.indexOf("\"", pos + 1)) != -1) {
            String index = msg.substring(pos + 1, end);
            try {
                this.regModified.add(Integer.valueOf(index));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            pos = msg.indexOf("\"", end + 1);
        }
    }

    public void updateRegValues(String msg) {
        assert (msg.startsWith(REGISTER_VALUES_HEADER)) : "Invalid asm response message";
        this.regValues.clear();
        int pos = msg.indexOf(NUMBER_HEADER);
        while (pos != -1) {
            String idx = GdbDisassembly.readValue(NUMBER_HEADER, msg, pos);
            String value = GdbDisassembly.readValue(VALUE_HEADER, msg, pos);
            try {
                this.regValues.put(Integer.valueOf(idx), value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            pos = msg.indexOf(NUMBER_HEADER, pos + 1);
        }
    }

    public void stateUpdated() {
        this.reloadDis(true, false);
    }

    protected void reload() {
        this.reloadDis(true, false);
    }

    private void reloadDis(boolean withSource, boolean force) {
        this.withSource = withSource;
        if (!opened) {
            return;
        }
        Frame frame = this.getDebugger().getCurrentFrame();
        if (frame == null) {
            return;
        }
        String curAddress = frame.getCurrentPC();
        if (curAddress == null || curAddress.length() == 0) {
            return;
        }
        if (!curAddress.equals(this.address)) {
            this.requestMode = withSource ? Disassembly.RequestMode.FILE_SRC : Disassembly.RequestMode.FILE_NO_SRC;
        } else if (this.requestMode == Disassembly.RequestMode.NONE) {
            return;
        }
        if (force || this.getAddressLine(curAddress) == -1) {
            this.intFileName = ((GdbFrame)frame).getEngineFullName();
            this.resolvedFileName = frame.getFullPath();
            if (!(this.intFileName != null && this.intFileName.length() != 0 || this.requestMode != Disassembly.RequestMode.FILE_SRC && this.requestMode != Disassembly.RequestMode.FILE_NO_SRC)) {
                this.requestMode = withSource ? Disassembly.RequestMode.ADDRESS_SRC : Disassembly.RequestMode.ADDRESS_NO_SRC;
            }
            switch (this.requestMode) {
                case FILE_SRC: {
                    this.getDebugger().disController().requestDis(withSource);
                    this.requestMode = Disassembly.RequestMode.FILE_NO_SRC;
                    break;
                }
                case FILE_NO_SRC: {
                    this.getDebugger().disController().requestDis(withSource);
                    this.requestMode = Disassembly.RequestMode.ADDRESS_SRC;
                    break;
                }
                case ADDRESS_SRC: {
                    this.getDebugger().disController().requestDis("$pc", 100, withSource);
                    this.requestMode = Disassembly.RequestMode.ADDRESS_NO_SRC;
                    break;
                }
                case ADDRESS_NO_SRC: {
                    this.getDebugger().disController().requestDis("$pc", 100, withSource);
                    this.requestMode = Disassembly.RequestMode.NONE;
                }
            }
        }
        this.address = curAddress;
    }

    private static String readValue(String name, String msg, int pos) {
        int end;
        String paramHeader = name + "=\"";
        int start = msg.indexOf(paramHeader, pos);
        if (start != -1 && (end = msg.indexOf("\"", (start += paramHeader.length()) + 1)) != -1) {
            return msg.substring(start, end);
        }
        return "";
    }

    private String getHeader() {
        String res = NbBundle.getMessage(GdbDisassembly.class, (String)"LBL_Disassembly_Window");
        if (this.functionName.length() > 0) {
            res = res + "(" + this.functionName + ")";
        }
        return res;
    }

    public void reset() {
        this.address = "";
        super.reset();
    }

    private static class GdbDisLine
    implements Disassembly.DisLine {
        private final String address;
        private final String function;
        private final int offset;
        private final String instruction;
        private int idx;

        public GdbDisLine(String msg, int pos) {
            this.address = GdbDisassembly.readValue(GdbDisassembly.ADDRESS_HEADER, msg, pos);
            this.function = GdbDisassembly.readValue(GdbDisassembly.FUNCTION_HEADER, msg, pos);
            int tmpOffset = 0;
            try {
                tmpOffset = Integer.valueOf(GdbDisassembly.readValue(GdbDisassembly.OFFSET_HEADER, msg, pos));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.offset = tmpOffset;
            this.instruction = GdbDisassembly.readValue(GdbDisassembly.INSTR_HEADER, msg, pos);
        }

        public String getAddress() {
            return this.address;
        }

        public String getFunction() {
            return this.function;
        }

        public int getIdx() {
            return this.idx;
        }

        public void setIdx(int idx) {
            this.idx = idx;
        }

        public String toString() {
            if (!this.function.isEmpty()) {
                return this.function + "+" + this.offset + ": " + this.instruction + '\n';
            }
            return this.address + ": " + this.instruction + '\n';
        }
    }
}

