/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2.mi;

import org.netbeans.modules.cnd.debugger.gdb2.GdbLogger;
import org.netbeans.modules.cnd.debugger.gdb2.mi.Log;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommand;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommandInjector;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommandManager;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIParser;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;

public abstract class MIProxy {
    private boolean connected;
    private final MICommandManager cmdManager;
    private final String prompt;
    private final MIParser parser;
    private final GdbLogger gdbLogger;

    protected MIProxy(MICommandInjector injector, String prompt, String encoding) {
        assert (prompt != null);
        this.gdbLogger = new GdbLogger();
        this.cmdManager = new MICommandManager(injector, this.gdbLogger);
        this.prompt = prompt;
        this.parser = new MIParser(encoding);
    }

    public void send(MICommand cmd) {
        if (Log.MI.echo) {
            System.out.printf("MI-> %s\n", cmd);
        }
        this.cmdManager.send(cmd);
    }

    public boolean processLine(String line) {
        this.gdbLogger.logMessage(line);
        if (line.trim().equals(this.prompt)) {
            if (!this.connected) {
                this.connected = true;
                this.connectionEstablished();
            }
            this.prompt();
            return true;
        }
        if (Log.MI.echo) {
            System.out.printf("MI<- %s\n", line);
        }
        if (Log.MI.mimicmac && line.contains("stack-args")) {
            line = line.replace('[', '{');
            line = line.replace(']', '}');
        }
        this.parser.setup(line);
        MIRecord record = this.parser.parse();
        switch (record.type()) {
            case '^': {
                this.result(record);
                return true;
            }
            case '+': {
                this.statusAsyncOutput(record);
                return true;
            }
            case '*': {
                this.execAsyncOutput(record);
                return true;
            }
            case '=': {
                this.notifyAsyncOutput(record);
                return true;
            }
            case '~': {
                this.consoleStreamOutput(record);
                return true;
            }
            case '@': {
                this.targetStreamOutput(record);
                return true;
            }
            case '&': {
                this.logStreamOutput(record);
                return true;
            }
            case '?': {
                return true;
            }
        }
        this.errorBadLine(line);
        return true;
    }

    protected void dispatch(MIRecord record) {
        this.cmdManager.dispatch(record);
    }

    protected void result(MIRecord record) {
        this.dispatch(record);
    }

    protected void statusAsyncOutput(MIRecord record) {
        this.dispatch(record);
    }

    protected void execAsyncOutput(MIRecord record) {
        this.dispatch(record);
    }

    protected void notifyAsyncOutput(MIRecord record) {
        this.dispatch(record);
    }

    protected void consoleStreamOutput(MIRecord record) {
        this.cmdManager.logConsole(record.stream());
    }

    protected void targetStreamOutput(MIRecord record) {
    }

    protected void logStreamOutput(MIRecord record) {
        this.cmdManager.logStream(record.stream());
    }

    protected void prompt() {
    }

    protected void connectionEstablished() {
    }

    protected void errorBadLine(String data) {
        this.cmdManager.echo(String.format("unrecognized line: %s\r", data));
    }

    protected void clearMessages() {
        this.cmdManager.clearMessages();
    }
}

