/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.spi.java.project.runner.JavaRunnerImplementation;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;
import org.openide.windows.InputOutput;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class ProjectRunnerImpl
implements JavaRunnerImplementation {
    private static final Logger LOG = Logger.getLogger(ProjectRunnerImpl.class.getName());

    public boolean isSupported(String command, Map<String, ?> properties) {
        return ProjectRunnerImpl.locateScript(command) != null;
    }

    public ExecutorTask execute(String command, Map<String, ?> properties) throws IOException {
        if ("clean".equals(command)) {
            return ProjectRunnerImpl.clean(properties);
        }
        String[] projectName = new String[1];
        Map<String, String> antProps = ProjectRunnerImpl.computeProperties(command, properties, projectName);
        FileObject script = ProjectRunnerImpl.buildScript(command);
        FakeAntProjectCookie apc = new FakeAntProjectCookie(AntScriptUtils.antProjectCookieFor((FileObject)script), projectName[0]);
        AntTargetExecutor.Env execenv = new AntTargetExecutor.Env();
        Properties props = execenv.getProperties();
        props.putAll(antProps);
        execenv.setProperties(props);
        return AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)execenv).execute((AntProjectCookie)apc, null);
    }

    static Map<String, String> computeProperties(String command, Map<String, ?> properties, String[] projectNameOut) {
        String encoding;
        JavaPlatform p;
        properties = new HashMap(properties);
        FileObject toRun = ProjectRunnerImpl.getValue(properties, "execute.file", FileObject.class);
        String workDir = ProjectRunnerImpl.getValue(properties, "work.dir", String.class);
        String className = ProjectRunnerImpl.getValue(properties, "classname", String.class);
        ClassPath boot = ProjectRunnerImpl.getValue(properties, "boot.classpath", ClassPath.class);
        ClassPath exec = ProjectRunnerImpl.getValue(properties, "execute.classpath", ClassPath.class);
        String javaTool = ProjectRunnerImpl.getValue(properties, "platform.java", String.class);
        String projectName = ProjectRunnerImpl.getValue(properties, "project.name", String.class);
        Iterable<String> runJVMArgs = ProjectRunnerImpl.getMultiValue(properties, "run.jvmargs", String.class);
        Iterable<String> args = ProjectRunnerImpl.getMultiValue(properties, "application.args", String.class);
        String tmpDir = ProjectRunnerImpl.getValue(properties, "tmp.dir", String.class);
        if (workDir == null) {
            Parameters.notNull((CharSequence)"toRun", (Object)toRun);
            Project project = FileOwnerQuery.getOwner((FileObject)toRun);
            if (project != null) {
                FileObject projDirectory = project.getProjectDirectory();
                assert (projDirectory != null);
                File file = FileUtil.toFile((FileObject)projDirectory);
                if (file != null) {
                    workDir = file.getAbsolutePath();
                }
            }
        }
        if (className == null) {
            Parameters.notNull((CharSequence)"toRun", (Object)toRun);
            ClassPath source = ClassPath.getClassPath((FileObject)toRun, (String)"classpath/source");
            if (source == null) {
                throw new IllegalArgumentException("The source classpath for specified toRun parameter has is null. Report against caller module. [toRun = " + toRun + "]");
            }
            className = source.getResourceName(toRun, '.', false);
        }
        if (exec == null) {
            Parameters.notNull((CharSequence)"toRun", (Object)toRun);
            exec = ClassPath.getClassPath((FileObject)toRun, (String)"classpath/execute");
        }
        if ((p = ProjectRunnerImpl.getValue(properties, "platform", JavaPlatform.class)) == null) {
            p = JavaPlatform.getDefault();
        }
        if (javaTool == null) {
            FileObject javaToolFO = p.findTool("java");
            if (javaToolFO == null) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot find java");
                Exceptions.attachLocalizedMessage((Throwable)iae, (String)NbBundle.getMessage(ProjectRunnerImpl.class, (String)"ERR_CannotFindJava"));
                throw iae;
            }
            javaTool = FileUtil.toFile((FileObject)javaToolFO).getAbsolutePath();
        }
        if (boot == null) {
            boot = p.getBootstrapLibraries();
        }
        if (projectName == null) {
            Project project = ProjectRunnerImpl.getValue(properties, "project", Project.class);
            if (project != null) {
                projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
            if (projectName == null && toRun != null && (project = FileOwnerQuery.getOwner((FileObject)toRun)) != null) {
                projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
            if (projectName == null) {
                projectName = "";
            }
        }
        LOG.log(Level.FINE, "execute classpath={0}", exec);
        String cp = exec.toString(ClassPath.PathConversionMode.FAIL);
        TreeMap<String, String> antProps = new TreeMap<String, String>();
        ProjectRunnerImpl.setProperty(antProps, "platform.bootcp", boot.toString(ClassPath.PathConversionMode.FAIL));
        ProjectRunnerImpl.setProperty(antProps, "classpath", cp);
        ProjectRunnerImpl.setProperty(antProps, "classname", className);
        ProjectRunnerImpl.setProperty(antProps, "platform.java", javaTool);
        ProjectRunnerImpl.setProperty(antProps, "work.dir", workDir);
        ProjectRunnerImpl.setProperty(antProps, "run.jvmargs", ProjectRunnerImpl.toOneLine(runJVMArgs));
        if (tmpDir != null) {
            ProjectRunnerImpl.setProperty(antProps, "tmp.dir", tmpDir);
        }
        if (toRun == null) {
            ProjectRunnerImpl.setProperty(antProps, "application.args", ProjectRunnerImpl.toOneLine(args));
        }
        FileObject source = toRun;
        Charset charset = ProjectRunnerImpl.getValue(properties, "runtime.encoding", Charset.class);
        String string = encoding = charset != null && Charset.isSupported(charset.name()) ? charset.name() : null;
        if (encoding == null) {
            Charset sourceEncoding;
            if (source == null) {
                String binaryResource = className.replace('.', '/') + ".class";
                block2: for (FileObject root : exec.getRoots()) {
                    if (root.getFileObject(binaryResource) == null) continue;
                    try {
                        String sourceResource = className.replace('.', '/') + ".java";
                        for (FileObject srcRoot : SourceForBinaryQuery.findSourceRoots((URL)root.getURL()).getRoots()) {
                            FileObject srcFile = srcRoot.getFileObject(sourceResource);
                            if (srcFile == null) continue;
                            source = srcFile;
                            break block2;
                        }
                    }
                    catch (FileStateInvalidException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            if (source != null && Charset.isSupported((sourceEncoding = FileEncodingQuery.getEncoding((FileObject)source)).name())) {
                encoding = sourceEncoding.name();
            }
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ProjectRunnerImpl.setProperty(antProps, "encoding", encoding);
        for (Map.Entry<String, ?> e : properties.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            antProps.put(e.getKey(), (String)e.getValue());
        }
        projectNameOut[0] = projectName;
        return antProps;
    }

    private static ExecutorTask clean(Map<String, ?> properties) {
        properties = new HashMap(properties);
        String projectName = ProjectRunnerImpl.getValue(properties, "project.name", String.class);
        FileObject toRun = ProjectRunnerImpl.getValue(properties, "execute.file", FileObject.class);
        ClassPath exec = ProjectRunnerImpl.getValue(properties, "execute.classpath", ClassPath.class);
        if (exec == null) {
            Parameters.notNull((CharSequence)"toRun", (Object)toRun);
            exec = ClassPath.getClassPath((FileObject)toRun, (String)"classpath/execute");
        }
        if (projectName == null) {
            Project project = ProjectRunnerImpl.getValue(properties, "project", Project.class);
            if (project != null) {
                projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
            if (projectName == null && toRun != null && (project = FileOwnerQuery.getOwner((FileObject)toRun)) != null) {
                projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
            if (projectName == null) {
                projectName = "";
            }
        }
        LOG.log(Level.FINE, "execute classpath={0}", exec);
        final ClassPath execFin = exec;
        return ExecutionEngine.getDefault().execute(projectName, new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectRunnerImpl.doClean(execFin);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, InputOutput.NULL);
    }

    private static void setProperty(Map<String, String> antProps, String property, String value) {
        if (value != null) {
            antProps.put(property, value);
        }
    }

    private static <T> T getValue(Map<String, ?> properties, String name, Class<T> type) {
        Object v = properties.remove(name);
        if (v instanceof FileObject && type == String.class) {
            FileObject f = (FileObject)v;
            File file = FileUtil.toFile((FileObject)f);
            if (file == null) {
                return null;
            }
            v = file.getAbsolutePath();
        }
        if (v instanceof File && type == String.class) {
            v = ((File)v).getAbsolutePath();
        }
        return type.cast(v);
    }

    private static <T> Iterable<T> getMultiValue(Map<String, ?> properties, String name, Class<T> type) {
        Iterable v = (Iterable)properties.remove(name);
        LinkedList<T> result = new LinkedList<T>();
        if (v == null) {
            return Collections.emptyList();
        }
        for (Object o : v) {
            result.add(type.cast(o));
        }
        return result;
    }

    private static String toOneLine(Iterable<String> it) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : it) {
            if (!first) {
                result.append(' ');
            }
            first = false;
            result.append(s);
        }
        return result.toString();
    }

    private static URL locateScript(String actionName) {
        return ProjectRunnerImpl.class.getResource("/org/netbeans/modules/java/source/ant/resources/" + actionName + "-snippet.xml");
    }

    private static FileObject buildScript(String actionName) throws IOException {
        URL script = ProjectRunnerImpl.locateScript(actionName);
        if (script == null) {
            return null;
        }
        URL thisClassSource = ProjectRunnerImpl.class.getProtectionDomain().getCodeSource().getLocation();
        File jarFile = FileUtil.archiveOrDirForURL((URL)thisClassSource);
        File scriptFile = Places.getCacheSubfile((String)("executor-snippets/" + actionName + ".xml"));
        if (!scriptFile.canRead() || jarFile != null && jarFile.lastModified() > scriptFile.lastModified()) {
            try {
                scriptFile.delete();
                URLConnection connection = script.openConnection();
                FileObject target = FileUtil.createData((File)scriptFile);
                ProjectRunnerImpl.copyFile(connection, target);
                return target;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
        return FileUtil.toFileObject((File)scriptFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(URLConnection source, FileObject target) throws IOException {
        InputStream ins = null;
        OutputStream out = null;
        try {
            ins = source.getInputStream();
            out = target.getOutputStream();
            FileUtil.copy((InputStream)ins, (OutputStream)out);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static void doClean(ClassPath exec) throws IOException {
        for (ClassPath.Entry entry : exec.entries()) {
            SourceForBinaryQuery.Result2 r = SourceForBinaryQuery.findSourceRoots2((URL)entry.getURL());
            if (!r.preferSources() || r.getRoots().length <= 0) continue;
            for (FileObject source : r.getRoots()) {
                File sourceFile = FileUtil.toFile((FileObject)source);
                if (sourceFile == null) {
                    LOG.log(Level.WARNING, "Source URL: {0} cannot be translated to file, skipped", source.getURL().toExternalForm());
                    continue;
                }
                BuildArtifactMapperImpl.clean((URL)sourceFile.toURI().toURL());
            }
        }
    }

    private static final class FakeElement
    implements Element {
        private final Element delegate;
        private final String projectName;

        public FakeElement(Element delegate, String projectName) {
            Parameters.notNull((CharSequence)"delegate", (Object)delegate);
            this.delegate = delegate;
            this.projectName = projectName;
        }

        @Override
        public Object setUserData(String key, Object data, UserDataHandler handler) {
            return this.delegate.setUserData(key, data, handler);
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            this.delegate.setTextContent(textContent);
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            this.delegate.setPrefix(prefix);
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.delegate.setNodeValue(nodeValue);
        }

        @Override
        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            return this.delegate.replaceChild(newChild, oldChild);
        }

        @Override
        public Node removeChild(Node oldChild) throws DOMException {
            return this.delegate.removeChild(oldChild);
        }

        @Override
        public void normalize() {
            this.delegate.normalize();
        }

        @Override
        public String lookupPrefix(String namespaceURI) {
            return this.delegate.lookupPrefix(namespaceURI);
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return this.delegate.lookupNamespaceURI(prefix);
        }

        @Override
        public boolean isSupported(String feature, String version) {
            return this.delegate.isSupported(feature, version);
        }

        @Override
        public boolean isSameNode(Node other) {
            return this.delegate.isSameNode(other);
        }

        @Override
        public boolean isEqualNode(Node arg) {
            return this.delegate.isEqualNode(arg);
        }

        @Override
        public boolean isDefaultNamespace(String namespaceURI) {
            return this.delegate.isDefaultNamespace(namespaceURI);
        }

        @Override
        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            return this.delegate.insertBefore(newChild, refChild);
        }

        @Override
        public boolean hasChildNodes() {
            return this.delegate.hasChildNodes();
        }

        @Override
        public boolean hasAttributes() {
            return this.delegate.hasAttributes();
        }

        @Override
        public Object getUserData(String key) {
            return this.delegate.getUserData(key);
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.delegate.getTextContent();
        }

        @Override
        public Node getPreviousSibling() {
            return this.delegate.getPreviousSibling();
        }

        @Override
        public String getPrefix() {
            return this.delegate.getPrefix();
        }

        @Override
        public Node getParentNode() {
            return this.delegate.getParentNode();
        }

        @Override
        public Document getOwnerDocument() {
            return this.delegate.getOwnerDocument();
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.delegate.getNodeValue();
        }

        @Override
        public short getNodeType() {
            return this.delegate.getNodeType();
        }

        @Override
        public String getNodeName() {
            return this.delegate.getNodeName();
        }

        @Override
        public Node getNextSibling() {
            return this.delegate.getNextSibling();
        }

        @Override
        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI();
        }

        @Override
        public String getLocalName() {
            return this.delegate.getLocalName();
        }

        @Override
        public Node getLastChild() {
            return this.delegate.getLastChild();
        }

        @Override
        public Node getFirstChild() {
            return this.delegate.getFirstChild();
        }

        @Override
        public Object getFeature(String feature, String version) {
            return this.delegate.getFeature(feature, version);
        }

        @Override
        public NodeList getChildNodes() {
            return this.delegate.getChildNodes();
        }

        @Override
        public String getBaseURI() {
            return this.delegate.getBaseURI();
        }

        @Override
        public NamedNodeMap getAttributes() {
            return this.delegate.getAttributes();
        }

        @Override
        public short compareDocumentPosition(Node other) throws DOMException {
            return this.delegate.compareDocumentPosition(other);
        }

        @Override
        public Node cloneNode(boolean deep) {
            return this.delegate.cloneNode(deep);
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            return this.delegate.appendChild(newChild);
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            this.delegate.setIdAttributeNode(idAttr, isId);
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            this.delegate.setIdAttributeNS(namespaceURI, localName, isId);
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            this.delegate.setIdAttribute(name, isId);
        }

        @Override
        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            return this.delegate.setAttributeNodeNS(newAttr);
        }

        @Override
        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            return this.delegate.setAttributeNode(newAttr);
        }

        @Override
        public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
            this.delegate.setAttributeNS(namespaceURI, qualifiedName, value);
        }

        @Override
        public void setAttribute(String name, String value) throws DOMException {
            this.delegate.setAttribute(name, value);
        }

        @Override
        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            return this.delegate.removeAttributeNode(oldAttr);
        }

        @Override
        public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
            this.delegate.removeAttributeNS(namespaceURI, localName);
        }

        @Override
        public void removeAttribute(String name) throws DOMException {
            this.delegate.removeAttribute(name);
        }

        @Override
        public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.delegate.hasAttributeNS(namespaceURI, localName);
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.delegate.hasAttribute(name);
        }

        @Override
        public String getTagName() {
            return this.delegate.getTagName();
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return this.delegate.getSchemaTypeInfo();
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
            return this.delegate.getElementsByTagNameNS(namespaceURI, localName);
        }

        @Override
        public NodeList getElementsByTagName(String name) {
            return this.delegate.getElementsByTagName(name);
        }

        @Override
        public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
            return this.delegate.getAttributeNodeNS(namespaceURI, localName);
        }

        @Override
        public Attr getAttributeNode(String name) {
            return this.delegate.getAttributeNode(name);
        }

        @Override
        public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.delegate.getAttributeNS(namespaceURI, localName);
        }

        @Override
        public String getAttribute(String name) {
            if ("name".equals(name)) {
                String pattern = this.delegate.getAttribute(name);
                return MessageFormat.format(pattern, this.projectName);
            }
            return this.delegate.getAttribute(name);
        }
    }

    private static final class FakeAntProjectCookie
    implements AntProjectCookie,
    ChangeListener {
        private final AntProjectCookie apc;
        private final String projectName;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public FakeAntProjectCookie(AntProjectCookie apc, String projectName) {
            this.apc = apc;
            this.apc.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.apc));
            this.projectName = projectName;
        }

        public File getFile() {
            return this.apc.getFile();
        }

        public FileObject getFileObject() {
            return this.apc.getFileObject();
        }

        public Document getDocument() {
            return this.apc.getDocument();
        }

        public Element getProjectElement() {
            Element element = this.apc.getProjectElement();
            if (element == null) {
                File fo = this.apc.getFile();
                throw new NullPointerException(String.format("Cannot parse: %s exists: %b readable: %b", fo == null ? null : fo.getAbsolutePath(), fo == null ? false : fo.exists(), fo == null ? false : fo.canRead()));
            }
            return new FakeElement(element, this.projectName);
        }

        public Throwable getParseException() {
            return this.apc.getParseException();
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }
    }
}

