/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.options;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.Collection;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.versioning.util.OptionsPanelColorProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AnnotationColorProvider
extends OptionsPanelColorProvider {
    private static String name;
    private static AnnotationColorProvider INSTANCE;
    public final OptionsPanelColorProvider.AnnotationFormat UP_TO_DATE_FILE = this.createAnnotationFormat("uptodate", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_UpToDate"), null, false);
    public final OptionsPanelColorProvider.AnnotationFormat NEW_LOCALLY_FILE = this.createAnnotationFormat("newLocally", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_NewLocally"), new Color(0, 128, 0), false);
    public final OptionsPanelColorProvider.AnnotationFormat NEW_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("newLocallyTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_NewLocally"), new Color(0, 128, 0), true);
    public final OptionsPanelColorProvider.AnnotationFormat NEW_IN_REPOSITORY_FILE = this.createAnnotationFormat("newinRepository", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_NewInRepository"), new Color(0, 0, 0), false);
    public final OptionsPanelColorProvider.AnnotationFormat NEW_IN_REPOSITORY_FILE_TOOLTIP = this.createAnnotationFormat("newinRepositoryTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_NewInRepository"), new Color(0, 0, 0), true);
    public final OptionsPanelColorProvider.AnnotationFormat ADDED_LOCALLY_FILE = this.createAnnotationFormat("addedLocally", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_AddedLocally"), new Color(0, 128, 0), false);
    public final OptionsPanelColorProvider.AnnotationFormat ADDED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("addedLocallyTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_AddedLocally"), new Color(0, 128, 0), true);
    public final OptionsPanelColorProvider.AnnotationFormat COPIED_LOCALLY_FILE = this.createAnnotationFormat("copiedLocally", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_AddedLocallyCopied"), new Color(0, 128, 0), false);
    public final OptionsPanelColorProvider.AnnotationFormat COPIED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("copiedLocallyTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_AddedLocallyCopied"), new Color(0, 128, 0), true);
    public final OptionsPanelColorProvider.AnnotationFormat MODIFIED_LOCALLY_FILE = this.createAnnotationFormat("modifiedLocally", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_ModifiedLocally"), new Color(0, 0, 255), false);
    public final OptionsPanelColorProvider.AnnotationFormat MODIFIED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("modifiedLocallyTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_ModifiedLocally"), new Color(0, 0, 255), true);
    public final OptionsPanelColorProvider.AnnotationFormat MODIFIED_IN_REPOSITORY_FILE = this.createAnnotationFormat("modifiedinRepository", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_ModifiedInRepository"), new Color(0, 0, 0), false);
    public final OptionsPanelColorProvider.AnnotationFormat MODIFIED_IN_REPOSITORY_FILE_TOOLTIP = this.createAnnotationFormat("modifiedinRepositoryTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_ModifiedInRepository"), new Color(0, 0, 0), true);
    public final OptionsPanelColorProvider.AnnotationFormat MERGEABLE_FILE = this.createAnnotationFormat("mergeable", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Merge"), new Color(0, 0, 255), false);
    public final OptionsPanelColorProvider.AnnotationFormat MERGEABLE_FILE_TOOLTIP = this.createAnnotationFormat("mergeableTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Merge"), new Color(0, 0, 255), true);
    public final OptionsPanelColorProvider.AnnotationFormat REMOVED_LOCALLY_FILE = this.createAnnotationFormat("removedLocally", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_RemovedLocally"), new Color(153, 153, 153), false);
    public final OptionsPanelColorProvider.AnnotationFormat REMOVED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("removedLocallyTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_RemovedLocally"), new Color(153, 153, 153), true);
    public final OptionsPanelColorProvider.AnnotationFormat REMOVED_IN_REPOSITORY_FILE = this.createAnnotationFormat("removedinRepository", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_RemovedInRepository"), new Color(0, 0, 0), false);
    public final OptionsPanelColorProvider.AnnotationFormat REMOVED_IN_REPOSITORY_FILE_TOOLTIP = this.createAnnotationFormat("removedinRepositoryTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_RemovedInRepository"), new Color(0, 0, 0), true);
    public final OptionsPanelColorProvider.AnnotationFormat DELETED_LOCALLY_FILE = this.createAnnotationFormat("deletedLocally", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_DeletedLocally"), new Color(153, 153, 153), false);
    public final OptionsPanelColorProvider.AnnotationFormat DELETED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("deletedLocallyTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_DeletedLocally"), new Color(153, 153, 153), true);
    public final OptionsPanelColorProvider.AnnotationFormat EXCLUDED_FILE = this.createAnnotationFormat("excluded", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Excluded"), new Color(153, 153, 153), false);
    public final OptionsPanelColorProvider.AnnotationFormat EXCLUDED_FILE_TOOLTIP = this.createAnnotationFormat("excludedTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Excluded"), new Color(153, 153, 153), true);
    public final OptionsPanelColorProvider.AnnotationFormat CONFLICT_FILE = this.createAnnotationFormat("conflict", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Conflict"), new Color(255, 0, 0), false);
    public final OptionsPanelColorProvider.AnnotationFormat CONFLICT_FILE_TOOLTIP = this.createAnnotationFormat("conflictTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_Conflict"), new Color(255, 0, 0), true);
    public final OptionsPanelColorProvider.AnnotationFormat TREECONFLICT_FILE = this.createAnnotationFormat("treeconflict", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_TreeConflict"), new Color(255, 0, 0), false);
    public final OptionsPanelColorProvider.AnnotationFormat TREECONFLICT_FILE_TOOLTIP = this.createAnnotationFormat("treeconflictTT", NbBundle.getMessage(Annotator.class, (String)"CTL_FileInfoStatus_TreeConflict"), new Color(255, 0, 0), true);

    public static synchronized AnnotationColorProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = (AnnotationColorProvider)((Object)Lookup.getDefault().lookup(AnnotationColorProvider.class));
            if (INSTANCE == null) {
                INSTANCE = new AnnotationColorProvider();
            }
            INSTANCE.initColors();
        }
        return INSTANCE;
    }

    public String getName() {
        if (name == null) {
            name = SubversionVCS.getDisplayName();
        }
        return name;
    }

    protected Color getSavedColor(String key, Color defaultColor) {
        return SvnModuleConfig.getDefault().getColor(key, defaultColor);
    }

    protected MessageFormat createFormat(Color color, boolean isTooltip) {
        StringBuilder annotationFormatString = new StringBuilder("{0}");
        if (color != null) {
            annotationFormatString = new StringBuilder("<font color=\"#").append(AnnotationColorProvider.to2Hex((int)color.getRed())).append(AnnotationColorProvider.to2Hex((int)color.getGreen())).append(AnnotationColorProvider.to2Hex((int)color.getBlue())).append("\"").append(">{0}</font>");
        }
        if (!isTooltip) {
            annotationFormatString.append("{1}");
        }
        return new MessageFormat(annotationFormatString.toString());
    }

    protected void saveColors(Collection<OptionsPanelColorProvider.AnnotationFormat> colors) {
        for (OptionsPanelColorProvider.AnnotationFormat af : colors) {
            if (af == null) continue;
            SvnModuleConfig.getDefault().setColor(AnnotationColorProvider.getColorKey((String)af.getKey()), af.getActualColor());
        }
        Subversion.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Subversion.getInstance().refreshAllAnnotations();
            }
        });
    }

    private void initColors() {
        this.putColor(this.ADDED_LOCALLY_FILE);
        this.putColor(this.CONFLICT_FILE);
        this.putColor(this.COPIED_LOCALLY_FILE);
        this.putColor(this.DELETED_LOCALLY_FILE);
        this.putColor(this.EXCLUDED_FILE);
        this.putColor(this.MODIFIED_LOCALLY_FILE);
        this.putColor(this.NEW_LOCALLY_FILE);
        this.putColor(this.REMOVED_LOCALLY_FILE);
        this.putColor(this.MODIFIED_IN_REPOSITORY_FILE);
        this.putColor(this.NEW_IN_REPOSITORY_FILE);
        this.putColor(this.REMOVED_IN_REPOSITORY_FILE);
        this.putColor(this.MERGEABLE_FILE);
    }
}

