/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.repository;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.ui.repository.ConnectionType;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.ui.repository.RepositoryDialogPanel;
import org.netbeans.modules.subversion.ui.repository.RepositoryPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Repository
implements ActionListener,
DocumentListener,
ItemListener {
    public static final int FLAG_URL_EDITABLE = 2;
    public static final int FLAG_URL_ENABLED = 4;
    public static final int FLAG_ACCEPT_REVISION = 8;
    public static final int FLAG_SHOW_REMOVE = 16;
    public static final int FLAG_SHOW_HINTS = 32;
    public static final int FLAG_SHOW_PROXY = 64;
    private static final String FILE_PANEL = "file-panel";
    private static final String HTTP_PANEL = "http-panel";
    private static final String SSH_PANEL = "ssh-panel";
    private static final String INVALID_URL_PANEL = "invalid-url-panel";
    private static final String INVALID_SVN_URL = "invalid svn url:";
    private String currentConnPanelType;
    private ConnectionType currentPanel;
    private RepositoryPanel repositoryPanel;
    private boolean valid = true;
    private List<PropertyChangeListener> listeners;
    private RepositoryConnection editedRC;
    public static final String PROP_VALID = "valid";
    private String message;
    private int modeMask;
    private Dimension maxNeededSize;
    private ConnectionType http;
    private ConnectionType file;
    private ConnectionType svnSSH;
    private ConnectionType invalidUrlPanel;

    public Repository(String titleLabel) {
        this(0, titleLabel);
    }

    public Repository(int modeMask, String titleLabel) {
        this.modeMask = modeMask;
        this.initPanel();
        this.repositoryPanel.titleLabel.setText(titleLabel);
        this.repositoryPanel.urlComboBox.setEditable(this.isSet(2));
        this.repositoryPanel.urlComboBox.setEnabled(this.isSet(4));
        this.repositoryPanel.tipLabel.setVisible(this.isSet(32));
        this.repositoryPanel.removeButton.setVisible(this.isSet(16));
        this.repositoryPanel.removeButton.addActionListener(this);
        this.maxNeededSize = this.repositoryPanel.getPreferredSize();
        this.refreshUrlHistory();
    }

    public void selectUrl(SVNUrl url, boolean force) {
        DefaultComboBoxModel dcbm = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
        int idx = dcbm.getIndexOf(url.toString());
        if (idx > -1) {
            dcbm.setSelectedItem(url.toString());
        } else if (force) {
            RepositoryConnection rc = new RepositoryConnection(url.toString());
            dcbm.addElement(rc);
            dcbm.setSelectedItem(rc);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.repositoryPanel.removeButton) {
            this.onRemoveClick();
        }
    }

    private void onRemoveClick() {
        RepositoryConnection rc = this.getSelectedRCIntern();
        if (rc != null) {
            this.remove(rc);
        }
    }

    private void initPanel() {
        this.repositoryPanel = new RepositoryPanel();
        this.http = new ConnectionType.Http(this);
        this.repositoryPanel.connPanel.add((Component)this.http.getPanel(), HTTP_PANEL);
        this.file = new ConnectionType.FileUrl(this);
        this.repositoryPanel.connPanel.add((Component)this.file.getPanel(), FILE_PANEL);
        this.svnSSH = SvnClientFactory.isSvnKit() ? new ConnectionType.SvnSSHSvnKit(this) : new ConnectionType.SvnSSHCli(this);
        this.repositoryPanel.connPanel.add((Component)this.svnSSH.getPanel(), SSH_PANEL);
        this.invalidUrlPanel = new ConnectionType.InvalidUrl(this);
        this.repositoryPanel.connPanel.add((Component)this.invalidUrlPanel.getPanel(), INVALID_URL_PANEL);
        this.svnSSH.showHints(this.isSet(32));
        ((JTextComponent)this.repositoryPanel.urlComboBox.getEditor().getEditorComponent()).setText("file://");
        this.updateVisibility(FILE_PANEL);
        this.repositoryPanel.urlComboBox.addActionListener(this);
        this.getUrlComboEditor().getDocument().addDocumentListener(this);
        this.repositoryPanel.urlComboBox.addItemListener(this);
        this.repositoryPanel.urlComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (isSelected && comp instanceof JComponent) {
                    String tt = null;
                    if (comp.getPreferredSize().getWidth() > ((Repository)Repository.this).repositoryPanel.urlComboBox.getSize().getWidth() && value instanceof RepositoryConnection) {
                        tt = ((RepositoryConnection)value).getUrl();
                    }
                    ((JComponent)comp).setToolTipText(tt);
                }
                return comp;
            }
        });
        this.onSelectedRepositoryChange();
    }

    public final void refreshUrlHistory() {
        this.repositoryPanel.urlComboBox.setEnabled(false);
        Runnable notInAWT = new Runnable(){

            @Override
            public void run() {
                List<RepositoryConnection> recentUrls = SvnModuleConfig.getDefault().getRecentUrls();
                LinkedHashSet<RepositoryConnection> recentRoots = new LinkedHashSet<RepositoryConnection>();
                recentRoots.addAll(recentUrls);
                if (((Repository)Repository.this).repositoryPanel.urlComboBox.isEditable()) {
                    recentRoots.add(new RepositoryConnection("file:///"));
                    recentRoots.add(new RepositoryConnection("http://"));
                    recentRoots.add(new RepositoryConnection("https://"));
                    recentRoots.add(new RepositoryConnection("svn://"));
                    recentRoots.add(new RepositoryConnection("svn+ssh://"));
                }
                RepositoryModel rootsModel = new RepositoryModel(new Vector(recentRoots));
                ((Repository)Repository.this).repositoryPanel.urlComboBox.setModel(rootsModel);
                if (recentRoots.size() > 0) {
                    ((Repository)Repository.this).repositoryPanel.urlComboBox.setSelectedIndex(0);
                    Repository.this.onSelectedRepositoryChange();
                    Repository.this.currentPanel.refresh(Repository.this.getSelectedRCIntern());
                }
                ((Repository)Repository.this).repositoryPanel.urlComboBox.setEnabled(Repository.this.isSet(4));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (((Repository)Repository.this).repositoryPanel.urlComboBox.isEditable()) {
                            JTextComponent textEditor = Repository.this.getUrlComboEditor();
                            textEditor.selectAll();
                        }
                        Repository.this.updateVisibility();
                    }
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            Subversion.getInstance().getRequestProcessor().post(notInAWT);
        } else {
            notInAWT.run();
        }
    }

    public void storeRecentUrls() {
        final List<RepositoryConnection> recentUrls = this.getRecentUrls();
        Subversion.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                SvnModuleConfig.getDefault().setRecentUrls(recentUrls);
            }
        });
    }

    public boolean isChanged() {
        List<RepositoryConnection> storedConnections;
        List<RepositoryConnection> connections = this.getRecentUrls();
        return !SvnUtils.equals(connections, storedConnections = SvnModuleConfig.getDefault().getRecentUrls());
    }

    private List<RepositoryConnection> getRecentUrls() {
        ComboBoxModel model = this.repositoryPanel.urlComboBox.getModel();
        ArrayList<RepositoryConnection> ret = new ArrayList<RepositoryConnection>(model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            ret.add((RepositoryConnection)model.getElementAt(i));
        }
        return ret;
    }

    private JTextComponent getUrlComboEditor() {
        Component editor = this.repositoryPanel.urlComboBox.getEditor().getEditorComponent();
        JTextComponent textEditor = (JTextComponent)editor;
        return textEditor;
    }

    public void setEditable(boolean editable) {
        this.repositoryPanel.urlComboBox.setEditable(editable);
        this.currentPanel.setEditable(editable);
    }

    public void storeConfigValues() {
        this.currentPanel.storeConfigValues();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    private void textChanged(final DocumentEvent e) {
        Runnable awt = new Runnable(){

            @Override
            public void run() {
                if (e.getDocument() == ((JTextComponent)((Repository)Repository.this).repositoryPanel.urlComboBox.getEditor().getEditorComponent()).getDocument()) {
                    Repository.this.onSelectedRepositoryChange();
                }
                Repository.this.validateSvnUrl();
            }
        };
        SwingUtilities.invokeLater(awt);
    }

    void validateSvnUrl() {
        boolean valid = true;
        RepositoryConnection rc = null;
        try {
            rc = this.getSelectedRCIntern();
            new SVNUrl(rc.getSvnUrl().toString());
            if (!this.isSet(8) && !rc.getSvnRevision().equals((Object)SVNRevision.HEAD)) {
                this.message = NbBundle.getMessage(Repository.class, (String)"MSG_Repository_OnlyHEADRevision");
                valid = false;
            } else {
                rc.getSvnRevision();
            }
        }
        catch (Exception ex) {
            this.message = this.translateMessage(ex.getLocalizedMessage());
            valid = false;
        }
        if (valid) {
            boolean bl = valid = rc != null && !rc.getUrl().equals("");
            if (!this.currentPanel.isValid(rc)) {
                valid = false;
            }
        }
        this.setValid(valid, this.message);
        this.currentPanel.setEnabled(valid);
        this.repositoryPanel.removeButton.setEnabled(rc != null && rc.getUrl().length() > 0);
    }

    private void onSelectedRepositoryChange() {
        this.setValid(true, "");
        String urlString = "";
        try {
            urlString = this.getUrlString();
        }
        catch (InterruptedException ex) {
            return;
        }
        if (urlString != null) {
            RepositoryConnection editedrc = this.getEditedRC();
            editedrc.setUrl(urlString);
            DefaultComboBoxModel dcbm = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
            int idx = dcbm.getIndexOf(editedrc);
            if (idx > -1) {
                this.currentPanel.refresh((RepositoryConnection)dcbm.getElementAt(idx));
            }
            this.currentPanel.onSelectedRepositoryChange(urlString);
            this.currentPanel.fillRC(editedrc);
        }
        this.message = "";
        this.updateVisibility();
    }

    private RepositoryConnection getEditedRC() {
        if (this.editedRC == null) {
            this.editedRC = new RepositoryConnection("");
        }
        return this.editedRC;
    }

    private void updateVisibility() {
        String selectedUrlString;
        try {
            selectedUrlString = this.getUrlString();
        }
        catch (InterruptedException ex) {
            return;
        }
        this.repositoryPanel.urlComboBox.setToolTipText(selectedUrlString);
        String connPanelType = selectedUrlString.startsWith("http:") ? HTTP_PANEL : (selectedUrlString.startsWith("https:") ? HTTP_PANEL : (selectedUrlString.startsWith("svn:") ? HTTP_PANEL : (selectedUrlString.startsWith("svn+") ? SSH_PANEL : (selectedUrlString.startsWith("file:") ? FILE_PANEL : INVALID_URL_PANEL))));
        this.updateVisibility(connPanelType, selectedUrlString);
    }

    private void updateVisibility(String connPanelTypeId) {
        String selectedUrlString;
        try {
            selectedUrlString = this.getUrlString();
        }
        catch (InterruptedException ex) {
            return;
        }
        this.updateVisibility(connPanelTypeId, selectedUrlString);
    }

    private void updateVisibility(String connPanelTypeId, String selectedUrlString) {
        if (connPanelTypeId == HTTP_PANEL) {
            this.currentPanel = this.http;
        } else if (connPanelTypeId == SSH_PANEL) {
            this.currentPanel = this.svnSSH;
        } else if (connPanelTypeId == FILE_PANEL) {
            this.currentPanel = this.file;
        } else if (connPanelTypeId == INVALID_URL_PANEL) {
            this.currentPanel = this.invalidUrlPanel;
        } else assert (false);
        if (connPanelTypeId != this.currentConnPanelType) {
            ((CardLayout)this.repositoryPanel.connPanel.getLayout()).show(this.repositoryPanel.connPanel, connPanelTypeId);
            this.currentConnPanelType = connPanelTypeId;
        }
        this.repositoryPanel.tipLabel.setText(this.currentPanel.getTip(selectedUrlString));
        this.currentPanel.updateVisibility(selectedUrlString);
    }

    private String getUrlString() throws InterruptedException {
        if (!this.repositoryPanel.urlComboBox.isEditable()) {
            Object selection = this.repositoryPanel.urlComboBox.getSelectedItem();
            if (selection != null) {
                return selection.toString().trim();
            }
            return "";
        }
        final String[] svnUrl = new String[1];
        try {
            Runnable awt = new Runnable(){

                @Override
                public void run() {
                    svnUrl[0] = ((Repository)Repository.this).repositoryPanel.urlComboBox.getEditor().getItem().toString().trim();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                awt.run();
            } else {
                SwingUtilities.invokeAndWait(awt);
            }
            return svnUrl[0].trim();
        }
        catch (InvocationTargetException e) {
            Subversion.LOG.log(Level.SEVERE, null, e);
            return null;
        }
    }

    public RepositoryConnection getSelectedRC() {
        RepositoryConnection rc = this.getSelectedRCIntern();
        return rc;
    }

    RepositoryConnection getSelectedRCIntern() {
        String urlString;
        try {
            urlString = this.getUrlString();
        }
        catch (InterruptedException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
            return null;
        }
        DefaultComboBoxModel dcbm = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
        int idx = dcbm.getIndexOf(urlString);
        if (idx > -1) {
            return (RepositoryConnection)dcbm.getElementAt(idx);
        }
        return this.getEditedRC();
    }

    public RepositoryPanel getPanel() {
        return this.repositoryPanel;
    }

    public boolean isValid() {
        return this.valid;
    }

    void setValid(boolean valid, String message) {
        boolean oldValue = this.valid;
        this.message = message;
        this.valid = valid;
        this.fireValidPropertyChanged(oldValue, valid);
    }

    private void fireValidPropertyChanged(boolean oldValue, boolean valid) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(new PropertyChangeEvent(this, PROP_VALID, oldValue, valid));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public String getMessage() {
        return this.message;
    }

    public void remove(RepositoryConnection toRemove) {
        RepositoryModel model = (RepositoryModel)this.repositoryPanel.urlComboBox.getModel();
        model.removeElement(toRemove);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            RepositoryConnection rc = (RepositoryConnection)evt.getItem();
            this.currentPanel.refresh(rc);
            this.updateVisibility();
            this.editedRC = new RepositoryConnection(rc);
        } else if (evt.getStateChange() == 2) {
            this.updateVisibility();
        }
    }

    public boolean show(String title, HelpCtx helpCtx, boolean setMaxNeddedSize) {
        RepositoryDialogPanel rdp = new RepositoryDialogPanel();
        rdp.panel.setLayout(new BorderLayout());
        RepositoryPanel p = this.getPanel();
        if (setMaxNeddedSize) {
            p.setPreferredSize(this.maxNeededSize);
        }
        rdp.panel.add((Component)p, "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)rdp, title);
        this.showDialog(dialogDescriptor, helpCtx);
        return dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Object show(String title, HelpCtx helpCtx, Object[] options, Object initialValue) {
        RepositoryDialogPanel rdp = new RepositoryDialogPanel();
        rdp.panel.setLayout(new BorderLayout());
        rdp.panel.add((Component)this.getPanel(), "North");
        DialogDescriptor dialogDescriptor = null;
        dialogDescriptor = options != null ? new DialogDescriptor((Object)rdp, title, true, options, initialValue, 0, helpCtx, null) : new DialogDescriptor((Object)rdp, title);
        this.showDialog(dialogDescriptor, helpCtx);
        return dialogDescriptor.getValue();
    }

    public Object show(String title, HelpCtx helpCtx, Object[] options) {
        return this.show(title, helpCtx, options, null);
    }

    private void showDialog(DialogDescriptor dialogDescriptor, HelpCtx helpCtx) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(helpCtx);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Repository.class, (String)"ACSD_RepositoryPanel"));
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Repository.class, (String)"ACSN_RepositoryPanel"));
        dialog.setVisible(true);
    }

    final boolean isSet(int flag) {
        return (this.modeMask & flag) != 0;
    }

    private String translateMessage(String message) {
        int pos = (message = message.toLowerCase()).indexOf(INVALID_SVN_URL);
        if (pos != -1) {
            message = message.substring(INVALID_SVN_URL.length());
            message = NbBundle.getMessage(Repository.class, (String)"MSG_Repository_InvalidSvnUrl", (Object)message);
        }
        return message;
    }

    public class RepositoryModel
    extends DefaultComboBoxModel {
        public RepositoryModel(Vector v) {
            super(v);
        }

        @Override
        public void setSelectedItem(Object obj) {
            if (obj instanceof String) {
                int idx = this.getIndexOf(obj);
                obj = idx > -1 ? this.getElementAt(idx) : this.createNewRepositoryConnection((String)obj);
            }
            super.setSelectedItem(obj);
        }

        @Override
        public int getIndexOf(Object obj) {
            if (obj instanceof String) {
                obj = this.createNewRepositoryConnection((String)obj);
            }
            return super.getIndexOf(obj);
        }

        @Override
        public void addElement(Object obj) {
            if (obj instanceof String) {
                obj = this.createNewRepositoryConnection((String)obj);
            }
            super.addElement(obj);
        }

        @Override
        public void insertElementAt(Object obj, int index) {
            if (obj instanceof String) {
                String str = (String)obj;
                RepositoryConnection rc = null;
                try {
                    rc = (RepositoryConnection)this.getElementAt(index);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                if (rc != null) {
                    rc.setUrl(str);
                    obj = rc;
                }
                obj = this.createNewRepositoryConnection(str);
            }
            super.insertElementAt(obj, index);
        }

        @Override
        public void removeElement(Object obj) {
            int index = this.getIndexOf(obj);
            if (index != -1) {
                this.removeElementAt(index);
            }
        }

        private RepositoryConnection createNewRepositoryConnection(String url) {
            if (Repository.this.editedRC != null) {
                Repository.this.editedRC.setUrl(url);
                return new RepositoryConnection(Repository.this.editedRC);
            }
            return new RepositoryConnection(url);
        }
    }
}

