/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.api.ui.ConnectionNotifier;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RefreshManager;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectFactory;
import org.netbeans.modules.remote.spi.FileSystemCacheProvider;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbObjectInputStream;
import org.openide.windows.WindowManager;

@SuppressWarnings(value={"Se"})
public final class RemoteFileSystem
extends FileSystem
implements ConnectionListener {
    private static final SystemAction[] NO_SYSTEM_ACTIONS = new SystemAction[0];
    public static final String ATTRIBUTES_FILE_NAME = ".rfs_attr";
    public static final String CACHE_FILE_NAME = ".rfs_cache";
    public static final String RESERVED_PREFIX = ".rfs_";
    public static final String RESERVED_PREFIX_ESCAPED = "._rfs_";
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    private final ExecutionEnvironment execEnv;
    private final String filePrefix;
    private final RootFileObject root;
    private final RemoteFileSupport remoteFileSupport;
    private final RefreshManager refreshManager;
    private final File cache;
    private final RemoteFileObjectFactory factory;
    private static int fileCopyCount;
    private static int dirSyncCount;
    private static final Object mainLock;
    private static final Map<File, WeakReference<ReadWriteLock>> locks;
    private AtomicBoolean readOnlyConnectNotification = new AtomicBoolean(false);
    private final List<FileSystemProvider.FileSystemProblemListener> problemListeners = new ArrayList<FileSystemProvider.FileSystemProblemListener>();

    RemoteFileSystem(ExecutionEnvironment execEnv) throws IOException {
        RemoteLogger.assertTrue(execEnv.isRemote());
        this.execEnv = execEnv;
        this.remoteFileSupport = new RemoteFileSupport();
        this.factory = new RemoteFileObjectFactory(this);
        this.refreshManager = new RefreshManager(execEnv, this.factory);
        this.filePrefix = FileSystemCacheProvider.getCacheRoot((ExecutionEnvironment)execEnv);
        if (this.filePrefix == null) {
            throw new IllegalStateException("Can not find cache root for remote file system at " + execEnv);
        }
        this.cache = new File(this.filePrefix);
        if (!this.cache.exists() && !this.cache.mkdirs()) {
            throw new IOException(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_CreateDir", (Object)this.cache.getAbsolutePath()));
        }
        this.root = new RootFileObject(this, execEnv, this.cache);
        final WindowFocusListener windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (e.getOppositeWindow() == null && ConnectionManager.getInstance().isConnectedTo(RemoteFileSystem.this.execEnv)) {
                    RemoteFileSystem.this.refreshManager.scheduleRefreshOnFocusGained(RemoteFileSystem.this.factory.getCachedFileObjects());
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().addWindowFocusListener(windowFocusListener);
            }
        });
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)this);
    }

    public void connected(ExecutionEnvironment env) {
        this.readOnlyConnectNotification.compareAndSet(true, false);
        if (this.execEnv.equals(env)) {
            Collection<RemoteFileObjectBase> cachedFileObjects = this.factory.getCachedFileObjects();
            this.refreshManager.scheduleRefreshOnConnect(cachedFileObjects);
            for (RemoteFileObjectBase fo : cachedFileObjects) {
                fo.connectionChanged();
            }
        }
    }

    public void disconnected(ExecutionEnvironment env) {
        this.readOnlyConnectNotification.compareAndSet(true, false);
        if (this.execEnv.equals(env)) {
            for (RemoteFileObjectBase fo : this.factory.getCachedFileObjects()) {
                fo.connectionChanged();
            }
        }
    }

    ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    public RemoteFileObjectFactory getFactory() {
        return this.factory;
    }

    public RefreshManager getRefreshManager() {
        return this.refreshManager;
    }

    public String normalizeAbsolutePath(String absPath) {
        return PathUtilities.normalizeUnixPath((String)absPath);
    }

    File getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadWriteLock getLock(File file) {
        Object object = mainLock;
        synchronized (object) {
            ReadWriteLock result;
            WeakReference<ReadWriteLock> ref = locks.get(file);
            ReadWriteLock readWriteLock = result = ref == null ? null : (ReadWriteLock)ref.get();
            if (result == null) {
                result = new ReentrantReadWriteLock();
                locks.put(file, new WeakReference<ReadWriteLock>(result));
            }
            return result;
        }
    }

    final void resetStatistic() {
        dirSyncCount = 0;
        fileCopyCount = 0;
    }

    final int getDirSyncCount() {
        return dirSyncCount;
    }

    final int getFileCopyCount() {
        return fileCopyCount;
    }

    final void incrementDirSyncCount() {
        ++dirSyncCount;
    }

    final void incrementFileCopyCount() {
        ++fileCopyCount;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RFS_DISPLAY_NAME", (Object)this.execEnv.getDisplayName());
    }

    public boolean isReadOnly() {
        return true;
    }

    public RemoteDirectory getRoot() {
        return this.root;
    }

    public RemoteFileObjectBase findResource(String name) {
        if (name.isEmpty() || name.equals("/")) {
            return this.getRoot();
        }
        return this.getRoot().getFileObject(name);
    }

    RemoteFileObjectBase findResource(String name, Set<String> antiloop) {
        if (name.isEmpty() || name.equals("/")) {
            return this.getRoot();
        }
        return this.getRoot().getFileObject(name, antiloop);
    }

    public SystemAction[] getActions() {
        return NO_SYSTEM_ACTIONS;
    }

    public void addPendingFile(RemoteFileObjectBase fo) {
        this.remoteFileSupport.addPendingFile(fo);
        this.fireProblemListeners(fo.getPath());
    }

    public String toString() {
        return this.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttribute(RemoteFileObjectBase file, String attrName, Object value) {
        RemoteFileObjectBase parent = file.getParent();
        if (parent != null) {
            File attr = this.getAttrFile(parent);
            Properties table = this.readProperties(attr);
            String translatedAttributeName = this.translateAttributeName(file, attrName);
            String encodedValue = this.encodeValue(value);
            if (encodedValue == null) {
                table.remove(translatedAttributeName);
            } else {
                table.setProperty(translatedAttributeName, encodedValue);
            }
            FileOutputStream fileOtputStream = null;
            try {
                fileOtputStream = new FileOutputStream(attr);
                table.store(fileOtputStream, "Set attribute " + attrName);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (fileOtputStream != null) {
                    try {
                        fileOtputStream.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    private File getAttrFile(RemoteFileObjectBase parent) {
        File attr = new File(parent.getCache(), ATTRIBUTES_FILE_NAME);
        return attr;
    }

    Object getAttribute(RemoteFileObjectBase file, String attrName) {
        RemoteFileObjectBase parent = file.getParent();
        if (parent != null) {
            if (attrName.equals(READONLY_ATTRIBUTES)) {
                return Boolean.FALSE;
            }
            if (attrName.equals("isRemoteAndSlow")) {
                return Boolean.TRUE;
            }
            if (attrName.equals("FileSystem.rootPath")) {
                return this.getRoot().getPath();
            }
            if (attrName.equals("java.io.File")) {
                return null;
            }
            if (attrName.equals("ExistsParentNoPublicAPI")) {
                return true;
            }
            if (attrName.startsWith("ProvidedExtensions")) {
                return null;
            }
            File attr = this.getAttrFile(parent);
            Properties table = this.readProperties(attr);
            return this.decodeValue(table.getProperty(this.translateAttributeName(file, attrName)));
        }
        return null;
    }

    Enumeration<String> getAttributes(RemoteFileObjectBase file) {
        RemoteFileObjectBase parent = file.getParent();
        if (parent != null) {
            File attr = this.getAttrFile(parent);
            Properties table = this.readProperties(attr);
            ArrayList<String> res = new ArrayList<String>();
            Enumeration<Object> keys = table.keys();
            String prefix = file.getNameExt() + "[";
            while (keys.hasMoreElements()) {
                String aKey = keys.nextElement().toString();
                if (!aKey.startsWith(prefix)) continue;
                aKey = aKey.substring(prefix.length(), aKey.length() - 1);
                res.add(aKey);
            }
            res.add("isRemoteAndSlow");
            if (RemoteFileObjectBase.RETURN_JAVA_IO_FILE) {
                res.add("java.io.File");
            }
            return Collections.enumeration(res);
        }
        return Collections.enumeration(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(File attr) {
        Properties table = new Properties();
        if (attr.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(attr);
                table.load(fileInputStream);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return table;
    }

    private String translateAttributeName(RemoteFileObjectBase file, String attrName) {
        return file.getNameExt() + "[" + attrName + "]";
    }

    private Object decodeValue(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[value.length() / 2];
        int count = 0;
        for (int i = 0; i < value.length(); i += 2) {
            try {
                int tempI = Integer.parseInt(value.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
        try {
            NbObjectInputStream ois = new NbObjectInputStream((InputStream)bis);
            Object ret = ois.readObject();
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String encodeValue(Object value) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] bArray = bos.toByteArray();
        StringBuilder strBuff = new StringBuilder(bArray.length * 2);
        for (int i = 0; i < bArray.length; ++i) {
            if (bArray[i] < 16 && bArray[i] >= 0) {
                strBuff.append("0");
            }
            strBuff.append(Integer.toHexString(bArray[i] < 0 ? bArray[i] + 256 : bArray[i]));
        }
        return strBuff.toString();
    }

    void addReadOnlyConnectNotification(RemoteFileObjectBase fo) {
        if (this.readOnlyConnectNotification.compareAndSet(false, true)) {
            this.remoteFileSupport.addPendingFile(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener) {
        List<FileSystemProvider.FileSystemProblemListener> list = this.problemListeners;
        synchronized (list) {
            this.problemListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener) {
        List<FileSystemProvider.FileSystemProblemListener> list = this.problemListeners;
        synchronized (list) {
            this.problemListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProblemListeners(String path) {
        ArrayList<FileSystemProvider.FileSystemProblemListener> listenersCopy;
        List<FileSystemProvider.FileSystemProblemListener> list = this.problemListeners;
        synchronized (list) {
            listenersCopy = new ArrayList<FileSystemProvider.FileSystemProblemListener>(this.problemListeners);
        }
        for (FileSystemProvider.FileSystemProblemListener l : listenersCopy) {
            if (path == null) {
                l.recovered((FileSystem)this);
                continue;
            }
            l.problemOccurred((FileSystem)this, path);
        }
    }

    static {
        mainLock = new Object();
        locks = new HashMap<File, WeakReference<ReadWriteLock>>();
    }

    private class RemoteFileSupport
    extends ConnectionNotifier.NamedRunnable {
        public RemoteFileSupport() {
            super(NbBundle.getMessage(RemoteFileSupport.class, (String)"RemoteDownloadTask.TITLE", (Object)RemoteFileSystem.this.execEnv.getDisplayName()));
        }

        protected void runImpl() {
            try {
                this.onConnect();
            }
            catch (ConnectException ex) {
                RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)RemoteFileSystem.this.execEnv), ex);
                ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
            }
            catch (InterruptedException ex) {
                RemoteLogger.finest(ex);
            }
            catch (InterruptedIOException ex) {
                RemoteLogger.finest(ex);
            }
            catch (IOException ex) {
                RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)RemoteFileSystem.this.execEnv), ex);
                ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
            }
            catch (ExecutionException ex) {
                RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)RemoteFileSystem.this.execEnv), ex);
                ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
            }
        }

        public String getName() {
            return NbBundle.getMessage(RemoteFileSupport.class, (String)(RemoteFileSystem.this.readOnlyConnectNotification.get() ? "RemoteDownloadTask.TEXT_RO" : "RemoteDownloadTask.TEXT"), (Object)RemoteFileSystem.this.execEnv.getDisplayName());
        }

        private void onConnect() throws InterruptedException, ConnectException, InterruptedIOException, IOException, ExecutionException {
            RemoteFileSystem.this.fireProblemListeners(null);
        }

        public void addPendingFile(RemoteFileObjectBase fo) {
            RemoteLogger.getInstance().log(Level.FINEST, "Adding notification for {0}:{1}", new Object[]{RemoteFileSystem.this.execEnv, fo.getPath()});
            ConnectionNotifier.addTask((ExecutionEnvironment)RemoteFileSystem.this.execEnv, (ConnectionNotifier.NamedRunnable)this);
        }
    }

    private static class RootFileObject
    extends RemoteDirectory {
        private RootFileObject(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, File cache) {
            super(fileSystem, execEnv, null, "", cache);
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public RemoteDirectory getParent() {
            return null;
        }
    }
}

