/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectFile;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class SpecialRemoteFileObject
extends RemoteFileObjectFile {
    private final char fileTypeChar;

    public static SpecialRemoteFileObject createNew(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteDirectory parent, String remotePath, FileInfoProvider.StatInfo.FileType fileType) {
        return new SpecialRemoteFileObject(fileSystem, execEnv, parent, remotePath, fileType);
    }

    private SpecialRemoteFileObject(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteDirectory parent, String remotePath, FileInfoProvider.StatInfo.FileType fileType) {
        super(fileSystem, execEnv, parent, remotePath, null);
        this.fileTypeChar = fileType.toChar();
    }

    @Override
    public final RemoteFileObjectBase[] getChildren() {
        return new RemoteFileObjectBase[0];
    }

    public final boolean isFolder() {
        return false;
    }

    public boolean isData() {
        return true;
    }

    @Override
    public final RemoteFileObjectBase getFileObject(String name, String ext) {
        return null;
    }

    @Override
    public RemoteFileObjectBase getFileObject(String relativePath) {
        return null;
    }

    @Override
    public RemoteDirectory getParent() {
        return (RemoteDirectory)super.getParent();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new ByteArrayInputStream(new byte[0]);
    }

    public FileObject createData(String name, String ext) throws IOException {
        throw new IOException("Unsupported file can not have children");
    }

    public FileObject createFolder(String name) throws IOException {
        throw new IOException("Unsupported file can not have children");
    }

    @Override
    protected void postDeleteChild(FileObject child) {
        RemoteLogger.getInstance().log(Level.WARNING, "postDeleteChild is called on {0}", this.getClass().getSimpleName());
    }

    @Override
    protected void deleteImpl() throws IOException {
        RemoteFileSystemUtils.delete(this.getExecutionEnvironment(), this.getPath(), false);
    }

    @Override
    protected void renameChild(FileLock lock, RemoteFileObjectBase toRename, String newNameExt) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        RemoteLogger.assertTrueInConsole(false, "renameChild is not supported on " + this.getClass() + " path=" + this.getPath());
    }

    @Override
    public OutputStream getOutputStream(FileLock lock) throws IOException {
        if (!this.isValid()) {
            throw new FileNotFoundException("FileObject " + this + " is not valid.");
        }
        return new DelegateOutputStream();
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getType() {
        return FileInfoProvider.StatInfo.FileType.fromChar((char)this.fileTypeChar);
    }

    private class DelegateOutputStream
    extends OutputStream {
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }
    }
}

