/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.EJBVerificationRule;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.modules.j2ee.ejbverification.fixes.ExposeBusinessMethod;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class BusinessMethodExposed
extends EJBVerificationRule {
    @Override
    public Collection<ErrorDescription> check(EJBProblemContext ctx) {
        if (ctx.getEjb() instanceof Session) {
            ArrayList<TypeElement> remoteInterfaces;
            ArrayList<TypeElement> localInterfaces;
            block15: {
                Session session = (Session)ctx.getEjb();
                EjbJar ejbModule = EjbJar.getEjbJar((FileObject)ctx.getFileObject());
                Profile profile = ejbModule.getJ2eeProfile();
                if (Profile.JAVA_EE_6_FULL.equals(profile) || Profile.JAVA_EE_6_WEB.equals(profile)) {
                    int intfCount = 0;
                    try {
                        intfCount = session.getBusinessLocal().length + session.getBusinessRemote().length;
                    }
                    catch (VersionNotSupportedException ex) {
                        // empty catch block
                    }
                    if (intfCount == 0 || JavaUtils.hasAnnotation(ctx.getClazz(), "javax.ejb.LocalBean")) {
                        return null;
                    }
                }
                if (JavaUtils.hasAnnotation(ctx.getClazz(), "javax.jws.WebService")) {
                    return null;
                }
                localInterfaces = new ArrayList<TypeElement>();
                remoteInterfaces = new ArrayList<TypeElement>();
                try {
                    localInterfaces.addAll(this.resolveClasses(ctx.getComplilationInfo(), session.getBusinessLocal()));
                    remoteInterfaces.addAll(this.resolveClasses(ctx.getComplilationInfo(), session.getBusinessRemote()));
                }
                catch (VersionNotSupportedException e) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError();
                }
            }
            ArrayList<ExecutableElement> definedMethods = new ArrayList<ExecutableElement>();
            for (TypeElement iface : localInterfaces) {
                definedMethods.addAll(ElementFilter.methodsIn(iface.getEnclosedElements()));
            }
            for (TypeElement iface : remoteInterfaces) {
                definedMethods.addAll(ElementFilter.methodsIn(iface.getEnclosedElements()));
            }
            HashMap definedMethodsByName = new HashMap();
            for (ExecutableElement method : definedMethods) {
                String hashName = method.getSimpleName().toString();
                if (!definedMethodsByName.containsKey(hashName)) {
                    definedMethodsByName.put(hashName, new ArrayList(1));
                }
                ((ArrayList)definedMethodsByName.get(hashName)).add(method);
            }
            LinkedList<ErrorDescription> problemsFound = new LinkedList<ErrorDescription>();
            for (ExecutableElement method : ElementFilter.methodsIn(ctx.getClazz().getEnclosedElements())) {
                ExposeBusinessMethod fix;
                ArrayList potentialMatches;
                if (!this.isEligibleMethod(method) || (potentialMatches = (ArrayList)definedMethodsByName.get(method.getSimpleName().toString())) != null && !potentialMatches.isEmpty() && this.isFoundMatchingMethodSignature(ctx.getComplilationInfo(), method, potentialMatches)) continue;
                ArrayList<Fix> fixes = new ArrayList<Fix>();
                for (TypeElement iface : localInterfaces) {
                    fix = new ExposeBusinessMethod(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)iface), (ElementHandle<ExecutableElement>)ElementHandle.create((Element)method), true);
                    fixes.add(fix);
                }
                for (TypeElement iface : remoteInterfaces) {
                    fix = new ExposeBusinessMethod(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)iface), (ElementHandle<ExecutableElement>)ElementHandle.create((Element)method), false);
                    fixes.add(fix);
                }
                ErrorDescription err = HintsUtils.createProblem((Element)method, ctx.getComplilationInfo(), NbBundle.getMessage(BusinessMethodExposed.class, (String)"MSG_BusinessMethodExposed"), Severity.HINT, fixes);
                problemsFound.add(err);
            }
            return problemsFound;
        }
        return null;
    }

    private boolean isFoundMatchingMethodSignature(CompilationInfo cinfo, ExecutableElement method, ArrayList<ExecutableElement> potentialMatches) {
        for (ExecutableElement potentialMatch : potentialMatches) {
            if (!JavaUtils.isMethodSignatureSame(cinfo, method, potentialMatch)) continue;
            return true;
        }
        return false;
    }

    private Collection<TypeElement> resolveClasses(CompilationInfo info, String[] classNames) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        if (classNames != null) {
            for (String className : classNames) {
                TypeElement clazz = info.getElements().getTypeElement(className);
                if (clazz == null) continue;
                result.add(clazz);
                this.addInterfaces(info, result, clazz.getInterfaces());
            }
        }
        return result;
    }

    private void addInterfaces(CompilationInfo info, Collection<TypeElement> result, List<? extends TypeMirror> interfaces) {
        for (TypeMirror typeMirror : interfaces) {
            TypeElement te = (TypeElement)info.getTypes().asElement(typeMirror);
            result.add(te);
            this.addInterfaces(info, result, te.getInterfaces());
        }
    }

    private boolean isEligibleMethod(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && this.isContainingKnownClasses(method);
    }

    private boolean isContainingKnownClasses(ExecutableElement method) {
        if (method.getReturnType().getKind() == TypeKind.ERROR) {
            return false;
        }
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            if (typeMirror.getKind() != TypeKind.ERROR) continue;
            return false;
        }
        for (VariableElement variableElement : method.getParameters()) {
            if (variableElement.asType().getKind() != TypeKind.ERROR) continue;
            return false;
        }
        return true;
    }
}

