/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.grammar;

import java.awt.Component;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.netbeans.modules.xml.api.model.DescriptionSource;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class AntGrammar
implements GrammarQuery {
    private static final Logger LOG = Logger.getLogger(AntGrammar.class.getName());
    private static final String[] STOCK_PROPERTY_NAMES = new String[]{"ant.home", "basedir", "ant.file", "ant.project.name", "ant.java.version", "ant.version", "java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"};
    private static final String[] PROPERTY_NAME_VALUED_PROPERTY_NAMES = new String[]{"if", "unless", "property", "failureproperty", "errorproperty", "addproperty"};

    AntGrammar() {
    }

    public Enumeration<GrammarResult> queryEntities(String prefix) {
        ArrayList<MyEntityReference> list = new ArrayList<MyEntityReference>();
        if ("lt".startsWith(prefix)) {
            list.add(new MyEntityReference("lt"));
        }
        if ("gt".startsWith(prefix)) {
            list.add(new MyEntityReference("gt"));
        }
        if ("apos".startsWith(prefix)) {
            list.add(new MyEntityReference("apos"));
        }
        if ("quot".startsWith(prefix)) {
            list.add(new MyEntityReference("quot"));
        }
        if ("amp".startsWith(prefix)) {
            list.add(new MyEntityReference("amp"));
        }
        LOG.log(Level.FINE, "queryEntities({0}) -> {1}", new Object[]{prefix, list});
        return Collections.enumeration(list);
    }

    private static IntrospectedInfo getAntGrammar() {
        return IntrospectedInfo.getKnownInfo();
    }

    static ElementType typeOf(Element e) {
        String name = e.getNodeName();
        Node p = e.getParentNode();
        if (p == null) {
            throw new IllegalArgumentException("Detached node: " + e);
        }
        if (p.getNodeType() == 9) {
            if (name.equals("project")) {
                return new ElementType(Kind.PROJECT, null);
            }
            return null;
        }
        if (p.getNodeType() == 1) {
            String clazz;
            ElementType ptype = AntGrammar.typeOf((Element)p);
            if (ptype == null) {
                return null;
            }
            switch (ptype.kind) {
                case PROJECT: {
                    if (name.equals("description")) {
                        return new ElementType(Kind.DESCRIPTION, null);
                    }
                    if (name.equals("target")) {
                        return new ElementType(Kind.TARGET, null);
                    }
                    if (name.equals("import")) {
                        return new ElementType(Kind.IMPORT, null);
                    }
                    String taskClazz = (String)AntGrammar.getAntGrammar().getDefs("task").get(name);
                    if (taskClazz != null) {
                        return new ElementType(Kind.TASK, taskClazz);
                    }
                    String typeClazz = (String)AntGrammar.getAntGrammar().getDefs("type").get(name);
                    if (typeClazz != null) {
                        return new ElementType(Kind.TYPE, typeClazz);
                    }
                    return null;
                }
                case TARGET: {
                    String taskClazz = (String)AntGrammar.getAntGrammar().getDefs("task").get(name);
                    if (taskClazz != null) {
                        return new ElementType(Kind.TASK, taskClazz);
                    }
                    String typeClazz = (String)AntGrammar.getAntGrammar().getDefs("type").get(name);
                    if (typeClazz != null) {
                        return new ElementType(Kind.TYPE, typeClazz);
                    }
                    return null;
                }
                case DESCRIPTION: {
                    return null;
                }
                case IMPORT: {
                    return null;
                }
            }
            String string = clazz = AntGrammar.getAntGrammar().isKnown(ptype.name) ? (String)AntGrammar.getAntGrammar().getElements(ptype.name).get(name) : null;
            if (clazz != null) {
                return new ElementType(Kind.DATA, clazz);
            }
            return null;
        }
        throw new IllegalArgumentException("Bad parent for " + e.toString() + ": " + p);
    }

    public Enumeration<GrammarResult> queryAttributes(HintContext ctx) {
        LinkedList<String> possibleAttributes;
        Element ownerElement = null;
        if (ctx.getNodeType() == 2) {
            ownerElement = ((Attr)ctx).getOwnerElement();
        } else if (ctx.getNodeType() == 1) {
            ownerElement = (Element)ctx;
        }
        if (ownerElement == null) {
            return Enumerations.empty();
        }
        NamedNodeMap existingAttributes = ownerElement.getAttributes();
        ElementType type = AntGrammar.typeOf(ownerElement);
        if (type == null) {
            return Enumerations.empty();
        }
        switch (type.kind) {
            case PROJECT: {
                possibleAttributes = new LinkedList<String>();
                possibleAttributes.add("default");
                possibleAttributes.add("name");
                possibleAttributes.add("basedir");
                break;
            }
            case TARGET: {
                possibleAttributes = new LinkedList();
                possibleAttributes.add("name");
                possibleAttributes.add("depends");
                possibleAttributes.add("description");
                possibleAttributes.add("if");
                possibleAttributes.add("unless");
                break;
            }
            case DESCRIPTION: {
                return Enumerations.empty();
            }
            case IMPORT: {
                possibleAttributes = new LinkedList();
                possibleAttributes.add("file");
                possibleAttributes.add("optional");
                break;
            }
            default: {
                possibleAttributes = new LinkedList();
                if (type.kind == Kind.TYPE) {
                    possibleAttributes.add("id");
                }
                if (AntGrammar.getAntGrammar().isKnown(type.name)) {
                    possibleAttributes.addAll(new TreeSet(AntGrammar.getAntGrammar().getAttributes(type.name).keySet()));
                }
                if (type.kind != Kind.TASK) break;
                possibleAttributes.add("id");
                possibleAttributes.add("description");
                possibleAttributes.add("taskname");
            }
        }
        String prefix = ctx.getCurrentPrefix();
        ArrayList<MyAttr> list = new ArrayList<MyAttr>();
        for (String attribute : possibleAttributes) {
            if (!attribute.startsWith(prefix) || existingAttributes.getNamedItem(attribute) != null) continue;
            list.add(new MyAttr(attribute));
        }
        LOG.log(Level.FINE, "queryAttributes({0}) -> {1}", new Object[]{prefix, list});
        return Collections.enumeration(list);
    }

    public Enumeration<GrammarResult> queryElements(HintContext ctx) {
        List<Object> elements;
        Node parent = ctx.getParentNode();
        if (parent == null) {
            return Enumerations.empty();
        }
        if (parent.getNodeType() != 1) {
            return Enumerations.empty();
        }
        ElementType type = AntGrammar.typeOf((Element)parent);
        if (type == null) {
            return Enumerations.empty();
        }
        switch (type.kind) {
            case PROJECT: {
                elements = new LinkedList<String>();
                elements.add("target");
                elements.add("import");
                elements.add("property");
                elements.add("description");
                SortedSet<String> tasks = AntGrammar.getSortedDefs("task");
                tasks.remove("property");
                tasks.remove("import");
                elements.addAll(tasks);
                elements.addAll(AntGrammar.getSortedDefs("type"));
                break;
            }
            case TARGET: {
                elements = new ArrayList<String>(AntGrammar.getSortedDefs("task"));
                elements.addAll(AntGrammar.getSortedDefs("type"));
                break;
            }
            case DESCRIPTION: {
                return Enumerations.empty();
            }
            case IMPORT: {
                return Enumerations.empty();
            }
            default: {
                elements = AntGrammar.getAntGrammar().isKnown(type.name) ? new ArrayList(new TreeSet(AntGrammar.getAntGrammar().getElements(type.name).keySet())) : Collections.emptyList();
            }
        }
        String prefix = ctx.getCurrentPrefix();
        ArrayList<MyElement> list = new ArrayList<MyElement>();
        block9: for (final String string : elements) {
            if (!string.startsWith(prefix)) continue;
            switch (type.kind) {
                case PROJECT: 
                case TARGET: {
                    list.add(new MyElement(string){
                        private URL manpage;
                        {
                            super(x0);
                            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                            this.manpage = cl.getResource("org/apache/tools/ant/module/docs/ant-docs/Tasks/" + string + ".html");
                            if (this.manpage == null) {
                                this.manpage = cl.getResource("org/apache/tools/ant/module/docs/ant-docs/Types/" + string + ".html");
                            }
                        }

                        @Override
                        public URL getContentURL() {
                            return this.manpage;
                        }
                    });
                    continue block9;
                }
            }
            list.add(new MyElement(string));
        }
        LOG.log(Level.FINE, "queryElements({0}) -> {1}", new Object[]{prefix, list});
        return Collections.enumeration(list);
    }

    private static SortedSet<String> getSortedDefs(String kind) {
        TreeSet<Object> defs = new TreeSet<Object>(Collator.getInstance());
        defs.addAll(AntGrammar.getAntGrammar().getDefs(kind).keySet());
        return defs;
    }

    public Enumeration<GrammarResult> queryNotations(String prefix) {
        return Enumerations.empty();
    }

    public Enumeration<GrammarResult> queryValues(HintContext ctx) {
        LOG.log(Level.FINE, "queryValues({0})", ctx.getCurrentPrefix());
        if (AntGrammar.canCompleteProperty(ctx.getCurrentPrefix())) {
            LOG.fine("...can complete property");
            return AntGrammar.completeProperties(ctx);
        }
        if (ctx.getNodeType() != 2) {
            LOG.fine("...unknown node type");
            return Enumerations.empty();
        }
        Attr ownerAttr = (Attr)ctx;
        Element ownerElement = ownerAttr.getOwnerElement();
        String attrName = ownerAttr.getName();
        ElementType type = AntGrammar.typeOf(ownerElement);
        if (type == null) {
            LOG.fine("...unknown type");
            return Enumerations.empty();
        }
        ArrayList<String> choices = new ArrayList<String>();
        switch (type.kind) {
            case PROJECT: {
                if (attrName.equals("default") || !attrName.equals("basedir")) break;
                break;
            }
            case TARGET: {
                if (attrName.equals("depends") || !attrName.equals("if") && !attrName.equals("unless")) break;
                choices.addAll(Arrays.asList(AntGrammar.likelyPropertyNames(ctx)));
                break;
            }
            case DESCRIPTION: {
                break;
            }
            case IMPORT: {
                if (attrName.equals("file") || !attrName.equals("optional")) break;
                choices.add("true");
                choices.add("false");
                break;
            }
            default: {
                String[] enumTags;
                String attrClazzName;
                String elementClazz = type.name;
                if (!AntGrammar.getAntGrammar().isKnown(elementClazz) || (attrClazzName = (String)AntGrammar.getAntGrammar().getAttributes(elementClazz).get(attrName)) == null) break;
                if (AntGrammar.getAntGrammar().isKnown(attrClazzName) && (enumTags = AntGrammar.getAntGrammar().getTags(attrClazzName)) != null) {
                    choices.addAll(Arrays.asList(enumTags));
                }
                if (attrClazzName.equals("boolean")) {
                    choices.add("true");
                    choices.add("false");
                    break;
                }
                if (attrClazzName.equals("org.apache.tools.ant.types.Reference") || attrClazzName.equals("org.apache.tools.ant.types.Path") || attrClazzName.equals("java.io.File") || !attrClazzName.equals("java.lang.String") || !Arrays.asList(PROPERTY_NAME_VALUED_PROPERTY_NAMES).contains(attrName)) break;
                choices.addAll(Arrays.asList(AntGrammar.likelyPropertyNames(ctx)));
            }
        }
        String prefix = ctx.getCurrentPrefix();
        ArrayList<MyText> list = new ArrayList<MyText>();
        for (String choice : choices) {
            if (!choice.startsWith(prefix)) continue;
            list.add(new MyText(choice));
        }
        LOG.log(Level.FINE, "queryValues({0}) -> {1}", new Object[]{prefix, list});
        return Collections.enumeration(list);
    }

    private static boolean canCompleteProperty(String content) {
        if ((content = AntGrammar.deletedEscapedShells(content)).length() == 0) {
            return false;
        }
        if (content.charAt(content.length() - 1) == '$') {
            return true;
        }
        int idx = content.lastIndexOf("${");
        return idx != -1 && content.indexOf(125, idx) == -1;
    }

    private static Enumeration<GrammarResult> completeProperties(HintContext ctx) {
        String propPrefix;
        String header;
        String content = ctx.getCurrentPrefix();
        assert (content.length() > 0);
        if (content.charAt(content.length() - 1) == '$') {
            header = content + '{';
            propPrefix = "";
        } else {
            int idx = content.lastIndexOf("${");
            assert (idx != -1);
            header = content.substring(0, idx + 2);
            propPrefix = content.substring(idx + 2);
        }
        String[] props = AntGrammar.likelyPropertyNames(ctx);
        boolean shortHeader = ctx.getNodeType() == 3;
        ArrayList<MyText> list = new ArrayList<MyText>();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].startsWith(propPrefix)) continue;
            String text = header + props[i] + '}';
            if (shortHeader) {
                assert (text.startsWith(content)) : "text=" + text + " content=" + content;
                text = text.substring(content.length());
            }
            list.add(new MyText(text));
        }
        LOG.log(Level.FINE, "completeProperties({0}) -> {1}", new Object[]{content, list});
        return Collections.enumeration(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] likelyPropertyNames(HintContext ctx) {
        Element parent;
        if (ctx.getNodeType() == 2) {
            parent = ((Attr)ctx).getOwnerElement();
        } else {
            if (ctx.getNodeType() != 3) {
                LOG.log(Level.WARNING, "strange context type: {0} {1}", new Object[]{ctx.getNodeType(), ctx});
                return new String[0];
            }
            Node p = ctx.getParentNode();
            if (p == null) {
                return new String[0];
            }
            if (p.getNodeType() != 1) {
                LOG.log(Level.WARNING, "strange parent of text node: {0} {1}", new Object[]{p.getNodeType(), p});
                return new String[0];
            }
            parent = (Element)p;
        }
        while (parent.getParentNode() != null && parent.getParentNode().getNodeType() == 1) {
            parent = (Element)parent.getParentNode();
        }
        TreeSet<String> choices = new TreeSet<String>(Arrays.asList(STOCK_PROPERTY_NAMES));
        AntGrammar.visitForLikelyPropertyNames(parent, choices);
        Iterator it = choices.iterator();
        while (it.hasNext()) {
            String propname = (String)it.next();
            if (propname.indexOf("${") == -1) continue;
            it.remove();
        }
        return choices.toArray(new String[choices.size()]);
    }

    private static void visitForLikelyPropertyNames(Node n, Set<String> choices) {
        short type = n.getNodeType();
        switch (type) {
            case 1: {
                Element el = (Element)n;
                String tagname = el.getTagName();
                if (tagname.equals("property")) {
                    String propname = el.getAttribute("name");
                    if (propname != null && propname.length() > 0) {
                        choices.add(propname);
                    }
                } else if (tagname.equals("buildnumber")) {
                    choices.add("build.number");
                } else if (tagname.equals("tstamp")) {
                    choices.add("DSTAMP");
                    choices.add("TSTAMP");
                    choices.add("TODAY");
                }
                for (int i = 0; i < PROPERTY_NAME_VALUED_PROPERTY_NAMES.length; ++i) {
                    String propname = el.getAttribute(PROPERTY_NAME_VALUED_PROPERTY_NAMES[i]);
                    if (propname == null || propname.length() <= 0) continue;
                    choices.add(propname);
                }
                break;
            }
            case 2: 
            case 3: {
                int end;
                int start;
                String text = AntGrammar.deletedEscapedShells(n.getNodeValue());
                int idx = 0;
                while ((start = text.indexOf("${", idx)) != -1 && (end = text.indexOf(125, start + 2)) != -1) {
                    String propname = text.substring(start + 2, end);
                    if (propname.length() > 0) {
                        choices.add(propname);
                    }
                    idx = end + 1;
                }
                break;
            }
        }
        NodeList l = n.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            AntGrammar.visitForLikelyPropertyNames(l.item(i), choices);
        }
        NamedNodeMap m = n.getAttributes();
        if (m != null) {
            for (int i = 0; i < m.getLength(); ++i) {
                AntGrammar.visitForLikelyPropertyNames(m.item(i), choices);
            }
        }
    }

    private static String deletedEscapedShells(String text) {
        return text.replaceAll("\\$\\$", "");
    }

    public GrammarResult queryDefault(HintContext ctx) {
        return null;
    }

    public boolean isAllowed(Enumeration<GrammarResult> en) {
        return true;
    }

    public Component getCustomizer(HintContext ctx) {
        return null;
    }

    public boolean hasCustomizer(HintContext ctx) {
        return false;
    }

    public Node.Property<?>[] getProperties(HintContext ctx) {
        return null;
    }

    private static class MyText
    extends AbstractResultNode
    implements Text {
        private String data;

        MyText(String data) {
            this.data = data;
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        public String getNodeValue() {
            return this.data;
        }

        @Override
        public String getData() throws DOMException {
            return this.data;
        }

        @Override
        public int getLength() {
            return this.data == null ? -1 : this.data.length();
        }

        public String toString() {
            return this.data;
        }

        @Override
        public String getDisplayName() {
            return this.data;
        }
    }

    private static class MyAttr
    extends AbstractResultNode
    implements Attr {
        private String name;

        MyAttr(String name) {
            this.name = name;
        }

        @Override
        public short getNodeType() {
            return 2;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return null;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class MyElement
    extends AbstractResultNode
    implements Element,
    DescriptionSource {
        private String name;

        MyElement(String name) {
            this.name = name;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public String getTagName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public DescriptionSource resolveLink(String link) {
            return null;
        }

        public boolean isExternal() {
            return false;
        }

        public URL getContentURL() {
            return null;
        }
    }

    private static class MyEntityReference
    extends AbstractResultNode
    implements EntityReference {
        private String name;

        MyEntityReference(String name) {
            this.name = name;
        }

        @Override
        public short getNodeType() {
            return 5;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }
    }

    private static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private AbstractResultNode() {
        }

        public Icon getIcon(int kind) {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public boolean isEmptyElement() {
            return false;
        }
    }

    static class ElementType {
        final Kind kind;
        final String name;

        ElementType(Kind kind, String name) {
            this.kind = kind;
            this.name = name;
        }
    }

    static enum Kind {
        TASK,
        TYPE,
        DATA,
        PROJECT,
        TARGET,
        DESCRIPTION,
        IMPORT;

    }
}

