/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.whitelist.support;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.whitelist.WhiteListQuery;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class WhiteListSupport {
    private static final Logger LOG = Logger.getLogger(WhiteListSupport.class.getName());

    private WhiteListSupport() {
    }

    @CheckForNull
    public static Map<? extends Tree, ? extends WhiteListQuery.Result> getWhiteListViolations(@NonNull CompilationUnitTree unit, @NonNull WhiteListQuery.WhiteList whitelist, @NonNull Trees trees, @NullAllowed Callable<Boolean> cancel) {
        Parameters.notNull((CharSequence)"tree", (Object)unit);
        Parameters.notNull((CharSequence)"whitelist", (Object)whitelist);
        Parameters.notNull((CharSequence)"trees", (Object)trees);
        HashMap result = new HashMap();
        WhiteListScanner scanner = new WhiteListScanner(trees, whitelist, cancel);
        try {
            scanner.scan(unit, result);
            return result;
        }
        catch (WhiteListScanner.Cancel ce) {
            return null;
        }
    }

    private static class WhiteListScanner
    extends TreePathScanner<Void, Map<Tree, WhiteListQuery.Result>> {
        private final Trees trees;
        private final Callable<Boolean> cancel;
        private final WhiteListQuery.WhiteList whiteList;
        private final ArrayDeque<MethodInvocationTree> methodInvocation;

        WhiteListScanner(Trees trees, WhiteListQuery.WhiteList whiteList, Callable<Boolean> cancel) {
            this.trees = trees;
            this.whiteList = whiteList;
            this.cancel = cancel;
            this.methodInvocation = new ArrayDeque();
        }

        @Override
        public Void visitMethod(MethodTree node, Map<Tree, WhiteListQuery.Result> p) {
            LOG.log(Level.FINEST, "Visiting {0}", node);
            this.checkCancel();
            return (Void)super.visitMethod(node, p);
        }

        @Override
        public Void visitClass(ClassTree node, Map<Tree, WhiteListQuery.Result> p) {
            LOG.log(Level.FINEST, "Visiting {0}", node);
            this.checkCancel();
            return (Void)super.visitClass(node, p);
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Map<Tree, WhiteListQuery.Result> p) {
            this.handleNode(node, p);
            return (Void)super.visitIdentifier(node, p);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, Map<Tree, WhiteListQuery.Result> p) {
            this.handleNode(node, p);
            return (Void)super.visitMemberSelect(node, p);
        }

        @Override
        public Void visitNewClass(NewClassTree node, Map<Tree, WhiteListQuery.Result> p) {
            WhiteListQuery.Result res;
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null && !(res = this.whiteList.check(ElementHandle.create((Element)e), WhiteListQuery.Operation.USAGE)).isAllowed()) {
                p.put(node, res);
            }
            this.scan(node.getTypeArguments(), p);
            this.scan(node.getArguments(), p);
            this.scan(node.getClassBody(), p);
            return null;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Map<Tree, WhiteListQuery.Result> p) {
            this.methodInvocation.offerFirst(node);
            super.visitMethodInvocation(node, p);
            this.methodInvocation.removeFirst();
            return null;
        }

        private void handleNode(Tree node, Map<Tree, WhiteListQuery.Result> p) {
            WhiteListQuery.Result res;
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e == null) {
                return;
            }
            ElementKind k = e.getKind();
            Tree toReport = null;
            if (k.isClass() || k.isInterface()) {
                toReport = node;
            } else if (!(k != ElementKind.METHOD && k != ElementKind.CONSTRUCTOR || this.methodInvocation.isEmpty())) {
                toReport = this.methodInvocation.peekFirst();
            }
            if (toReport != null && !(res = this.whiteList.check(ElementHandle.create((Element)e), WhiteListQuery.Operation.USAGE)).isAllowed()) {
                p.put(toReport, res);
            }
        }

        private void checkCancel() {
            if (this.cancel != null) {
                Boolean vote = null;
                try {
                    vote = this.cancel.call();
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                if (vote == Boolean.TRUE) {
                    throw new Cancel();
                }
            }
        }

        static final class Cancel
        extends RuntimeException {
            Cancel() {
            }
        }
    }
}

