/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.j2seplatform.platformdefinition.DefaultPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class J2SEPlatformCustomizer
extends JTabbedPane {
    private static final String CUSTOMIZERS_PATH = "org-netbeans-api-java/platform/j2seplatform/customizers/";
    private static final String SUPPORTS_DEFAULT_PLATFORM = "supportsDefaultPlatform";
    static final int CLASSPATH = 0;
    static final int SOURCES = 1;
    static final int JAVADOC = 2;
    private J2SEPlatformImpl platform;

    public J2SEPlatformCustomizer(J2SEPlatformImpl platform) {
        this.platform = platform;
        this.initComponents();
    }

    private void initComponents() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AN_J2SEPlatformCustomizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_J2SEPlatformCustomizer"));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Classes"), this.createPathTab(0));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Sources"), this.createPathTab(1));
        this.addTab(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Javadoc"), this.createPathTab(2));
        Lookup lkp = Lookups.forPath((String)CUSTOMIZERS_PATH);
        boolean isDefaultPlatform = this.platform instanceof DefaultPlatformImpl;
        for (Lookup.Item li : lkp.lookupResult(Customizer.class).allItems()) {
            Customizer c = (Customizer)li.getInstance();
            if (!(c instanceof Component)) continue;
            String name = li.getId();
            FileObject fo = FileUtil.getConfigFile((String)String.format("%s.instance", name));
            if (fo != null) {
                try {
                    name = fo.getFileSystem().getStatus().annotateName(fo.getName(), Collections.singleton(fo));
                }
                catch (FileStateInvalidException ex) {
                    name = fo.getName();
                }
                if (isDefaultPlatform && fo.getAttribute(SUPPORTS_DEFAULT_PLATFORM) == Boolean.FALSE) continue;
            }
            c.setObject((Object)this.platform);
            this.addTab(name, (Component)((Object)c));
        }
    }

    private JComponent createPathTab(int type) {
        return new PathView(this.platform, type);
    }

    private static class ArchiveFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public ArchiveFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            if (!this.extensions.contains(extension)) {
                return false;
            }
            try {
                return FileUtil.isArchiveFile((URL)f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                Exceptions.printStackTrace((Throwable)e);
                return false;
            }
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static class PathModel
    extends AbstractListModel {
        private J2SEPlatformImpl platform;
        private int type;
        private List<URL> data;

        public PathModel(J2SEPlatformImpl platform, int type) {
            this.platform = platform;
            this.type = type;
        }

        @Override
        public int getSize() {
            return this.getData().size();
        }

        @Override
        public Object getElementAt(int index) {
            List<URL> list = this.getData();
            URL url = list.get(index);
            if ("jar".equals(url.getProtocol())) {
                URL fileURL = FileUtil.getArchiveFile((URL)url);
                if (FileUtil.getArchiveRoot((URL)fileURL).equals(url)) {
                    url = fileURL;
                } else {
                    return url.toExternalForm();
                }
            }
            if ("file".equals(url.getProtocol())) {
                File f = new File(URI.create(url.toExternalForm()));
                return f.getAbsolutePath();
            }
            return url.toExternalForm();
        }

        private void removePath(int[] indices) {
            List<URL> data = this.getData();
            for (int i = indices.length - 1; i >= 0; --i) {
                data.remove(indices[i]);
            }
            this.updatePlatform();
            this.fireIntervalRemoved(this, indices[0], indices[indices.length - 1]);
        }

        private void moveUpPath(int[] indices) {
            List<URL> data = this.getData();
            for (int i = 0; i < indices.length; ++i) {
                URL p2 = data.get(indices[i]);
                URL p1 = data.set(indices[i] - 1, p2);
                data.set(indices[i], p1);
            }
            this.updatePlatform();
            this.fireContentsChanged(this, indices[0] - 1, indices[indices.length - 1]);
        }

        private void moveDownPath(int[] indices) {
            List<URL> data = this.getData();
            for (int i = indices.length - 1; i >= 0; --i) {
                URL p1 = data.get(indices[i]);
                URL p2 = data.set(indices[i] + 1, p1);
                data.set(indices[i], p2);
            }
            this.updatePlatform();
            this.fireContentsChanged(this, indices[0], indices[indices.length - 1] + 1);
        }

        private boolean addPath(File f) {
            try {
                return this.addPath(PathModel.findRoot(f, this.type));
            }
            catch (MalformedURLException mue) {
                return false;
            }
        }

        boolean addPath(URL url) {
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            } else if (!url.toExternalForm().endsWith("/")) {
                try {
                    url = new URL(url.toExternalForm() + "/");
                }
                catch (MalformedURLException mue) {
                    Exceptions.printStackTrace((Throwable)mue);
                }
            }
            List<URL> data = this.getData();
            int oldSize = data.size();
            data.add(url);
            this.updatePlatform();
            this.fireIntervalAdded(this, oldSize, oldSize);
            return true;
        }

        private static URL findRoot(File file, int type) throws MalformedURLException {
            FileObject fo;
            if (type != 0 && (fo = URLMapper.findFileObject((URL)FileUtil.urlForArchiveOrDir((File)file))) != null) {
                try {
                    FileObject result = null;
                    if (type == 1) {
                        result = JavadocAndSourceRootDetection.findSourceRoot((FileObject)fo);
                    } else if (type == 2) {
                        result = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)fo);
                    }
                    if (result != null) {
                        return result.getURL();
                    }
                }
                catch (FileStateInvalidException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            return file.toURI().toURL();
        }

        private synchronized List<URL> getData() {
            if (this.data == null) {
                switch (this.type) {
                    case 0: {
                        this.data = PathModel.getPathList(this.platform.getBootstrapLibraries());
                        break;
                    }
                    case 1: {
                        this.data = PathModel.getPathList(this.platform.getSourceFolders());
                        break;
                    }
                    case 2: {
                        this.data = new ArrayList<URL>(this.platform.getJavadocFolders());
                    }
                }
            }
            return this.data;
        }

        private static List<URL> getPathList(ClassPath cp) {
            ArrayList<URL> result = new ArrayList<URL>();
            for (ClassPath.Entry entry : cp.entries()) {
                result.add(entry.getURL());
            }
            return result;
        }

        private static ClassPath createClassPath(List<URL> roots) {
            ArrayList<PathResourceImplementation> resources = new ArrayList<PathResourceImplementation>();
            for (URL url : roots) {
                resources.add(ClassPathSupport.createResource((URL)url));
            }
            return ClassPathSupport.createClassPath(resources);
        }

        private void updatePlatform() {
            switch (this.type) {
                case 1: {
                    this.platform.setSourceFolders(PathModel.createClassPath(this.data));
                    break;
                }
                case 2: {
                    this.platform.setJavadocFolders(this.data);
                    break;
                }
                default: {
                    assert (false) : "Trying to update unknown property";
                    break;
                }
            }
        }
    }

    private static class PathView
    extends JPanel {
        private JList resources;
        private JButton addButton;
        private JButton addURLButton;
        private JButton removeButton;
        private JButton moveUpButton;
        private JButton moveDownButton;
        private int type;
        private File currentDir;

        public PathView(J2SEPlatformImpl platform, int type) {
            this.type = type;
            this.initComponents(platform);
        }

        private void initComponents(J2SEPlatformImpl platform) {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            String key = null;
            String mneKey = null;
            String ad = null;
            switch (this.type) {
                case 0: {
                    key = "TXT_JDKClasspath";
                    mneKey = "MNE_JDKClasspath";
                    ad = "AD_JDKClasspath";
                    break;
                }
                case 1: {
                    key = "TXT_JDKSources";
                    mneKey = "MNE_JDKSources";
                    ad = "AD_JDKSources";
                    break;
                }
                case 2: {
                    key = "TXT_JDKJavadoc";
                    mneKey = "MNE_JDKJavadoc";
                    ad = "AD_JDKJavadoc";
                    break;
                }
                default: {
                    assert (false) : "Illegal type of panel";
                    return;
                }
            }
            label.setText(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)key));
            label.setDisplayedMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)mneKey).charAt(0));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.insets = new Insets(6, 6, 2, 6);
            c.fill = 2;
            c.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(label, c);
            this.add(label);
            this.resources = new JList(new PathModel(platform, this.type));
            label.setLabelFor(this.resources);
            this.resources.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)ad));
            this.resources.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    PathView.this.selectionChanged();
                }
            });
            JScrollPane spane = new JScrollPane(this.resources);
            spane.setPreferredSize(new Dimension(400, 200));
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 1;
            c.gridheight = 5;
            c.insets = new Insets(0, 6, 6, 6);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(spane, c);
            this.add(spane);
            if (this.type == 1 || this.type == 2) {
                char mne;
                String text;
                this.addButton = new JButton();
                if (this.type == 1) {
                    text = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Add");
                    mne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Add").charAt(0);
                    ad = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Add");
                } else {
                    text = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddZip");
                    mne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_AddZip").charAt(0);
                    ad = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_AddZip");
                }
                this.addButton.setText(text);
                this.addButton.setMnemonic(mne);
                this.addButton.getAccessibleContext().setAccessibleDescription(ad);
                this.addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathView.this.addPathElement();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 1;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(0, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.addButton, c);
                this.add(this.addButton);
                if (this.type == 2) {
                    this.addURLButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddURL"));
                    this.addURLButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_AddURL").charAt(0));
                    this.addURLButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PathView.this.addURLElement();
                        }
                    });
                    c = new GridBagConstraints();
                    c.gridx = 1;
                    c.gridy = 2;
                    c.gridwidth = 0;
                    c.fill = 2;
                    c.anchor = 18;
                    c.insets = new Insets(0, 6, 6, 6);
                    ((GridBagLayout)this.getLayout()).setConstraints(this.addURLButton, c);
                    this.add(this.addURLButton);
                }
                this.removeButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Remove"));
                this.removeButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Remove").charAt(0));
                this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Remove"));
                this.removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathView.this.removePathElement();
                    }
                });
                this.removeButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 3;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.removeButton, c);
                this.add(this.removeButton);
                this.moveUpButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Up"));
                this.moveUpButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Up").charAt(0));
                this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Up"));
                this.moveUpButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathView.this.moveUpPathElement();
                    }
                });
                this.moveUpButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 4;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveUpButton, c);
                this.add(this.moveUpButton);
                this.moveDownButton = new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Down"));
                this.moveDownButton.setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Down").charAt(0));
                this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"AD_Down"));
                this.moveDownButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathView.this.moveDownPathElement();
                    }
                });
                this.moveDownButton.setEnabled(false);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 5;
                c.gridwidth = 0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(5, 6, 6, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveDownButton, c);
                this.add(this.moveDownButton);
            }
        }

        private void addURLElement() {
            JPanel p = new JPanel();
            GridBagLayout lm = new GridBagLayout();
            p.setLayout(lm);
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = -1;
            c.gridx = -1;
            c.insets = new Insets(12, 12, 12, 6);
            c.anchor = 18;
            JLabel label = new JLabel(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddJavadocURLMessage"));
            label.setDisplayedMnemonic('U');
            lm.setConstraints(label, c);
            p.add(label);
            c = new GridBagConstraints();
            c.gridy = -1;
            c.gridx = -1;
            c.gridwidth = 0;
            c.insets = new Insets(12, 0, 12, 6);
            c.fill = 2;
            c.anchor = 18;
            JTextField text = new JTextField();
            text.setColumns(30);
            text.setText(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_DefaultProtocol"));
            text.selectAll();
            label.setLabelFor(text);
            lm.setConstraints(text, c);
            p.add(text);
            Object[] options = new JButton[]{new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddJavadocURLTitle")), new JButton(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_Cancel"))};
            options[0].setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Add").charAt(0));
            options[1].setMnemonic(NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_Cancel").charAt(0));
            DialogDescriptor input = new DialogDescriptor((Object)p, NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_AddJavadocURLTitle"), true, options, (Object)options[0], 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == options[0]) {
                try {
                    String value = text.getText();
                    URL url = new URL(value);
                    ((PathModel)this.resources.getModel()).addPath(url);
                    this.resources.setSelectedIndex(this.resources.getModel().getSize() - 1);
                }
                catch (MalformedURLException mue) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"CTL_InvalidURLFormat"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        }

        private void addPathElement() {
            int firstIndex = this.resources.getModel().getSize();
            File[] cwd = new File[]{this.currentDir};
            if (PathView.select((PathModel)this.resources.getModel(), cwd, this)) {
                int lastIndex = this.resources.getModel().getSize() - 1;
                if (firstIndex <= lastIndex) {
                    int[] toSelect = new int[lastIndex - firstIndex + 1];
                    for (int i = 0; i < toSelect.length; ++i) {
                        toSelect[i] = firstIndex + i;
                    }
                    this.resources.setSelectedIndices(toSelect);
                }
                this.currentDir = cwd[0];
            }
        }

        private static boolean select(PathModel model, File[] currentDir, Component parentComponent) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(true);
            String title = null;
            String message = null;
            String approveButtonName = null;
            String approveButtonNameMne = null;
            if (model.type == 1) {
                title = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenSources");
                message = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Sources");
                approveButtonName = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenSources");
                approveButtonNameMne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_OpenSources");
            } else if (model.type == 2) {
                title = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenJavadoc");
                message = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_Javadoc");
                approveButtonName = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_OpenJavadoc");
                approveButtonNameMne = NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"MNE_OpenJavadoc");
            }
            chooser.setDialogTitle(title);
            chooser.setApproveButtonText(approveButtonName);
            chooser.setApproveButtonMnemonic(approveButtonNameMne.charAt(0));
            chooser.setFileSelectionMode(2);
            if (Utilities.isMac()) {
                chooser.putClientProperty("JFileChooser.packageIsTraversable", "always");
            }
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new ArchiveFileFilter(message, new String[]{"ZIP", "JAR"}));
            if (currentDir[0] != null) {
                chooser.setCurrentDirectory(currentDir[0]);
            }
            if (chooser.showOpenDialog(parentComponent) == 0) {
                File[] fs = chooser.getSelectedFiles();
                boolean addingFailed = false;
                for (File f : fs) {
                    File parent;
                    if (!f.exists() && (parent = f.getParentFile()) != null && f.getName().equals(parent.getName()) && parent.exists()) {
                        f = parent;
                    }
                    if (!f.exists()) continue;
                    addingFailed |= !model.addPath(f);
                }
                if (addingFailed) {
                    new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEPlatformCustomizer.class, (String)"TXT_CanNotAddResolve"), 0);
                }
                currentDir[0] = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
                return true;
            }
            return false;
        }

        private void removePathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.removePath(indices);
            if (indices[indices.length - 1] - indices.length + 1 < this.resources.getModel().getSize()) {
                this.resources.setSelectedIndex(indices[indices.length - 1] - indices.length + 1);
            } else if (indices[0] > 0) {
                this.resources.setSelectedIndex(indices[0] - 1);
            }
        }

        private void moveDownPathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.moveDownPath(indices);
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = indices[i] + 1;
            }
            this.resources.setSelectedIndices(indices);
        }

        private void moveUpPathElement() {
            int[] indices = this.resources.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            PathModel model = (PathModel)this.resources.getModel();
            model.moveUpPath(indices);
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = indices[i] - 1;
            }
            this.resources.setSelectedIndices(indices);
        }

        private void selectionChanged() {
            if (this.type == 0) {
                return;
            }
            int[] indices = this.resources.getSelectedIndices();
            this.removeButton.setEnabled(indices.length > 0);
            this.moveUpButton.setEnabled(indices.length > 0 && indices[0] > 0);
            this.moveDownButton.setEnabled(indices.length > 0 && indices[indices.length - 1] < this.resources.getModel().getSize() - 1);
        }
    }
}

