/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.modules.java.j2seplatform.queries.Bundle;
import org.netbeans.modules.java.j2seplatform.queries.QueriesCache;
import org.netbeans.modules.java.j2seplatform.queries.SourceJavadocAttacherUtil;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public class DefaultSourceJavadocAttacher
implements SourceJavadocAttacherImplementation {
    private static File currentFolder;

    public boolean attachSources(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, 0);
    }

    public boolean attachJavadoc(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, 1);
    }

    private boolean attach(final @NonNull URL root, final @NonNull SourceJavadocAttacher.AttachmentListener listener, final int mode) throws IOException {
        Runnable call = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean success = false;
                try {
                    URL[] toAttach = DefaultSourceJavadocAttacher.selectRoots(root, mode);
                    if (toAttach != null) {
                        switch (mode) {
                            case 0: {
                                QueriesCache.getSources().updateRoot(root, toAttach);
                                break;
                            }
                            case 1: {
                                QueriesCache.getJavadoc().updateRoot(root, toAttach);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(Integer.toString(mode));
                            }
                        }
                        success = true;
                    }
                }
                catch (MalformedURLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                catch (FileStateInvalidException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                finally {
                    SourceJavadocAttacherUtil.callListener(listener, success);
                }
            }
        };
        Mutex.EVENT.writeAccess(call);
        return true;
    }

    private static URL[] selectRoots(URL root, int mode) throws MalformedURLException, FileStateInvalidException {
        List<? extends URI> selected;
        File[] cfh = new File[]{currentFolder};
        if (mode == 0) {
            selected = SourceJavadocAttacherUtil.selectSources(root, SourceJavadocAttacherUtil.createDefaultBrowseCall(Bundle.TXT_Title(), Bundle.TXT_Sources(), cfh), SourceJavadocAttacherUtil.createDefaultURIConvertor(true));
        } else if (mode == 1) {
            selected = SourceJavadocAttacherUtil.selectJavadoc(root, SourceJavadocAttacherUtil.createDefaultBrowseCall(Bundle.TXT_Title(), Bundle.TXT_Javadoc(), cfh), SourceJavadocAttacherUtil.createDefaultURIConvertor(false));
        } else {
            throw new IllegalStateException(Integer.toString(mode));
        }
        if (selected == null) {
            return null;
        }
        currentFolder = cfh[0];
        URL[] result = new URL[selected.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = selected.get(i).toURL();
        }
        return result;
    }
}

