/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.j2seplatform.queries.SourceJavadocAttacherUtil;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class SelectJavadocPanel
extends JPanel
implements ItemListener {
    private final String fileName;
    private final Callable<List<? extends String>> browseCall;
    private final SourceJavadocAttacherUtil.Function<String, Collection<? extends URI>> convertor;
    private JLabel attachLbl;
    private JButton browse;
    private ButtonGroup javadocGroup;
    private JTextField localField;
    private JRadioButton localJavadoc;
    private JTextField remoteField;
    private JRadioButton remoteJavadoc;

    SelectJavadocPanel(@NonNull String displayName, @NonNull Callable<List<? extends String>> browseCall, @NonNull SourceJavadocAttacherUtil.Function<String, Collection<? extends URI>> convertor) {
        assert (displayName != null);
        assert (browseCall != null);
        assert (convertor != null);
        this.fileName = displayName;
        this.browseCall = browseCall;
        this.convertor = convertor;
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.localJavadoc.addItemListener(this);
        this.remoteJavadoc.addItemListener(this);
        this.localJavadoc.setSelected(true);
    }

    @NonNull
    List<URI> getJavadoc() throws Exception {
        if (this.localJavadoc.isSelected()) {
            ArrayList<URI> paths = new ArrayList<URI>();
            String str = this.localField.getText();
            for (String pathElement : str.split(File.pathSeparator)) {
                if ((pathElement = pathElement.trim()).length() <= 0) continue;
                paths.addAll(this.convertor.call(pathElement));
            }
            return paths;
        }
        if (this.remoteJavadoc.isSelected()) {
            return Collections.singletonList(new URI(this.remoteField.getText().trim()));
        }
        throw new IllegalStateException();
    }

    private void initComponents() {
        this.javadocGroup = new ButtonGroup();
        this.localJavadoc = new JRadioButton();
        this.localField = new JTextField();
        this.remoteJavadoc = new JRadioButton();
        this.remoteField = new JTextField();
        this.browse = new JButton();
        this.attachLbl = new JLabel();
        this.javadocGroup.add(this.localJavadoc);
        Mnemonics.setLocalizedText((AbstractButton)this.localJavadoc, (String)NbBundle.getMessage(SelectJavadocPanel.class, (String)"TXT_LocalJavadoc"));
        this.localField.setEditable(false);
        this.javadocGroup.add(this.remoteJavadoc);
        Mnemonics.setLocalizedText((AbstractButton)this.remoteJavadoc, (String)NbBundle.getMessage(SelectJavadocPanel.class, (String)"TXT_RemoteJavadoc"));
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)NbBundle.getMessage(SelectJavadocPanel.class, (String)"TXT_Browse"));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectJavadocPanel.this.browse(evt);
            }
        });
        this.attachLbl.setText(NbBundle.getMessage(SelectJavadocPanel.class, (String)"TXT_AttachJavadocTo", (Object)this.fileName));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attachLbl, -1, 498, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remoteJavadoc).addComponent(this.localJavadoc)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.localField, -1, 231, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browse)).addComponent(this.remoteField, -1, 328, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.attachLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.browse).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localJavadoc).addComponent(this.localField, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteJavadoc).addComponent(this.remoteField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browse(ActionEvent evt) {
        try {
            List<? extends String> paths = this.browseCall.call();
            if (paths != null) {
                StringBuilder sb = new StringBuilder();
                for (String string : paths) {
                    if (sb.length() != 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(string);
                }
                this.localField.setText(sb.toString());
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.localField.setEnabled(this.localJavadoc.isSelected());
        this.browse.setEnabled(this.localJavadoc.isSelected());
        this.remoteField.setEnabled(this.remoteJavadoc.isSelected());
    }
}

