/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.spi;

import java.io.File;
import java.util.prefs.Preferences;
import org.netbeans.modules.versioning.FlatFolder;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.util.NbPreferences;

public final class VersioningSupport {
    public static final String PREF_BOOLEAN_TEXT_ANNOTATIONS_VISIBLE = "textAnnotationsVisible";

    private VersioningSupport() {
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(VersioningSupport.class);
    }

    public static VersioningSystem getOwner(File file) {
        return VersioningManager.getInstance().getOwner(file);
    }

    public static boolean isFlat(File file) {
        return file instanceof FlatFolder;
    }

    public static File getFlat(String path) {
        return new FlatFolder(path);
    }

    public static void versionedRootsChanged() {
        VersioningManager.getInstance().versionedRootsChanged();
    }

    public static boolean isExcluded(File folder) {
        if (folder.getPath().startsWith("\\\\")) {
            return folder.getParent() == null || folder.getParent().equals("\\\\");
        }
        for (File unversionedFolder : Utils.getUnversionedFolders()) {
            if (!Utils.isAncestorOrEqual(unversionedFolder, folder)) continue;
            return true;
        }
        return false;
    }
}

