/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.errors;

import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.impl.indexing.errors.ErrorAnnotator;
import org.openide.filesystems.FileObject;

public class Utilities {
    public static ClassPath getSourceClassPathFor(FileObject file) {
        for (String sourceCP : PathRecognizerRegistry.getDefault().getSourceIds()) {
            ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)sourceCP);
            if (cp == null) continue;
            return cp;
        }
        return null;
    }

    public static Iterable<? extends FileObject> findIndexedRootsUnderDirectory(Project p, FileObject bigRoot) {
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        try {
            Iterable<? extends FileObject> roots = CacheFolder.findRootsWithCacheUnderFolder(bigRoot);
            for (FileObject fileObject : roots) {
                Project curr = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (curr == null || curr.getProjectDirectory() != p.getProjectDirectory() || !PathRegistry.getDefault().getSources().contains(fileObject.getURL())) continue;
                result.add(fileObject);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ErrorAnnotator.class.getName()).log(Level.FINE, null, ex);
        }
        return result;
    }

    private Utilities() {
    }
}

