/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.light;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.websvc.api.support.RefreshCookie;
import org.netbeans.modules.websvc.api.wseditor.InvalidDataException;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.websvc.customization.multiview.WSCustomizationTopComponent;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CustomizationWSEditor
implements WSEditor {
    private WSCustomizationTopComponent wsTopComponent;
    private boolean wsdlIsDirty;
    private Definitions primaryDefinitions;
    private UndoManager undoManager;
    private JAXWSLightSupport jaxWsSupport;
    private JaxWsService service;
    private Map<WSDLModel, Boolean> wsdlModels = new HashMap<WSDLModel, Boolean>();

    public CustomizationWSEditor(JAXWSLightSupport jAXWSLightSupport, JaxWsService jaxWsService) {
        this.jaxWsSupport = jAXWSLightSupport;
        this.service = jaxWsService;
    }

    public CustomizationWSEditor() {
    }

    private void saveAndRefresh(final Node node) {
        Collection<SaveableSectionInnerPanel> collection = this.wsTopComponent.getPanels();
        for (SaveableSectionInnerPanel object2 : collection) {
            object2.save();
            if (this.wsdlIsDirty) continue;
            this.wsdlIsDirty = object2.wsdlIsDirty();
        }
        try {
            Object object;
            if (this.wsdlIsDirty) {
                object = this.wsdlModels.keySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    WSDLModel wSDLModel = (WSDLModel)iterator.next();
                    ModelSource modelSource = wSDLModel.getModelSource();
                    FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie == null) continue;
                    saveCookie.save();
                }
            }
            object = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CustomizationWSEditor.class, (String)"TXT_Refreshing"));
            object.start(100);
            object.switchToIndeterminate();
            Runnable runnable = new Runnable((ProgressHandle)object){
                final /* synthetic */ ProgressHandle val$handle;
                {
                    this.val$handle = progressHandle;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        RefreshCookie refreshCookie;
                        if (CustomizationWSEditor.this.wsdlIsDirty && (refreshCookie = (RefreshCookie)node.getCookie(RefreshCookie.class)) != null) {
                            refreshCookie.refreshService(false);
                        }
                    }
                    finally {
                        this.val$handle.finish();
                    }
                }
            };
            RequestProcessor.getDefault().post(runnable);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public void save(Node node) {
        this.saveAndRefresh(node);
        this.removeListeners();
    }

    public JComponent createWSEditorComponent(Node node) throws InvalidDataException {
        try {
            this.initializeModels(node);
        }
        catch (InvalidDataException invalidDataException) {
            throw invalidDataException;
        }
        catch (Exception exception) {
            Logger.getLogger(CustomizationWSEditor.class.getName()).log(Level.FINE, "Cannot create WSEditor Component", exception);
        }
        this.wsTopComponent = new WSCustomizationTopComponent(node, this.getWSDLModels(), this.primaryDefinitions, true);
        this.wsTopComponent.setName(this.getTitle());
        return this.wsTopComponent;
    }

    public String getTitle() {
        return NbBundle.getMessage(CustomizationWSEditor.class, (String)"TITLE_WSDL_CUSTOMIZATION");
    }

    public Set<WSDLModel> getWSDLModels() {
        return this.wsdlModels.keySet();
    }

    private void initializeModels(Node node) throws IOException, CatalogModelException, InvalidDataException {
        if (this.wsdlModels.isEmpty()) {
            this.undoManager = new UndoManager();
            WSDLModel wSDLModel = this.getPrimaryModel(node);
            this.populateAllModels(wSDLModel);
            Set<WSDLModel> set = this.wsdlModels.keySet();
            for (WSDLModel wSDLModel2 : set) {
                wSDLModel2.addUndoableEditListener((UndoableEditListener)this.undoManager);
            }
        }
    }

    private void removeListeners() {
        Set<WSDLModel> set = this.wsdlModels.keySet();
        for (WSDLModel wSDLModel : set) {
            wSDLModel.removeUndoableEditListener((UndoableEditListener)this.undoManager);
        }
    }

    private DataObject getDataObjectOfModel(WSDLModel wSDLModel) {
        ModelSource modelSource = wSDLModel.getModelSource();
        return (DataObject)modelSource.getLookup().lookup(DataObject.class);
    }

    private boolean modelExists(WSDLModel wSDLModel) {
        if (this.wsdlModels.size() == 0) {
            return false;
        }
        DataObject dataObject = this.getDataObjectOfModel(wSDLModel);
        if (!dataObject.isValid()) {
            return true;
        }
        Set<WSDLModel> set = this.wsdlModels.keySet();
        for (WSDLModel wSDLModel2 : set) {
            DataObject dataObject2 = this.getDataObjectOfModel(wSDLModel2);
            if (!dataObject2.isValid() || !dataObject.equals(dataObject2)) continue;
            return true;
        }
        return false;
    }

    private void populateAllModels(WSDLModel wSDLModel) throws CatalogModelException {
        if (this.modelExists(wSDLModel)) {
            return;
        }
        DataObject dataObject = this.getDataObjectOfModel(wSDLModel);
        if (!dataObject.isValid()) {
            return;
        }
        Definitions definitions = wSDLModel.getDefinitions();
        if (definitions.getImports().size() == 0) {
            this.wsdlModels.put(wSDLModel, dataObject.isModified());
            return;
        }
        this.wsdlModels.put(wSDLModel, dataObject.isModified());
        Set<WSDLModel> set = this.getImportedModels(definitions);
        for (WSDLModel wSDLModel2 : set) {
            this.populateAllModels(wSDLModel2);
        }
    }

    private Set<WSDLModel> getImportedModels(Definitions definitions) throws CatalogModelException {
        HashSet<WSDLModel> hashSet = new HashSet<WSDLModel>();
        Collection collection = definitions.getImports();
        for (Import import_ : collection) {
            WSDLModel wSDLModel = import_.getImportedWSDLModel();
            hashSet.add(wSDLModel);
        }
        return hashSet;
    }

    private WSDLModel getPrimaryModel(Node node) throws MalformedURLException, IOException, InvalidDataException {
        WSDLModel wSDLModel = null;
        FileObject fileObject = null;
        FileObject fileObject2 = this.jaxWsSupport.getWsdlFolder(false);
        if (fileObject2 != null) {
            if (this.jaxWsSupport == null) {
                throw new IOException("Unable to identify node type");
            }
            fileObject = fileObject2.getFileObject(this.service.getLocalWsdl());
            if (fileObject != null) {
                ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
                wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
            } else {
                this.notifyWsdlAbsence();
            }
        } else {
            this.notifyWsdlAbsence();
        }
        this.primaryDefinitions = wSDLModel.getDefinitions();
        return wSDLModel;
    }

    private void notifyWsdlAbsence() throws InvalidDataException {
        throw new InvalidDataException("WSDL not found", NbBundle.getMessage(CustomizationWSEditor.class, (String)"TXT_WsdlNotFound"));
    }

    public void cancel(Node node) {
        if (this.undoManager != null) {
            while (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }
        try {
            Set<WSDLModel> set = this.wsdlModels.keySet();
            for (WSDLModel wSDLModel : set) {
                ModelSource modelSource = wSDLModel.getModelSource();
                FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                dataObject.setModified(this.wsdlModels.get(wSDLModel).booleanValue());
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        this.removeListeners();
    }

    public String getDescription() {
        return NbBundle.getMessage(CustomizationWSEditor.class, (String)"WSDL_CUSTOMIZE_DESC");
    }
}

