/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class GradientBorder
extends AbstractBorder {
    static final Color COLOR_BORDER = new Color(12242416);
    static final Color COLOR_SELECTION = Color.BLUE;
    private static final int INSET_SIZE = 2;
    private static final Insets INSETS = new Insets(2, 2, 2, 2);
    private static final Color COLOR1 = new Color(221, 235, 246, 64);
    private static final Color COLOR2 = new Color(255, 255, 255, 64);
    private static final Color COLOR3 = new Color(214, 235, 255, 64);
    private static final Color COLOR4 = new Color(241, 249, 253, 64);
    private static final Color COLOR5 = new Color(255, 255, 255, 64);
    private boolean isSelected;

    public GradientBorder(boolean isSelected) {
        this.isSelected = isSelected;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D gr = (Graphics2D)g;
        Shape previousClip = gr.getClip();
        gr.clip(new RoundRectangle2D.Float(x, y, width, height, 4.0f, 4.0f));
        Rectangle bounds = new Rectangle(x, y, width, height);
        this.drawGradient(gr, bounds, COLOR1, COLOR2, 0.0f, 0.3f);
        this.drawGradient(gr, bounds, COLOR2, COLOR3, 0.3f, 0.764f);
        this.drawGradient(gr, bounds, COLOR3, COLOR4, 0.764f, 0.927f);
        this.drawGradient(gr, bounds, COLOR4, COLOR5, 0.927f, 1.0f);
        gr.setColor(COLOR_BORDER);
        gr.draw(new RoundRectangle2D.Float((float)x + 0.5f, (float)y + 0.5f, width - 1, height - 1, 4.0f, 4.0f));
        if (this.isSelected) {
            gr.setColor(COLOR_SELECTION);
            gr.drawRect(x + 3, y + 3, width - 7, height - 7);
        }
        gr.setClip(previousClip);
    }

    private void drawGradient(Graphics2D gr, Rectangle bounds, Color color1, Color color2, float y1, float y2) {
        y1 = (float)bounds.y + y1 * (float)bounds.height;
        y2 = (float)bounds.y + y2 * (float)bounds.height;
        gr.setPaint(new GradientPaint(bounds.x, y1, color1, bounds.x, y2, color2));
        gr.fill(new Rectangle2D.Float(bounds.x, y1, bounds.x + bounds.width, y2));
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 2;
        insets.right = 2;
        insets.top = 2;
        insets.left = 2;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

