/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.resource;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceCategoryDescriptor;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.netbeans.modules.vmd.screen.resource.ResourceItemPanel;

public class ResourceCategoryPanel
extends JPanel {
    private static final Color LABEL_COLOR = new Color(0x868686);
    private static final Color BORDER_COLOR = new Color(13355457);
    private static final Color GRADIENT_COLOR = new Color(0xD5D5D5);
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private JLabel label;

    public ResourceCategoryPanel(ScreenResourceCategoryDescriptor category) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBackground(MainPanel.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.label = new JLabel(category.getTitle(), 0){

            @Override
            public void paint(Graphics g) {
                Graphics2D gr = (Graphics2D)g;
                gr.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, this.getHeight(), GRADIENT_COLOR));
                gr.fill(new Rectangle(this.getWidth(), this.getHeight()));
                super.paint(g);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width += 8;
                dimension.height += 8;
                return dimension;
            }
        };
        this.label.setBorder(null);
        this.label.setFont(this.getFont().deriveFont(1));
        this.label.setToolTipText(category.getToolTip());
        this.label.setBackground(null);
        this.label.setForeground(LABEL_COLOR);
        this.label.setOpaque(false);
    }

    public void reload(ArrayList<ScreenResourceItemPresenter> list) {
        this.removeAll();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets = EMPTY_INSETS;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.anchor = 18;
        this.add((Component)this.label, constraints);
        for (ScreenResourceItemPresenter presenter : list) {
            JPanel filler = new JPanel();
            Dimension FILLER_SIZE = new Dimension(0, 1);
            filler.setPreferredSize(FILLER_SIZE);
            filler.setBackground(BORDER_COLOR);
            this.add((Component)filler, constraints);
            ResourceItemPanel item = new ResourceItemPanel(presenter.getRelatedComponent());
            item.reload();
            this.add((Component)item, constraints);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D gr = (Graphics2D)g;
        Shape previousClip = gr.getClip();
        gr.clip(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 8.0f, 8.0f));
        super.paint(g);
        gr.setClip(previousClip);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        Graphics2D gr = (Graphics2D)g;
        gr.setColor(BORDER_COLOR);
        gr.draw(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 8.0f, 8.0f));
    }
}

