/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderLinux;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderSamba;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderSolaris;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProviderWindows;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;

public class HostMappingsAnalyzer {
    private final PlatformInfo secondPI;
    private final PlatformInfo firstPI;
    private Thread thread = null;
    private boolean cancelled = false;
    private final Object lock = new Object();
    private static final List<HostMappingProvider> pairedProviders = new ArrayList<HostMappingProvider>();
    private static final List<HostMappingProvider> singularProviders = new ArrayList<HostMappingProvider>();

    public HostMappingsAnalyzer(ExecutionEnvironment remoteExecEnv) {
        this(remoteExecEnv, ExecutionEnvironmentFactory.getLocal());
    }

    private HostMappingsAnalyzer(ExecutionEnvironment secondEnv, ExecutionEnvironment firstEnv) {
        this.secondPI = PlatformInfo.getDefault((ExecutionEnvironment)secondEnv);
        this.firstPI = PlatformInfo.getDefault((ExecutionEnvironment)firstEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Thread thr;
        Object object = this.lock;
        synchronized (object) {
            thr = this.thread;
        }
        if (thr != null) {
            this.cancelled = true;
            thr.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getMappings() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelled = false;
            this.thread = Thread.currentThread();
        }
        try {
            HashMap<String, String> mappingsFirst2Second = new HashMap<String, String>();
            this.getMappingsImpl(mappingsFirst2Second);
            HashMap<String, String> hashMap = mappingsFirst2Second;
            return hashMap;
        }
        finally {
            Object object2 = this.lock;
            synchronized (object2) {
                this.thread = null;
            }
        }
    }

    private void getMappingsImpl(Map<String, String> mappingsFirst2Second) {
        Map<String, String> firstNetworkNames2Inner = this.populateMappingsList(this.firstPI, this.secondPI);
        if (this.cancelled) {
            return;
        }
        Map<String, String> secondNetworkNames2Inner = this.populateMappingsList(this.secondPI, this.firstPI);
        if (this.cancelled) {
            return;
        }
        if (firstNetworkNames2Inner.size() > 0 && secondNetworkNames2Inner.size() > 0) {
            for (Map.Entry entry : firstNetworkNames2Inner.entrySet()) {
                for (Map.Entry<String, String> secondNetworkName : secondNetworkNames2Inner.entrySet()) {
                    if (!((String)entry.getKey()).equals(secondNetworkName.getKey())) continue;
                    mappingsFirst2Second.put((String)entry.getValue(), secondNetworkName.getValue());
                }
            }
        }
        for (HostMappingProvider hostMappingProvider : singularProviders) {
            Map<String, String> map;
            if (this.cancelled) {
                return;
            }
            if (hostMappingProvider.isApplicable(this.secondPI, this.firstPI)) {
                map = hostMappingProvider.findMappings(this.secondPI.getExecutionEnvironment(), this.firstPI.getExecutionEnvironment());
                mappingsFirst2Second.putAll(map);
            }
            if (this.cancelled) {
                return;
            }
            if (!hostMappingProvider.isApplicable(this.firstPI, this.secondPI)) continue;
            map = hostMappingProvider.findMappings(this.firstPI.getExecutionEnvironment(), this.secondPI.getExecutionEnvironment());
            mappingsFirst2Second.putAll(map);
        }
    }

    private Map<String, String> populateMappingsList(PlatformInfo hostPlatformInfo, PlatformInfo otherPlatformInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (HostMappingProvider prov : pairedProviders) {
            if (this.cancelled) break;
            if (!prov.isApplicable(hostPlatformInfo, otherPlatformInfo)) continue;
            map.putAll(prov.findMappings(hostPlatformInfo.getExecutionEnvironment(), otherPlatformInfo.getExecutionEnvironment()));
        }
        return map;
    }

    static {
        pairedProviders.add(new HostMappingProviderWindows());
        pairedProviders.add(new HostMappingProviderSamba());
        singularProviders.add(new HostMappingProviderSolaris());
        singularProviders.add(new HostMappingProviderLinux());
    }
}

