/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;

public class X11ForwardingChecker {
    private final ExecutionEnvironment execEnv;

    public X11ForwardingChecker(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
    }

    public boolean check() throws IOException, ConnectionManager.CancellationException {
        CndUtils.assertNonUiThread();
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            ConnectionManager.getInstance().connectTo(this.execEnv);
        }
        if (!this.check6000()) {
            return false;
        }
        return this.checkSshdConfig();
    }

    private boolean checkSshdConfig() {
        String x11key = "X11Forwarding";
        RemoteCommandSupport rcs = new RemoteCommandSupport(this.execEnv, "grep -i X11Forwarding /etc/ssh/sshd_config");
        int rc = rcs.run();
        if (rc == 0) {
            String[] lines;
            for (String line : lines = rcs.getOutput().split("\n")) {
                String rest;
                if (!line.startsWith("X11Forwarding") || !"no".equalsIgnoreCase(rest = line.substring("X11Forwarding".length()).trim())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean check6000() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            int port = 6000;
            InetSocketAddress sockaddr = new InetSocketAddress(addr, port);
            Socket sock = new Socket();
            sock.setReuseAddress(true);
            sock.setSoTimeout(1000);
            sock.connect(sockaddr, 1000);
            boolean result = sock.isConnected();
            sock.close();
            return result;
        }
        catch (UnknownHostException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

