/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.List;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.project.api.PhpOptions;

public class DebuggerOptions {
    private static final DebuggerOptions GLOBAL_INSTANCE = new DefaultGlobal();
    int port = -1;
    int maxChildren = -1;
    int maxStructureDepth = -1;
    Boolean debugForFirstPageOnly;
    Boolean debuggerStoppedAtTheFirstLine;
    Boolean requestedUrls;
    Boolean debuggerConsole;
    String phpInterpreter;
    String projectEncoding;
    List<Pair<String, String>> pathMapping;
    Pair<String, Integer> debugProxy;

    public static DebuggerOptions getGlobalInstance() {
        return GLOBAL_INSTANCE;
    }

    public List<Pair<String, String>> getPathMapping() {
        return this.pathMapping;
    }

    public Pair<String, Integer> getDebugProxy() {
        return this.debugProxy;
    }

    public int getPort() {
        return this.port != -1 ? this.port : DebuggerOptions.getGlobalInstance().getPort();
    }

    public int getMaxChildren() {
        return this.maxChildren != -1 ? this.maxChildren : DebuggerOptions.getGlobalInstance().getMaxChildren();
    }

    public int getMaxStructuresDepth() {
        return this.maxStructureDepth != -1 ? this.maxStructureDepth : DebuggerOptions.getGlobalInstance().getMaxStructuresDepth();
    }

    public boolean isDebugForFirstPageOnly() {
        return this.debugForFirstPageOnly != null ? this.debugForFirstPageOnly.booleanValue() : DebuggerOptions.getGlobalInstance().isDebugForFirstPageOnly();
    }

    public boolean showRequestedUrls() {
        return this.requestedUrls != null ? this.requestedUrls.booleanValue() : DebuggerOptions.getGlobalInstance().showRequestedUrls();
    }

    public boolean showDebuggerConsole() {
        return this.debuggerConsole != null ? this.debuggerConsole.booleanValue() : DebuggerOptions.getGlobalInstance().showDebuggerConsole();
    }

    public boolean isDebuggerStoppedAtTheFirstLine() {
        return this.debuggerStoppedAtTheFirstLine != null ? this.debuggerStoppedAtTheFirstLine.booleanValue() : DebuggerOptions.getGlobalInstance().isDebuggerStoppedAtTheFirstLine();
    }

    public String getPhpInterpreter() {
        return this.phpInterpreter != null ? this.phpInterpreter : DebuggerOptions.getGlobalInstance().getPhpInterpreter();
    }

    public String getProjectEncoding() {
        return this.projectEncoding;
    }

    private static class DefaultGlobal
    extends DebuggerOptions {
        @Override
        public int getPort() {
            return PhpOptions.getInstance().getDebuggerPort();
        }

        @Override
        public int getMaxChildren() {
            return PhpOptions.getInstance().getDebuggerMaxChildren();
        }

        @Override
        public int getMaxStructuresDepth() {
            return PhpOptions.getInstance().getDebuggerMaxStructuresDepth();
        }

        @Override
        public boolean isDebugForFirstPageOnly() {
            return false;
        }

        @Override
        public boolean showRequestedUrls() {
            return PhpOptions.getInstance().isDebuggerShowRequestedUrls();
        }

        @Override
        public boolean showDebuggerConsole() {
            return PhpOptions.getInstance().isDebuggerShowDebuggerConsole();
        }

        @Override
        public boolean isDebuggerStoppedAtTheFirstLine() {
            return PhpOptions.getInstance().isDebuggerStoppedAtTheFirstLine();
        }

        @Override
        public String getPhpInterpreter() {
            return PhpOptions.getInstance().getPhpInterpreter();
        }
    }
}

