/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.dbgp.BackendLauncher;
import org.netbeans.modules.php.dbgp.ConnectionErrMessage;
import org.netbeans.modules.php.dbgp.ConversionUtils;
import org.netbeans.modules.php.dbgp.DbgpEngineProvider;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.ServerThread;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.project.api.PhpProjectUtils;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.util.Cancellable;

public class SessionManager {
    private static final String ID = "netbeans-PHP-DBGP-DebugInfo";
    private static final ServerThread serverThread;
    private static final SessionManager INSTANCE;

    public static SessionManager getInstance() {
        return INSTANCE;
    }

    public void startNewSession(Project project, Callable<Cancellable> run, XDebugStarter.Properties properties) {
        assert (properties.startFile != null);
        SessionId sessionId = SessionManager.getSessionId(project);
        if (sessionId == null) {
            sessionId = new SessionId(properties.startFile, project);
            DebuggerOptions options = new DebuggerOptions();
            options.debugForFirstPageOnly = properties.closeSession;
            options.pathMapping = properties.pathMapping;
            options.debugProxy = properties.debugProxy;
            options.projectEncoding = properties.projectEncoding;
            this.startSession(sessionId, options, run);
            long started = System.currentTimeMillis();
            if (!sessionId.isInitialized(true)) {
                ConnectionErrMessage.showMe((int)(System.currentTimeMillis() - started) / 1000);
                return;
            }
        }
    }

    public boolean isAlreadyRunning() {
        return this.getPhpSession() != null;
    }

    public void stopCurrentSession(boolean wait) {
        Session session = this.getPhpSession();
        if (session != null) {
            DebugSession dbgSession = ConversionUtils.toDebugSession(session);
            SessionManager.getInstance().stopSession(session);
            if (wait) {
                dbgSession.waitFinished();
            }
        }
    }

    synchronized Session startSession(SessionId id, DebuggerOptions options, Callable<Cancellable> backendLauncher) {
        DebugSession dbgSession = new DebugSession(options, new BackendLauncher(backendLauncher));
        DebuggerInfo dInfo = DebuggerInfo.create((String)ID, (Object[])new Object[]{id, dbgSession});
        DebuggerManager.getDebuggerManager().startDebugging(dInfo);
        for (Session session : DebuggerManager.getDebuggerManager().getSessions()) {
            DebugSession debugSession = (DebugSession)session.lookupFirst(null, DebugSession.class);
            if (debugSession == null || debugSession != dbgSession) continue;
            dbgSession.setSession(session);
        }
        Session session = dbgSession.getSession();
        if (session != null) {
            serverThread.invokeLater();
        }
        return session;
    }

    public synchronized void stopSession(Session session) {
        SessionId id = (SessionId)session.lookupFirst(null, SessionId.class);
        DebugSession debSess = this.getSession(id);
        if (debSess != null) {
            debSess.stopSession();
        } else {
            SessionManager.stopEngines(session);
        }
    }

    public static void stopEngines(Session session) {
        String[] languages;
        for (String language : languages = session.getSupportedLanguages()) {
            DebuggerEngine engine = session.getEngineForLanguage(language);
            ((DbgpEngineProvider)((Object)engine.lookupFirst(null, DebuggerEngineProvider.class))).getDestructor().killEngine();
        }
        SessionManager.closeServerThread(session);
    }

    public static SessionId getSessionId(Project project) {
        Session[] sessions;
        for (Session session : sessions = DebuggerManager.getDebuggerManager().getSessions()) {
            Project sessionProject;
            SessionId sessionId = (SessionId)session.lookupFirst(null, SessionId.class);
            if (sessionId == null || !project.equals(sessionProject = sessionId.getProject())) continue;
            return sessionId;
        }
        return null;
    }

    public List<DebugSession> findSessionsById(SessionId id) {
        return Collections.singletonList(this.getSession(id));
    }

    public DebugSession getSession(SessionId id) {
        return id != null ? ConversionUtils.toDebugSession(id) : null;
    }

    public static void closeServerThread(Session session) {
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        boolean last = true;
        for (Session sess : sessions) {
            if (sess.equals(session) || sess.lookupFirst(null, SessionId.class) == null) continue;
            last = false;
        }
        if (last) {
            serverThread.cancel();
        }
    }

    private Session getPhpSession() {
        DebuggerManager manager = DebuggerManager.getDebuggerManager();
        Session currentSession = manager.getCurrentSession();
        Session retval = currentSession != null ? this.getPhpSession(new Session[]{currentSession}) : null;
        return retval != null ? retval : this.getPhpSession(manager.getSessions());
    }

    private Session getPhpSession(Session[] sessions) {
        for (Session session : sessions) {
            Project sessionProject;
            SessionId sessionId = (SessionId)session.lookupFirst(null, SessionId.class);
            if (sessionId == null || (sessionProject = sessionId.getProject()) == null || !PhpProjectUtils.isPhpProject((Project)sessionProject)) continue;
            return session;
        }
        return null;
    }

    static {
        INSTANCE = new SessionManager();
        serverThread = new ServerThread();
    }
}

